/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.server.CFService;
import coldfusion.server.ConfigMap;
import coldfusion.server.RegistryService;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.lang.NodeNotFoundException;
import coldfusion.tagext.lang.RegMgr;
import coldfusion.tagext.lang.RegistryException;
import java.io.File;
import java.util.Map;
import java.util.Vector;

public class RegistryServiceImpl
extends ServiceBase
implements RegistryService {
    private File _rfile;
    private File _configFile;
    private RegMgr _rm = null;
    private boolean _isDirtyBit = false;
    private int _timeDelay = 60000;
    private boolean _disabled = false;

    @Override
    public boolean isCrossPlatform() {
        return !this._disabled;
    }

    private boolean IsNativeRegistrySupportAvaible() {
        boolean rc = true;
        try {
            System.load(CFService.getLibPath() + File.separator + "cfregistry.dll");
            System.load(CFService.getLibPath() + File.separator + SystemInfo.getCFXNeoLibName());
        }
        catch (Throwable tLibraryProblem) {
            rc = false;
        }
        return rc;
    }

    public RegistryServiceImpl(File rfile, File config) {
        String os = System.getProperty("os.name");
        if (os.toUpperCase().startsWith("WINDOWS")) {
            if (this.IsNativeRegistrySupportAvaible()) {
                this._disabled = true;
            } else {
                this._rfile = rfile;
                this._configFile = config;
                this._rm = RegMgr.getInstance();
                this._disabled = false;
            }
        } else {
            this._rfile = rfile;
            this._configFile = config;
            this._rm = RegMgr.getInstance();
            this._disabled = false;
        }
    }

    @Override
    public void load() throws ServiceException {
        if (!this._disabled) {
            try {
                Vector v = (Vector)this.deserialize(this._configFile);
                ConfigMap map = (ConfigMap)v.elementAt(0);
                Object obj = map.get("time_delay");
                int t = Integer.parseInt(obj.toString());
                if (t > 60000) {
                    this._timeDelay = t;
                }
                SchedulerService ss = ServiceFactory.getSchedulerService();
                ss.scheduleForShutDown(new FlushRunner());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._rm.load(this._rfile);
        }
    }

    @Override
    public void store() throws ServiceException {
        if (!this._disabled) {
            this._rm.store(this._rfile);
        }
    }

    @Override
    public void stop() throws ServiceException {
        if (!this._disabled) {
            this.store();
        }
    }

    @Override
    public synchronized void clearDirtyBit() {
        this._isDirtyBit = false;
    }

    @Override
    public void flush() {
        try {
            this.store();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void scheduleFlush() {
        if (!this._isDirtyBit) {
            this._isDirtyBit = true;
            SchedulerService ss = ServiceFactory.getSchedulerService();
            ss.schedule(new FlushRunner(), System.currentTimeMillis() + (long)this._timeDelay);
        }
    }

    @Override
    public void set(String branch, String entry, String value, String type) {
        this._rm.set(branch, entry, value, type);
        this.scheduleFlush();
    }

    @Override
    public Map getAll(String branch, String type) {
        Map m = null;
        try {
            m = this._rm.getAll(branch, type);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return m;
    }

    @Override
    public Object get(String branch, String entry, String type) {
        return this._rm.get(branch, entry, type);
    }

    @Override
    public void delete(String branch, String entry) throws RegistryException {
        try {
            this._rm.delete(branch, entry);
            this.scheduleFlush();
        }
        catch (NodeNotFoundException e) {
            throw new RegistryException("Node Not Found");
        }
    }

    @Override
    public Map dump() {
        return this._rm.dump();
    }

    private class FlushRunner
    implements Runnable {
        private FlushRunner() {
        }

        @Override
        public void run() {
            RegistryService rs = ServiceFactory.getRegistryService();
            if (rs != null) {
                rs.flush();
                rs.clearDirtyBit();
            }
        }
    }
}

