/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.NeoException;
import coldfusion.runtime.QueryVector;
import coldfusion.server.RegistryService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.sql.imq.OrderByColumnList;
import coldfusion.tagext.CfxTagBase;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.NativeCfx;
import coldfusion.tagext.lang.RegTable;
import coldfusion.tagext.lang.RegistryException;
import coldfusion.util.FastHashtable;
import com.allaire.cfx.Query;
import jakarta.servlet.jsp.JspException;
import java.security.Permission;
import java.util.Map;

public class RegistryTag
extends CfxTagBase {
    private static final GenericTagPermission tp = new GenericTagPermission("cfregistry");
    private NativeCfx nativeCfx;
    protected String branch = null;
    protected String action = null;
    protected String type = null;
    protected String name = null;
    protected String sort = null;
    protected String variable = null;
    protected String value = null;
    protected String entry = null;
    protected String startrow = null;
    protected String maxrows = null;
    protected String regVersion = null;
    protected FastHashtable att;
    private static String nativeLibrary = "cfregistry";

    @Override
    protected Permission getPermission() {
        return tp;
    }

    @Override
    public void setClass(String o) {
    }

    @Override
    public int doStartTag() throws JspException {
        this.onTagStart();
        RegistryService regs = ServiceFactory.getRegistryService();
        if (regs == null) {
            throw new RegistryException("No Registry Service available");
        }
        if (!regs.isCrossPlatform()) {
            if (this.att != null) {
                if ((this.startrow != null || this.maxrows != null) && this.action.equalsIgnoreCase("GETALL") && !this.type.equalsIgnoreCase("KEY")) {
                    throw new RegistryException("Invalid attribute combination, startrow and maxrows only apply to registry type of key");
                }
            } else {
                throw new RegistryException("No Attribute Found");
            }
            this.setAttributecollection(this.att);
            try {
                if (this.nativeCfx == null) {
                    this.nativeCfx = new NativeCfx(this);
                    this.nativeCfx.setLibrary(nativeLibrary);
                    this.nativeCfx.setCached(true);
                }
                this.nativeCfx.processRequest();
            }
            catch (Exception ex) {
                throw new RegistryException(ex.getMessage());
            }
        }
        String action = (String)this.att.get("action");
        if (action.equalsIgnoreCase("set")) {
            regs.set((String)this.att.get("branch"), (String)this.att.get("entry"), (String)this.att.get("value"), (String)this.att.get("type"));
        } else if (action.equalsIgnoreCase("get")) {
            Object obj = null;
            try {
                String branch = (String)this.att.get("branch");
                if (branch.equalsIgnoreCase("__dump")) {
                    obj = regs.dump();
                    this.pageContext.setAttribute(((String)this.att.get("variable")).toUpperCase(), obj);
                } else {
                    obj = regs.get(branch, (String)this.att.get("entry"), (String)this.att.get("type"));
                    if (obj != null) {
                        this.setVariable(((String)this.att.get("variable")).toUpperCase(), obj.toString());
                    }
                }
            }
            catch (Exception branch) {}
        } else if (action.equalsIgnoreCase("getAll")) {
            try {
                RegTable q;
                String type = (String)this.att.get("type");
                String sort = (String)this.att.get("sort");
                Map m = regs.getAll((String)this.att.get("branch"), type);
                if (m != null) {
                    q = new RegTable();
                    if (type == null) {
                        type = "string";
                    } else if (type.length() == 0) {
                        type = "string";
                    }
                    Map nm = q.filter(m, type);
                    q.populate(nm);
                    if (sort != null) {
                        OrderByColumnList ol = QueryVector.parseSortString(sort);
                        q.sort(ol, false);
                    }
                } else {
                    throw new RegistryException("Cannot open branch " + (String)this.att.get("branch"));
                }
                this.addQuery(((String)this.att.get("name")).toUpperCase(), q);
            }
            catch (Exception exception) {}
        } else if (action.equalsIgnoreCase("delete")) {
            try {
                regs.delete((String)this.att.get("branch"), (String)this.att.get("entry"));
            }
            catch (Exception e) {
                throw new RegistryException("Registry path not found");
            }
        }
        this.onTagEnd();
        return 0;
    }

    public void addQuery(String s, QueryTable q) {
        this.pageContext.setAttribute(s, (Object)q);
    }

    @Override
    public Query addQuery(String name, String[] columns) {
        QueryTable t = new QueryTable(0, columns);
        if (this.sort != null) {
            QueryTableMetaData metaData = new QueryTableMetaData();
            String[] column_label = new String[columns.length];
            int[] column_type = new int[columns.length];
            String[] column_type_names = new String[columns.length];
            boolean[] column_case = new boolean[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                column_label[i] = columns[i];
                column_type[i] = 12;
                column_type_names[i] = "VARCHAR";
                column_case[i] = false;
            }
            metaData.setColumnLabel(column_label);
            metaData.setColumnType(column_type);
            metaData.setColumnCase(column_case);
            metaData.setColumnTypeNames(column_type_names);
            t.setMetaData(metaData);
        }
        QueryVector query = new QueryVector(name, t);
        this.pageContext.setAttribute(name, (Object)t);
        return query;
    }

    @Override
    public Query addQuery(String name, String[] columns, String[] columnTypes) {
        QueryTable t = new QueryTable(0, columns, columnTypes);
        QueryVector query = new QueryVector(name, t);
        this.pageContext.setAttribute(name, (Object)t);
        return query;
    }

    public void setBranch(String b) {
        this.branch = b;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("BRANCH", (Object)this.branch);
    }

    public String getBranch() {
        return this.branch;
    }

    public void setAction(String a) {
        this.action = a;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("ACTION", (Object)this.action);
    }

    public String getAction() {
        return this.action;
    }

    public void setType(String t) {
        this.type = t;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("TYPE", (Object)this.type);
    }

    public String getType() {
        return this.type;
    }

    public void setName(String n) {
        this.name = n;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("NAME", (Object)this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setSort(String s) {
        this.sort = s;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("SORT", (Object)this.sort);
    }

    public String getSort(String s) {
        return this.sort;
    }

    public void setVariable(String v) {
        this.variable = v;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("VARIABLE", (Object)this.variable);
    }

    public String getVariable() {
        return this.variable;
    }

    public void setValue(String v) {
        this.value = v;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("VALUE", (Object)this.value);
    }

    public String getValue() {
        return this.value;
    }

    public void setEntry(String e) {
        this.entry = e;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("ENTRY", (Object)this.entry);
    }

    public String getEntry() {
        return this.entry;
    }

    public void setStartrow(String e) {
        int iStartrow;
        this.startrow = e;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        if ((iStartrow = Integer.parseInt(e) - 1) < 0) {
            throw new RegistryIndexException();
        }
        this.startrow = Integer.toString(iStartrow);
        this.att.put("STARTROW", (Object)this.startrow);
    }

    public String getStartrow() {
        return this.startrow;
    }

    public void setMaxrows(String e) {
        this.maxrows = e;
        if (this.att == null) {
            this.att = new FastHashtable();
        }
        this.att.put("MAXROWS", (Object)this.maxrows);
    }

    public String getMaxrows() {
        return this.maxrows;
    }

    public void setRegistryVersion(String e) {
        String osArch = System.getProperty("os.arch");
        if (osArch.indexOf("64") != -1) {
            this.regVersion = e;
            if (this.att == null) {
                this.att = new FastHashtable();
            }
            if (this.regVersion.equalsIgnoreCase("32")) {
                this.att.put("REGISTRYVERSION", (Object)this.regVersion);
            } else {
                throw new InvalidRegVersionException();
            }
        }
    }

    public String getRegistryVersion() {
        return this.regVersion;
    }

    public class RegistryIndexException
    extends NeoException {
    }

    public class InvalidRegVersionException
    extends NeoException {
    }
}

