/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.lang;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CustomException;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.util.RuntimeWrapper;
import jakarta.servlet.jsp.JspException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class ThrowTag
extends GenericTag {
    protected String type;
    protected String message = "";
    protected String detail = "";
    protected String error_code = "";
    protected String extended_code;
    protected Throwable exception_obj = null;

    protected void validate() throws JspException {
        if ("Database".equalsIgnoreCase(this.type) || "Template".equalsIgnoreCase(this.type) || "Security".equalsIgnoreCase(this.type) || "Object".equalsIgnoreCase(this.type) || "MissingInclude".equalsIgnoreCase(this.type) || "Expression".equalsIgnoreCase(this.type) || "Lock".equalsIgnoreCase(this.type)) {
            if (this.calledName != null) {
                throw new InvalidTagAttributeException("function " + this.calledName, "type", this.type);
            }
            throw new InvalidTagAttributeException("tag CFTHROW", "type", this.type);
        }
    }

    public int doStartTag() throws JspException {
        RuntimeException throwable;
        this.onTagStart();
        this.validate();
        if (this.exception_obj != null) {
            throwable = new RuntimeWrapper(this.exception_obj);
        } else if (this.type == null) {
            throwable = new CustomException("Application", this.message, this.detail, this.error_code, this.extended_code);
        } else {
            try {
                Class c = null;
                c = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().loadClass(this.type) : (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return Thread.currentThread().getContextClassLoader().loadClass(ThrowTag.this.type);
                    }
                });
                Constructor ctor = null;
                try {
                    Class[] ctorArgTypes = new Class[]{String.class};
                    ctor = c.getConstructor(ctorArgTypes);
                    throwable = new RuntimeWrapper((Throwable)ctor.newInstance(this.message));
                }
                catch (Exception ex) {
                    Class[] ctorArgTypes = new Class[]{};
                    ctor = c.getConstructor(ctorArgTypes);
                    throwable = new RuntimeWrapper((Throwable)ctor.newInstance(new Object[0]));
                }
            }
            catch (Exception ex1) {
                throwable = new CustomException(this.type, this.message, this.detail, this.error_code, this.extended_code);
            }
        }
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        if (debuggingService != null && debuggingService.getDebugger() != null) {
            if (debuggingService.check(8)) {
                debuggingService.getDebugger().exception(throwable);
            }
        }
        throw throwable;
    }

    @Override
    public void release() {
        this.type = null;
        this.message = "";
        this.detail = "";
        this.error_code = "";
        this.extended_code = null;
        this.exception_obj = null;
        super.release();
        this.onTagEnd();
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setMessage(String m) {
        this.message = m;
    }

    public void setDetail(String detailMessage) {
        this.detail = detailMessage;
    }

    public void setErrorcode(String code) {
        this.error_code = code;
    }

    public void setExtendedinfo(String ecode) {
        this.extended_code = ecode;
    }

    public void setObject(Object obj) {
        Object temp;
        if (obj instanceof Throwable) {
            this.exception_obj = (Throwable)obj;
        } else if (obj instanceof JavaProxy && (temp = ((JavaProxy)obj).getObject()) instanceof Throwable) {
            this.exception_obj = (Throwable)temp;
        }
    }

    public class InvalidTagAttributeException
    extends ApplicationException {
        public String name;
        public Object value;
        public String tagName;

        public InvalidTagAttributeException(String tagName, String attr, Object val) {
            this.tagName = tagName;
            this.name = attr;
            this.value = val;
        }
    }
}

