/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.tagext.net.HttpTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class HTTPContextSSLFactoryDelegate
extends SSLConnectionSocketFactory {
    public HTTPContextSSLFactoryDelegate(File pKeyFile, String pKeyPassword) {
        super(HTTPContextSSLFactoryDelegate.getSSLContext(pKeyFile, pKeyPassword));
    }

    public HTTPContextSSLFactoryDelegate() {
        super(SSLContexts.createDefault());
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        String clientCert;
        if (context != null && (clientCert = (String)context.getAttribute("clientcert")) != null) {
            SSLConnectionSocketFactory sslConnFactory = new SSLConnectionSocketFactory(HTTPContextSSLFactoryDelegate.getSSLContext(new File(clientCert), (String)context.getAttribute("clientcertpassword")));
            return sslConnFactory.createLayeredSocket(socket, target, port, context);
        }
        return super.createLayeredSocket(socket, target, port, context);
    }

    private static SSLContext getSSLContext(File pKeyFile, String pKeyPassword) {
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            KeyStore keyStore = null;
            keyStore = keyManagerAlgorithm.equals("SunX509") ? KeyStore.getInstance("PKCS12", keyManagerFactory.getProvider()) : KeyStore.getInstance("PKCS12");
            FileInputStream keyInput = new FileInputStream(pKeyFile);
            keyStore.load(keyInput, pKeyPassword.toCharArray());
            ((InputStream)keyInput).close();
            keyManagerFactory.init(keyStore, pKeyPassword.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            throw new HttpTag.HttpBadCertificateException(e);
        }
    }
}

