/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.log.Logger;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.CFHTTPClientWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class HTTPPoolIdleConnectionMonitorThread
extends Thread {
    private static final Logger httpTagLog = ServiceFactory.getLoggingService().getLogger("coldfusion.http");
    private List<CFHTTPClientWrapper> httpPools = new ArrayList<CFHTTPClientWrapper>();
    private volatile boolean shutdown;
    private int waitTime;
    private volatile boolean allPoolsclosed = false;

    public HTTPPoolIdleConnectionMonitorThread(int waitTime) {
        this.waitTime = waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                while (!this.shutdown) {
                    HTTPPoolIdleConnectionMonitorThread hTTPPoolIdleConnectionMonitorThread = this;
                    synchronized (hTTPPoolIdleConnectionMonitorThread) {
                        this.wait(this.waitTime);
                        Iterator<CFHTTPClientWrapper> itr = this.httpPools.iterator();
                        while (itr.hasNext()) {
                            CFHTTPClientWrapper next = itr.next();
                            if (next.isClosed()) {
                                itr.remove();
                                continue;
                            }
                            PoolingHttpClientConnectionManager connMgr = next.getConnMgr();
                            try {
                                connMgr.closeExpiredConnections();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                connMgr.closeIdleConnections((long)next.getMaxIdleTimeout(), TimeUnit.MILLISECONDS);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                this.closeAll();
            }
            catch (InterruptedException ex) {
                httpTagLog.debug(ex);
                if (this.allPoolsclosed) break block12;
                this.closeAll();
            }
        }
    }

    public synchronized void addPool(CFHTTPClientWrapper pool) {
        if (!this.shutdown) {
            this.httpPools.add(pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        HTTPPoolIdleConnectionMonitorThread hTTPPoolIdleConnectionMonitorThread = this;
        synchronized (hTTPPoolIdleConnectionMonitorThread) {
            this.notifyAll();
        }
    }

    protected synchronized void closeAll() {
        for (CFHTTPClientWrapper next : this.httpPools) {
            if (!next.isClosed()) continue;
            try {
                next.close();
            }
            catch (IOException e) {
                httpTagLog.error(e);
            }
        }
        this.httpPools = null;
        this.allPoolsclosed = true;
    }
}

