/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.log.Logger;
import coldfusion.runtime.StructUtils;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.net.CFHTTPClientWrapper;
import coldfusion.tagext.net.HTTPContextSSLFactoryDelegate;
import coldfusion.tagext.net.HTTPPoolIdleConnectionMonitorThread;
import coldfusion.tagext.net.HttpTag;
import coldfusion.tagext.validation.IllegalAttributeValueException;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.wddx.Base64Encoder;
import java.io.File;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;

public final class HTTPPoolTag
extends GenericTag {
    private static final PoolStats DEFAULT_SYSTEM_POOL_STATS = new PoolStats(0, 0, 0, 0);
    public static final int DEFAULT_MAX_TOTAL = 200;
    public static final int DEFAULT_MAX_PER_ROUTE = 20;
    public static final long serialVersionUID = 1L;
    public static final int DEF_PORT = 80;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final int DEFAULT_POOL_TIMEOUT = -1;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    private static final String USER_AGENT = "User-Agent";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static boolean systemProxyIsSet = Utils.checkSystemHTTPProxyIsSet();
    private static Logger httpTagLog;
    private static final GenericTagPermission tp;
    private static final List<String> POSSIBLE_COOKIE_SPEC_VALUES;
    private String name;
    private int maxTotal = 200;
    private int maxPerRoute = 20;
    private Map<String, Integer> hostMaxPerRoute;
    private Map<String, SocketConfig> hostsSocketConfig;
    private int timeout = 60000;
    private int idleTimeout = 30000;
    private String proxyServer;
    private int proxyPort = 80;
    private String proxyUser;
    private String proxyPassword;
    private String userAgent = null;
    private String clientCert;
    private String clientCertPassword;
    private boolean useSystemProperties = true;
    private String action;
    private String result;
    private String cookieSpec = "ignoreCookies";
    private static final HTTPPoolIdleConnectionMonitorThread poolMonitor;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute;
    }

    public void setMaxPerRoute(int maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
    }

    public void setHostMaxPerRoute(Map<String, Integer> hostMaxPerRoute) {
        this.hostMaxPerRoute = hostMaxPerRoute;
    }

    Map<String, SocketConfig> getHostsSocketConfig() {
        return this.hostsSocketConfig;
    }

    public void setHostsSocketConfig(Map<String, SocketConfig> hostsSocketConfig) {
        this.hostsSocketConfig = hostsSocketConfig;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getClientCert() {
        return this.clientCert;
    }

    public void setClientCert(String clientCert) {
        this.clientCert = clientCert;
    }

    public String getClientCertPassword() {
        return this.clientCertPassword;
    }

    public void setClientCertPassword(String clientCertPassword) {
        this.clientCertPassword = clientCertPassword;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public void setCookieSpec(String cookieSpec) {
        if (!POSSIBLE_COOKIE_SPEC_VALUES.contains(cookieSpec.toLowerCase())) {
            throw new IllegalAttributeValueException("CFHTTPPOOL", "COOKIESPEC", RB.getString(HTTPPoolTag.class, "HTTPPoolTag.IllegalCookieSpecValue"));
        }
        this.cookieSpec = cookieSpec;
    }

    @Override
    public void release() {
        this.name = null;
        this.maxTotal = 200;
        this.maxPerRoute = 20;
        this.hostMaxPerRoute = null;
        this.hostsSocketConfig = null;
        this.timeout = 60000;
        this.idleTimeout = 30000;
        this.proxyServer = null;
        this.proxyPort = 80;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.userAgent = null;
        this.clientCert = null;
        this.clientCertPassword = null;
        this.useSystemProperties = true;
        this.action = null;
        this.result = null;
    }

    public int doStartTag() {
        this.onTagStart();
        if (this.action.equalsIgnoreCase("create")) {
            CFHTTPClientWrapper poolWrapper = this.createPool();
            this.pageContext.setAttribute(this.name, (Object)poolWrapper);
        } else if (this.action.equalsIgnoreCase("close")) {
            CFHTTPClientWrapper poolWrapper = (CFHTTPClientWrapper)this.pageContext.getAttribute(this.name);
            if (poolWrapper != null && !poolWrapper.isClosed()) {
                try {
                    poolWrapper.close();
                }
                catch (IOException e) {
                    httpTagLog.error(e);
                }
            }
        } else if (this.action.equalsIgnoreCase("stats")) {
            CFHTTPClientWrapper poolWrapper = (CFHTTPClientWrapper)this.pageContext.getAttribute(this.name);
            if (poolWrapper != null) {
                PoolingHttpClientConnectionManager connManager = poolWrapper.getConnMgr();
                this.pageContext.setAttribute(this.result, (Object)this.getPoolStats(connManager.getTotalStats(), poolWrapper.isClosed()));
            }
        } else if (this.action.equalsIgnoreCase("stats-system")) {
            CFHTTPClientWrapper poolWrapper = HttpTag.getDefaultPool();
            PoolStats stats = poolWrapper != null ? poolWrapper.getConnMgr().getTotalStats() : DEFAULT_SYSTEM_POOL_STATS;
            this.pageContext.setAttribute(this.result, (Object)this.getPoolStats(stats, poolWrapper != null ? poolWrapper.isClosed() : false));
        }
        return 0;
    }

    CFHTTPClientWrapper createPool() {
        if (this.maxPerRoute > this.maxTotal) {
            throw new IllegalAttributeValueException("CFHTTPPOOL", "MAXPERROUTE", RB.getString(HTTPPoolTag.class, "HTTPPoolTag.maxPerRouteBiggerThanMaxTotal"));
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)this.getSSLFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(this.maxTotal);
        connManager.setDefaultMaxPerRoute(this.maxPerRoute);
        if (this.hostMaxPerRoute != null && this.hostMaxPerRoute.size() > 0) {
            for (Map.Entry<String, Integer> entry : this.hostMaxPerRoute.entrySet()) {
                HttpHost host = HttpHost.create((String)entry.getKey());
                connManager.setMaxPerRoute(new HttpRoute(host), entry.getValue().intValue());
            }
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).setConnectionRequestTimeout(this.timeout);
        if (this.proxyServer != null && this.proxyServer.trim().length() != 0) {
            HttpHost proxy = new HttpHost(this.proxyServer, this.proxyPort);
            requestConfigBuilder.setProxy(proxy);
        }
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        if (this.proxyServer != null || systemProxyIsSet || this.proxyUser != null) {
            String auth;
            String string = auth = this.proxyPassword == null ? this.proxyUser : this.proxyUser + ":" + this.proxyPassword;
            if (auth != null) {
                defaultHeaders.add(new BasicHeader(PROXY_AUTHORIZATION, "Basic " + Base64Encoder.encode(auth.getBytes())));
            }
        }
        if (this.userAgent != null) {
            defaultHeaders.add(new BasicHeader(USER_AGENT, this.userAgent));
        }
        HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
        if (defaultHeaders.size() > 0) {
            clientBuilder = clientBuilder.setDefaultHeaders(defaultHeaders);
        }
        if (this.useSystemProperties) {
            clientBuilder = clientBuilder.useSystemProperties();
        }
        if (this.cookieSpec.equalsIgnoreCase("ignoreCookies")) {
            clientBuilder = clientBuilder.disableCookieManagement();
            requestConfigBuilder = requestConfigBuilder.setCookieSpec("ignoreCookies");
        } else {
            requestConfigBuilder = requestConfigBuilder.setCookieSpec(this.cookieSpec);
        }
        clientBuilder = clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build()).setRedirectStrategy((org.apache.http.client.RedirectStrategy)new RedirectStrategy());
        CFHTTPClientWrapper poolWrapper = new CFHTTPClientWrapper(clientBuilder.build(), connManager, this.idleTimeout);
        poolMonitor.addPool(poolWrapper);
        return poolWrapper;
    }

    private SSLConnectionSocketFactory getSSLFactory() {
        if (this.clientCert != null) {
            return new HTTPContextSSLFactoryDelegate(new File(this.clientCert), this.clientCertPassword);
        }
        return new HTTPContextSSLFactoryDelegate();
    }

    private Map getPoolStats(PoolStats poolStats, boolean isClosed) {
        Map stats = StructUtils.StructNewOrdered();
        stats.put("available ", poolStats.getAvailable());
        stats.put("leased", poolStats.getLeased());
        stats.put("max", poolStats.getMax());
        stats.put("pending", poolStats.getPending());
        stats.put("closed", isClosed);
        return stats;
    }

    static {
        tp = new GenericTagPermission("cfhttppool");
        POSSIBLE_COOKIE_SPEC_VALUES = Arrays.asList("ignoreCookies", "default", "standard", "standard-strict");
        httpTagLog = ServiceFactory.getLoggingService().getLogger("coldfusion.http");
        poolMonitor = new HTTPPoolIdleConnectionMonitorThread(30000);
        poolMonitor.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                poolMonitor.shutdown();
            }
        });
    }

    private static class RedirectStrategy
    extends DefaultRedirectStrategy {
        private RedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            if (context.getAttribute("redirect") == null) {
                return false;
            }
            if (context.getAttribute("ntlm") != null) {
                return super.isRedirected(request, response, context);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            String method = request.getRequestLine().getMethod();
            switch (statusCode) {
                case 302: {
                    Header locationHeader = response.getFirstHeader("location");
                    return this.isRedirectable(method) && locationHeader != null;
                }
                case 301: 
                case 307: {
                    return method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD");
                }
                case 303: {
                    return true;
                }
            }
            return false;
        }

        protected boolean isRedirectable(String method) {
            return HttpTag.redirectMethods.contains(method.toUpperCase());
        }
    }
}

