/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.TemplateException;
import coldfusion.server.RuntimeService;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.net.ThreadRequestException;
import coldfusion.util.Utils;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspException;
import java.io.UnsupportedEncodingException;

public class HeaderTag
extends GenericTag {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String value;
    protected int statusCode;
    private String charset;
    protected boolean statusSet = false;

    public void setName(String s) {
        this.name = s;
    }

    public void setValue(String s) {
        this.value = Utils.stripCRLF(s);
    }

    public void setStatuscode(int c) {
        this.statusCode = c;
        this.statusSet = true;
    }

    public void setCharset(String charset) {
        this.charset = Utils.stripCRLF(charset);
    }

    @Override
    public void release() {
        this.name = null;
        this.value = null;
        this.statusCode = 0;
        this.statusSet = false;
        this.charset = null;
        super.release();
        this.onTagEnd();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        FusionContext ctx = FusionContext.getCurrent();
        if (ctx.pageContext.isUnderCFThread() && ctx.getState() == null) {
            throw new ThreadRequestException("header");
        }
        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
        if (res.isCommitted()) {
            throw new InvalidHeaderException();
        }
        if (this.name != null) {
            if (this.name.toLowerCase().contains("set-cookie")) {
                if ((this.value.toUpperCase().startsWith("CFID=") || this.value.toUpperCase().startsWith("CFTOKEN=")) && this.getApplicationSettingsObject().isSessionCookieUpdateDisabled()) {
                    throw new InvalidOperationException();
                }
                if (this.value.toUpperCase().startsWith("CFAUTHORIZATION") && this.getApplicationSettingsObject().isAuthCookieUpdateDisabled()) {
                    throw new InvalidOperationException();
                }
            }
            if (this.charset == null && this.name.equalsIgnoreCase("content-disposition")) {
                this.charset = RuntimeService.defaultFileCharset;
            }
            if (this.charset != null) {
                try {
                    this.value = new String(this.value.getBytes(this.charset), "ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedCharsetException(this.charset);
                }
            }
            if (this.name.equalsIgnoreCase("content-type")) {
                res.setContentType(this.value);
            } else {
                res.addHeader(this.name, this.value);
            }
        }
        if (this.statusSet) {
            res.setStatus(this.statusCode);
            if (this.statusCode == 204) {
                res.setContentLength(0);
                res.addHeader("Content-Length", "0");
            }
        }
        return 0;
    }

    private ApplicationSettings getApplicationSettingsObject() {
        ApplicationScope appScope;
        FusionContext context = FusionContext.getCurrent();
        if (context == null) {
            return null;
        }
        String appName = context.getApplicationName();
        if (appName != null && (appScope = ApplicationScopeTracker.getApplicationScope(appName)) != null) {
            ApplicationSettings appSettings = appScope.getApplicationSettings();
            return appSettings;
        }
        return null;
    }

    public static class InvalidHeaderException
    extends TemplateException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidOperationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class UnsupportedCharsetException
    extends InvalidTagAttributeException {
        private static final long serialVersionUID = 1L;
        private String charset;

        UnsupportedCharsetException(String charset) {
            super("cfheader", "charset", charset);
            this.charset = charset;
        }

        public String getCharSet() {
            return this.charset;
        }
    }
}

