/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.HttpTableMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;

class HttpTable
extends QueryTable {
    HttpTable() {
    }

    public void populate(String page, char delim, char textQual, boolean firstrow) throws SQLException {
        this.populate(page, delim, textQual, null, firstrow);
    }

    private int getQuoteCount(String s) {
        int count = 0;
        for (char ch : s.toCharArray()) {
            if (ch != '\"') continue;
            ++count;
        }
        return count;
    }

    private String getCompleteRow(String line, StringTokenizer pageTokenizer) {
        String tempLine;
        for (int quoteCount = this.getQuoteCount((String)line); pageTokenizer.hasMoreTokens() && quoteCount > 0 && quoteCount % 2 != 0; quoteCount += this.getQuoteCount(tempLine)) {
            tempLine = pageTokenizer.nextToken();
            line = (String)line + tempLine;
        }
        return line;
    }

    public void populate(String page, char delim, char textQual, String[] columns, boolean first) throws SQLException {
        String firstLine = null;
        ArrayList columnList = new ArrayList();
        page = page.trim();
        String lineDelimiters = new String(new char[]{'\n', '\r'});
        StringTokenizer pageTokenizer = new StringTokenizer(page, lineDelimiters, true);
        if (columns == null) {
            firstLine = pageTokenizer.nextToken();
            firstLine = this.getCompleteRow(firstLine, pageTokenizer);
            ArrayList possibleColumnNames = this.processLine(firstLine, delim, textQual);
            this.col_count = possibleColumnNames.size();
            if (first) {
                columnList = possibleColumnNames;
            } else {
                for (int i = 0; i < this.col_count; ++i) {
                    columnList.add("Column_" + String.valueOf(i + 1));
                }
            }
        } else {
            if (first) {
                pageTokenizer.nextToken();
            }
            this.col_count = columns.length;
            for (int i = 0; i < columns.length; ++i) {
                columnList.add(columns[i]);
            }
        }
        this.col_names = new String[this.col_count];
        for (int i = 0; i < columnList.size(); ++i) {
            Object name = (String)columnList.get(i);
            if (!this.isValidName((String)name)) {
                throw new QueryFunction.QueryColumnNameException((String)name);
            }
            for (int j = 0; j < i; ++j) {
                if (!this.col_names[j].equals(name)) continue;
                name = (String)name + "_";
            }
            this.col_names[i] = name;
        }
        this.meta = new HttpTableMetaData(this.col_count, this.col_names);
        if (firstLine != null && !first) {
            ArrayList rowData = this.processLine(firstLine, delim, textQual);
            if (rowData.size() != this.col_count) {
                throw new SQLException();
            }
            this.addRow(rowData.toArray());
        }
        while (pageTokenizer.hasMoreTokens()) {
            this.checkTimeout();
            String nextLine = pageTokenizer.nextToken();
            if (nextLine.trim().length() == 0) continue;
            ArrayList rowData = this.processLine(nextLine = this.getCompleteRow(nextLine, pageTokenizer), delim, textQual);
            if (rowData.size() != this.col_count) {
                throw new SQLException();
            }
            this.addRow(rowData.toArray());
        }
    }

    private ArrayList processLine(String line, char delim, char textQual) {
        ArrayList<String> rowData = new ArrayList<String>();
        int start = 0;
        int index = 0;
        while (index <= line.length()) {
            boolean inQuotes = false;
            while (index < line.length()) {
                char c = line.charAt(index);
                if (!inQuotes && c == delim) break;
                if (c == textQual) {
                    inQuotes = !inQuotes;
                }
                ++index;
            }
            String columnValue = line.substring(start, index);
            if ((columnValue = columnValue.trim()).length() > 0 && columnValue.charAt(0) == textQual && columnValue.charAt(columnValue.length() - 1) == textQual) {
                columnValue = columnValue.substring(1, columnValue.length() - 1);
            }
            columnValue = this.removeEscapedQualifier(columnValue, textQual);
            rowData.add(columnValue);
            start = ++index;
        }
        return rowData;
    }

    private String removeEscapedQualifier(String s, char textQual) {
        if (s.indexOf(textQual) == -1) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length());
        boolean found = false;
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (!found && c[i] == textQual) {
                found = true;
                continue;
            }
            found = false;
            buf.append(c[i]);
        }
        return buf.toString();
    }

    public boolean isValidName(String s) {
        if (s.length() == 0 || !Character.isLetter(s.charAt(0))) {
            return false;
        }
        char[] charArray = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLetterOrDigit(charArray[i]) || charArray[i] == '_') continue;
            return false;
        }
        return true;
    }

    public void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException("cfhttp");
        }
    }
}

