/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.net.LdapTag;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class LdapCustomSSLFactory
extends SSLSocketFactory {
    private static final String JKS_TYPE = "jks";
    private static final String PKCS12_TYPE = "pkcs12";
    private SSLSocketFactory factory;

    public LdapCustomSSLFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            KeyManager[] kms = this.getKeyManagers();
            sslcontext.init(kms, null, new SecureRandom());
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    public static SSLSocketFactory getDefault() {
        return new LdapCustomSSLFactory();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s, i, flag);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.factory.createSocket(inaddr, i, inaddr1, j);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.factory.createSocket(inaddr, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this.factory.createSocket(s, i, inaddr, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.factory.createSocket(s, i);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public Socket createSocket(Socket socket, InputStream is, boolean flag) throws IOException {
        return this.factory.createSocket(socket, is, flag);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    protected KeyManager[] getKeyManagers() throws IOException, GeneralSecurityException {
        LdapTag.LdapThreadLocal keystoreDetail = LdapTag.LdapThreadLocal.get();
        if (keystoreDetail != null && keystoreDetail.getKeystorePath() != null && keystoreDetail.getKeystorePassword() != null) {
            String pKeyFile = keystoreDetail.getKeystorePath();
            String pKeyPassword = keystoreDetail.getKeystorePassword();
            String alg = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(alg);
            KeyStore keyStore = this.getKeyStore(pKeyFile, pKeyPassword);
            keyManagerFactory.init(keyStore, pKeyPassword.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        throw new LdapTag.LdapBadCertificateException();
    }

    private KeyStore getKeyStore(String keystoreFile, String keystorePassword) {
        try {
            return this.getKeyStore(keystoreFile, keystorePassword, PKCS12_TYPE);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return this.getKeyStore(keystoreFile, keystorePassword, JKS_TYPE);
            }
            catch (ApplicationException e1) {
                throw e1;
            }
            catch (Throwable t) {
                throw new InvalidKeystoreException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(String keystoreFile, String keystorePassword, String storeType) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(keystoreFile);
            KeyStore keystore = KeyStore.getInstance(storeType);
            keystore.load(fis, keystorePassword.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
    }

    public static class InvalidKeystoreException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public InvalidKeystoreException(Throwable e) {
            super(e);
        }
    }
}

