/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.LdapTableMetaData;
import coldfusion.tagext.net.LdapTagException;
import coldfusion.util.URLDecoder;
import jakarta.servlet.jsp.JspException;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;

public class LdapResultTable
extends QueryTable {
    private String correctName(String inpStr) {
        StringTokenizer t = new StringTokenizer(inpStr, ",");
        Object opStr = "";
        int i = 0;
        while (t.hasMoreTokens()) {
            if (i != 0) {
                opStr = (String)opStr + ", ";
            }
            opStr = (String)opStr + URLDecoder.decode(t.nextToken().trim());
            ++i;
        }
        return opStr;
    }

    public void populate(NamingEnumeration results, String[] columns, int maxrows, int startrow, String start, String separator) throws JspException {
        this.meta = new LdapTableMetaData(columns);
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (columns[0].equals("NAME") && columns[1].equals("VALUE")) {
            if (results == null) {
                this.row_count = 0;
                return;
            }
            int rows_processed = 0;
            try {
                int row = 1;
                while (results.hasMore()) {
                    this.checkTimeout();
                    SearchResult si = (SearchResult)results.next();
                    Attributes attrs = si.getAttributes();
                    if (attrs != null && row >= startrow) {
                        NamingEnumeration<String> ae = attrs.getIDs();
                        while (ae.hasMoreElements()) {
                            Object[] col_data = new Object[this.col_count];
                            this.checkTimeout();
                            String attrID = ae.next();
                            col_data[0] = attrID;
                            try {
                                Attribute attr = attrs.get(attrID);
                                if (attr.size() == 1 || attr.get() instanceof byte[]) {
                                    col_data[1] = attr.get();
                                } else {
                                    NamingEnumeration<?> values = attr.getAll();
                                    StringBuilder builder = new StringBuilder();
                                    if (values.hasMore()) {
                                        builder.append((String)values.next());
                                    }
                                    while (values.hasMore()) {
                                        builder.append(",").append((String)values.next());
                                    }
                                    col_data[1] = builder.toString();
                                }
                            }
                            catch (Exception e) {
                                col_data[1] = "";
                            }
                            this.addRow(col_data);
                            ++rows_processed;
                        }
                        if (maxrows != -1 && rows_processed == maxrows) break;
                    }
                    ++row;
                }
            }
            catch (NamingException e) {
                throw new LdapTagException("query :" + e.getMessage());
            }
        } else {
            if (results == null) {
                this.row_count = 0;
                return;
            }
            int rows_processed = 0;
            try {
                int row = 1;
                while (results.hasMoreElements()) {
                    this.checkTimeout();
                    SearchResult si = (SearchResult)results.next();
                    Attributes attrs = si.getAttributes();
                    if (attrs != null && row >= startrow) {
                        Object[] col_data = new Object[this.col_count];
                        for (int i = 0; i < this.col_count; ++i) {
                            this.checkTimeout();
                            try {
                                if (columns[i].equalsIgnoreCase("dn")) {
                                    String correctedName = si.getName();
                                    if (correctedName.length() > 0) {
                                        if (!correctedName.startsWith("ldap://")) {
                                            col_data[i] = this.correctName(correctedName) + ", " + this.correctName(start);
                                            continue;
                                        }
                                        col_data[i] = this.correctName(correctedName);
                                        continue;
                                    }
                                    col_data[i] = this.correctName(start);
                                    continue;
                                }
                                if (columns[i].equalsIgnoreCase("userPassword")) {
                                    Attribute password = attrs.get("userPassword");
                                    col_data[i] = new String((byte[])password.get());
                                    continue;
                                }
                                int cnt = 0;
                                String att = "";
                                col_data[i] = "";
                                NamingEnumeration<?> ae = attrs.get(columns[i]).getAll();
                                while (ae.hasMoreElements()) {
                                    att = ae.next();
                                    if (!att.getClass().getName().equals("java.lang.String")) {
                                        col_data[i] = att;
                                    } else {
                                        if (cnt != 0) {
                                            col_data[i] = (String)col_data[i] + separator;
                                        }
                                        col_data[i] = (String)col_data[i] + att;
                                    }
                                    ++cnt;
                                }
                                continue;
                            }
                            catch (NullPointerException e) {
                                col_data[i] = "";
                            }
                        }
                        this.addRow(col_data);
                        if (maxrows != -1 && ++rows_processed == maxrows) break;
                    }
                    ++row;
                }
            }
            catch (NamingException e) {
                throw new LdapTagException("query :" + e.getMessage());
            }
        }
    }

    public void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException("cfldap");
        }
    }
}

