/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import coldfusion.log.CFLogs;
import coldfusion.monitor.beans.TagAttribute;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.net.LdapCustomSSLFactory;
import coldfusion.tagext.net.LdapResultTable;
import coldfusion.tagext.net.LdapTagException;
import jakarta.servlet.jsp.JspException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public class LdapTag
extends GenericTag {
    private static final long serialVersionUID = 1L;
    private static final GenericTagPermission tp = new GenericTagPermission("cfldap");
    protected static final int DEF_START = 1;
    protected static final int DEF_MAXROWS = -1;
    protected static final int DEF_TIMEOUT = 60000;
    protected static final int DEF_PORT = 389;
    protected static final int DEF_REFERRAL = -1;
    protected static final String DEF_SEPARATOR = ", ";
    protected static final String DEF_DELIMITER = ";";
    protected static final String DEF_FILTER = "objectclass=*";
    protected boolean sortOrder = true;
    protected boolean clientauth = false;
    protected String sortCase = null;
    private long startTime = 0L;
    public static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    public static String ATTRIBUTE_ASSIGNMENT_OPERATOR = "=";
    private String action;
    private String query_name;
    private String attributes;
    private String dn;
    private String start;
    private String scope;
    private int startrow = 1;
    private int maxrows = -1;
    private String filter = "objectclass=*";
    private String sort;
    private String separator = ", ";
    private String delimiter = ";";
    private String sortcontrol;
    private String modifytype;
    private int referral = -1;
    private String secure;
    private String server;
    private int port = 389;
    private int timeout = 60000;
    private String username;
    private String password;
    private String rebind;
    private String binaryList;
    private String keystore = null;
    private String keystorePassword = null;
    private boolean useTLS = false;
    private int searchscope;

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private boolean isValidName(String s) {
        boolean retValue = true;
        if (!Character.isLetter(s.charAt(0))) {
            retValue = false;
        } else {
            char[] charArray = s.toCharArray();
            for (int i = 0; i < s.length(); ++i) {
                retValue &= Character.isLetterOrDigit(charArray[i]) || charArray[i] == '_';
            }
        }
        return retValue;
    }

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public String getClientCert() {
        return this.keystore;
    }

    public void setClientCert(String keystore) {
        if (!new File(keystore).exists()) {
            throw new KeyStoreNotFoundException(keystore);
        }
        this.keystore = keystore;
    }

    public String getClientCertPassword() {
        return this.keystorePassword;
    }

    public void setClientCertPassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public boolean getUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public void setAction(String s) {
        this.action = s;
    }

    public String getAction() {
        return this.action;
    }

    public void setName(String s) {
        this.query_name = s;
    }

    public String getName() {
        return this.query_name;
    }

    public void setReturnAsBinary(String s) {
        this.binaryList = s;
    }

    public String getReturnAsBinary() {
        return this.binaryList;
    }

    public void setAttributes(String s) {
        this.attributes = s;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setDn(String s) {
        this.dn = s;
    }

    public String getDn() {
        return this.dn;
    }

    public void setStart(String s) {
        this.start = s;
    }

    public String getStart() {
        return this.start;
    }

    public void setScope(String s) {
        this.scope = s;
    }

    public String getScope() {
        return this.scope;
    }

    public void setStartrow(int s) {
        this.startrow = s;
    }

    public int getStartrow() {
        return this.startrow;
    }

    public void setMaxrows(int s) {
        this.maxrows = s;
    }

    public int getMaxrows() {
        return this.maxrows;
    }

    public void setFilter(String s) {
        this.filter = s;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setSort(String s) {
        this.sort = s;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSeparator(String s) {
        this.separator = s;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSortControl(String s) {
        this.sortcontrol = s;
    }

    public String getSortControl() {
        return this.sortcontrol;
    }

    public void setModifytype(String s) {
        this.modifytype = s;
    }

    public String getModifytype() {
        return this.modifytype;
    }

    public void setReferral(int s) {
        this.referral = s;
    }

    public int getReferral() {
        return this.referral;
    }

    public void setSecure(String s) {
        this.secure = s;
    }

    public String setSecure() {
        return this.secure;
    }

    public void setServer(String s) {
        this.server = s;
    }

    public String getServer() {
        return this.server;
    }

    public void setPort(int s) {
        this.port = s;
    }

    public int getPort() {
        return this.port;
    }

    public void setTimeout(int s) {
        this.timeout = s;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setUserName(String s) {
        this.username = s;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setRebind(String s) {
        this.rebind = s;
    }

    public String getRebind() {
        return this.rebind;
    }

    public void setDelimiter(String s) {
        this.delimiter = s;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.startTime = System.currentTimeMillis();
        if (this.port != 0) {
            this.server = this.server + ":" + this.port;
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>(11);
        env.put("java.naming.factory.initial", INITCTX);
        env.put("java.naming.provider.url", "ldap://" + this.server);
        env.put("com.sun.jndi.ldap.read.timeout", Integer.toString(this.timeout));
        env.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(this.timeout));
        String binStr = this.getReturnAsBinary();
        if (binStr != null) {
            String tempBinStr = binStr.replaceAll(",", " ");
            if ("".equals(tempBinStr.trim())) {
                throw new InvalidTagAttributeException("CFLDAP", "returnAsBinary", binStr);
            }
            env.put("java.naming.ldap.attributes.binary", tempBinStr);
        }
        if (this.referral <= 0) {
            env.put("java.naming.referral", "ignore");
        } else {
            env.put("java.naming.referral", "follow");
            env.put("java.naming.ldap.referral.limit", Integer.toString(this.referral));
        }
        boolean isBasic = false;
        if (!this.isEmpty(this.secure)) {
            if (this.secure.toUpperCase().startsWith("CFSSL_BASIC".toUpperCase())) {
                isBasic = true;
            } else if (this.secure.toUpperCase().startsWith("CFSSL_CLIENT_AUTH")) {
                this.clientauth = true;
            }
        }
        try {
            LdapContext ctx = null;
            StartTlsResponse tls = null;
            if (this.keystore != null) {
                LdapThreadLocal certs = new LdapThreadLocal();
                certs.setKeystorePath(this.keystore);
                certs.setKeystorePassword(this.keystorePassword);
                LdapThreadLocal.set(certs);
            }
            if (this.useTLS) {
                ctx = this._getContextObj(env);
                tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
                SSLSocketFactory factory = null;
                if (this.keystore != null) {
                    factory = LdapCustomSSLFactory.getDefault();
                }
                tls.negotiate(factory);
                if (this.clientauth) {
                    this.initializeSSL(ctx, true, null);
                } else if (isBasic) {
                    this.initializeSSL(ctx, false, "javax.net.ssl.SSLSocketFactory");
                }
                if (!this.clientauth) {
                    ctx.addToEnvironment("java.naming.security.authentication", "simple");
                    if (this.username != null) {
                        ctx.addToEnvironment("java.naming.security.principal", this.username);
                        ctx.addToEnvironment("java.naming.security.credentials", this.password);
                    }
                }
            } else {
                if (this.clientauth) {
                    this.initializeSSL(env, true, "coldfusion.tagext.net.LdapCustomSSLFactory");
                } else if (isBasic) {
                    this.initializeSSL(env, false, "javax.net.ssl.SSLSocketFactory");
                }
                if (!this.clientauth) {
                    env.put("java.naming.security.authentication", "simple");
                    if (this.username != null) {
                        env.put("java.naming.security.principal", this.username);
                        env.put("java.naming.security.credentials", this.password);
                    }
                }
                ctx = this._getContextObj(env);
            }
            this.checkTimeout();
            if (this.action.equalsIgnoreCase("Query")) {
                this.do_ActionQuery(ctx);
            } else if (this.action.equalsIgnoreCase("add")) {
                this.do_ActionAdd(ctx);
            } else if (this.action.equalsIgnoreCase("modify")) {
                this.do_ActionModify(ctx);
            } else if (this.action.equalsIgnoreCase("modifyDN")) {
                this.do_ActionModifyDN(ctx);
            } else if (this.action.equalsIgnoreCase("delete")) {
                this.do_ActionDelete(ctx);
            }
            this.closeConnections(ctx, tls);
        }
        catch (NamingException e) {
            LdapTagException e1 = new LdapTagException("query :" + e.getMessage());
            LdapTag.logException(e1);
            throw e1;
        }
        catch (IOException e) {
            LdapTagException e1 = new LdapTagException("query :" + e.getMessage());
            LdapTag.logException(e1);
            throw e1;
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException() != null ? e.getException() : e;
            LdapTagException e1 = new LdapTagException("query :" + ex.getMessage());
            LdapTag.logException(e1);
            throw e1;
        }
        List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("action", "server"), Arrays.asList(this.convertUpperCase(this.action), this.convertUpperCase(this.server)));
        this.onTagEnd(tagAttributes);
        return 0;
    }

    private void initializeSSL(Hashtable env, boolean isExternal, String factoryName) {
        env.put("java.naming.security.protocol", "ssl");
        if (isExternal) {
            env.put("java.naming.security.authentication", "EXTERNAL");
        }
        env.put("java.naming.ldap.factory.socket", factoryName);
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
            Security.addProvider(sslContext.getProvider());
        }
        catch (Exception e) {
            SSLProviderNotFoundException e1 = new SSLProviderNotFoundException();
            LdapTag.logException(e1);
            throw e1;
        }
    }

    private void initializeSSL(LdapContext ctx, boolean isExternal, String factoryName) throws NamingException {
        ctx.addToEnvironment("java.naming.security.protocol", "ssl");
        if (isExternal) {
            ctx.addToEnvironment("java.naming.security.authentication", "EXTERNAL");
        }
        if (factoryName != null) {
            ctx.addToEnvironment("java.naming.ldap.factory.socket", factoryName);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
            Security.addProvider(sslContext.getProvider());
        }
        catch (Exception e) {
            SSLProviderNotFoundException e1 = new SSLProviderNotFoundException();
            LdapTag.logException(e1);
            throw e1;
        }
    }

    private void closeConnections(LdapContext ctx, StartTlsResponse tls) throws IOException, NamingException {
        if (this.useTLS && tls != null) {
            tls.close();
        }
        ctx.close();
        LdapThreadLocal.clear();
    }

    private LdapContext _getContextObj(final Hashtable env) throws NamingException, PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<LdapContext>(){

                @Override
                public LdapContext run() throws NamingException {
                    return LdapTag.this.getContextObj(env);
                }
            }, null, new FilePermission("<<ALL FILES>>", "read"));
        }
        return this.getContextObj(env);
    }

    private LdapContext getContextObj(Hashtable env) throws NamingException {
        InitialLdapContext ctx;
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (UnknownHostException e) {
            ctx = new InitialLdapContext(env, null);
        }
        return ctx;
    }

    public void do_ActionQuery(LdapContext ctx) throws JspException, NamingException {
        block47: {
            if (!this.isEmpty(this.scope)) {
                if (this.scope.equalsIgnoreCase("SUBTREE")) {
                    this.searchscope = 2;
                } else if (this.scope.equalsIgnoreCase("BASE")) {
                    this.searchscope = 0;
                } else if (this.scope.equalsIgnoreCase("ONELEVEL")) {
                    this.searchscope = 1;
                }
            } else {
                this.searchscope = 2;
            }
            if (!this.isValidName(this.query_name)) {
                throw new InvalidTagAttributeException("CFLDAP", "name", this.query_name);
            }
            try {
                SearchControls ctls = new SearchControls();
                ctls.setReturningObjFlag(true);
                ctls.setSearchScope(this.searchscope);
                if (!this.attributes.equals("*")) {
                    ctls.setReturningAttributes(this.split(this.attributes, ","));
                }
                if (this.maxrows != -1) {
                    ctls.setCountLimit(this.startrow + this.maxrows + 1);
                }
                if (this.timeout != 0) {
                    ctls.setTimeLimit(this.timeout);
                }
                if (!this.isEmpty(this.sort)) {
                    String[] sortattribs = this.split(this.sort, ",");
                    SortKey[] sk = new SortKey[sortattribs.length];
                    if (!this.isEmpty(this.sortcontrol)) {
                        String[] sortcontrols = this.split(this.sortcontrol, ",");
                        this.checkTimeout();
                        int length = sortcontrols.length;
                        if (length > 2) {
                            throw new InvalidTagAttributeException("CFLDAP", "sortcontrol", this.sortcontrol);
                        }
                        for (int j = 0; j < length; ++j) {
                            if (sortcontrols[j].equalsIgnoreCase("ASC")) {
                                this.sortOrder = true;
                                continue;
                            }
                            if (sortcontrols[j].equalsIgnoreCase("DESC")) {
                                this.sortOrder = false;
                                continue;
                            }
                            if (sortcontrols[j].equalsIgnoreCase("NOCASE")) {
                                this.sortCase = null;
                                continue;
                            }
                            throw new LdapSortException(this.sort);
                        }
                        for (int m = 0; m < sortattribs.length; ++m) {
                            int sp;
                            String sa = sortattribs[m];
                            if (sa.equalsIgnoreCase("dn")) {
                                sa = "NAME";
                            }
                            if ((sp = sa.indexOf(" ")) > 0) {
                                sa = sa.substring(0, sp);
                            }
                            sk[m] = new SortKey(sa, this.sortOrder, this.sortCase);
                        }
                    } else {
                        this.checkTimeout();
                        for (int i = 0; i < sortattribs.length; ++i) {
                            String sortattr = sortattribs[i];
                            int slen = sortattr.length();
                            if (slen > 4 && sortattr.substring(sortattr.length() - 4, sortattr.length()).equalsIgnoreCase("DESC")) {
                                this.sortOrder = false;
                                sortattr = sortattr.substring(0, sortattr.length() - 4).trim();
                            } else if (slen > 3 && sortattr.substring(sortattr.length() - 3, sortattr.length()).equalsIgnoreCase("ASC")) {
                                this.sortOrder = true;
                                sortattr = sortattr.substring(0, sortattr.length() - 3).trim();
                            } else {
                                this.sortOrder = true;
                                sortattr = sortattr.trim();
                            }
                            if (sortattr.trim().equalsIgnoreCase("dn")) {
                                sortattr = "NAME";
                            }
                            sortattribs[i] = sortattr;
                        }
                        for (int j = 0; j < sortattribs.length; ++j) {
                            sk[j] = new SortKey(sortattribs[j], this.sortOrder, this.sortCase);
                        }
                    }
                    try {
                        Control[] ctxCtls = new Control[]{new SortControl(sk, true)};
                        ctx.setRequestControls(ctxCtls);
                    }
                    catch (IOException e) {
                        LdapSortException e1 = new LdapSortException(this.sort);
                        LdapTag.logException(e1);
                        throw e1;
                    }
                    boolean moreReferrals = true;
                    while (moreReferrals) {
                        try {
                            NamingEnumeration<SearchResult> results = ctx.search(this.start, this.filter, ctls);
                            ctls = null;
                            String[] columns = new String[]{"NAME", "VALUE"};
                            if (!this.attributes.equals("*")) {
                                columns = this.split(this.attributes, ",");
                            }
                            this.checkTimeout();
                            LdapResultTable table = new LdapResultTable();
                            table.populate(results, columns, this.maxrows, this.startrow, this.start, this.separator);
                            this.pageContext.setAttribute(this.query_name, (Object)table);
                            moreReferrals = false;
                        }
                        catch (ReferralException e) {
                            LdapTag.logException(e);
                            if (!moreReferrals) continue;
                            ctx.addToEnvironment("java.naming.security.principal", "anonymous");
                            ctx.addToEnvironment("java.naming.security.credentials", "");
                            ctx = (LdapContext)e.getReferralContext();
                        }
                    }
                    break block47;
                }
                this.checkTimeout();
                boolean moreReferrals = true;
                while (moreReferrals) {
                    try {
                        NamingEnumeration<SearchResult> results = ctx.search(this.start, this.filter, ctls);
                        String[] columns = new String[]{"NAME", "VALUE"};
                        if (!this.attributes.equals("*")) {
                            columns = this.split(this.attributes, ",");
                        }
                        this.checkTimeout();
                        LdapResultTable table = new LdapResultTable();
                        table.populate(results, columns, this.maxrows, this.startrow, this.start, this.separator);
                        this.pageContext.setAttribute(this.query_name, (Object)table);
                        moreReferrals = false;
                    }
                    catch (ReferralException e) {
                        LdapTag.logException(e);
                        if (!moreReferrals) continue;
                        ctx.addToEnvironment("java.naming.security.principal", "anonymous");
                        ctx.addToEnvironment("java.naming.security.credentials", "");
                        ctx = (LdapContext)e.getReferralContext();
                    }
                }
            }
            catch (InvalidSearchControlsException e) {
                InvalidTagAttributeException e1 = new InvalidTagAttributeException("CFLDAP", "filter", this.filter);
                LdapTag.logException(e1);
                throw e1;
            }
            catch (InvalidSearchFilterException e) {
                InvalidTagAttributeException e1 = new InvalidTagAttributeException("CFLDAP", "filter", this.filter);
                LdapTag.logException(e1);
                throw e1;
            }
            catch (OperationNotSupportedException e) {
                LdapTagException e1 = new LdapTagException("sort :" + e.getMessage());
                LdapTag.logException(e1);
                throw e1;
            }
            catch (CommunicationException e) {
                if (this.clientauth) {
                    InvalidClntCertException e1 = new InvalidClntCertException();
                    LdapTag.logException(e1);
                    throw e1;
                }
                UnknownHostException e1 = new UnknownHostException(e.getMessage());
                LdapTag.logException(e1);
                throw e1;
            }
            catch (PartialResultException e) {
                LdapTag.logException(e);
                throw new InvalidCredentialsException(e.getMessage());
            }
            catch (AuthenticationException e) {
                InvalidCredentialsException e1 = new InvalidCredentialsException(e.getMessage());
                LdapTag.logException(e1);
                throw e1;
            }
        }
    }

    private static void logException(Exception e) {
        CFLogs.LDAP_LOG.error(e.getMessage(), e);
    }

    public void do_ActionAdd(LdapContext ctx) throws JspException, NamingException {
        try {
            String[] attrs = this.split(this.attributes, this.delimiter);
            int attrs_len = attrs.length;
            BasicAttributes attrib = new BasicAttributes();
            for (int i = 0; i < attrs_len; ++i) {
                String attr = attrs[i];
                String attrtype = this.getAttrValueType(attr);
                String[] attrvals = this.getAttrValues(attr);
                BasicAttribute ba = new BasicAttribute(attrtype);
                for (int j = 0; j < attrvals.length; ++j) {
                    this.checkTimeout();
                    ba.add(attrvals[j]);
                }
                attrib.put(ba);
            }
            ctx.createSubcontext(this.dn, (Attributes)attrib);
        }
        catch (NameAlreadyBoundException e) {
            LdapDuplicateDNException e1 = new LdapDuplicateDNException(this.dn);
            LdapTag.logException(e);
            throw e1;
        }
        catch (InvalidAttributesException e) {
            InvalidTagAttributeException e1 = new InvalidTagAttributeException("CFLDAP", "attributes", this.attributes);
            LdapTag.logException(e1);
            throw e1;
        }
    }

    public void do_ActionModify(LdapContext ctx) throws JspException, NamingException {
        try {
            String[] attrs = this.split(this.attributes, this.delimiter);
            int attrs_len = attrs.length;
            int count = 0;
            for (int i = 0; i < attrs_len; ++i) {
                if (this.getAttrValues(attrs[i]) == null) {
                    ++count;
                    continue;
                }
                for (int j = 0; j < this.getAttrValues(attrs[i]).length; ++j) {
                    ++count;
                }
            }
            ModificationItem[] mods = new ModificationItem[count];
            int k = 0;
            for (int i = 0; i < attrs_len; ++i) {
                int j;
                BasicAttribute mod0;
                String[] attrvals;
                String attrtype;
                String attr = attrs[i];
                if (this.isEmpty(this.modifytype) || this.modifytype.equalsIgnoreCase("REPLACE")) {
                    attrtype = this.getAttrValueType(attr);
                    attrvals = this.getAttrValues(attr);
                    this.checkTimeout();
                    mod0 = attrvals == null ? new BasicAttribute(attrtype) : new BasicAttribute(attrtype, attrvals[0]);
                    mods[k] = new ModificationItem(2, mod0);
                    ++k;
                    if (attrvals == null || attrvals.length <= 1) continue;
                    for (j = 1; j < attrvals.length; ++j) {
                        this.checkTimeout();
                        mod0 = new BasicAttribute(attrtype, attrvals[j]);
                        mods[k] = new ModificationItem(1, mod0);
                        ++k;
                    }
                    continue;
                }
                if (this.modifytype.equalsIgnoreCase("ADD")) {
                    attrtype = this.getAttrValueType(attr);
                    attrvals = this.getAttrValues(attr);
                    for (j = 0; j < attrvals.length; ++j) {
                        this.checkTimeout();
                        mod0 = new BasicAttribute(attrtype, attrvals[j]);
                        mods[k] = new ModificationItem(1, mod0);
                        ++k;
                    }
                    continue;
                }
                if (this.modifytype.equalsIgnoreCase("DELETE")) {
                    attrtype = this.getAttrValueType(attr);
                    attrvals = this.getAttrValues(attr);
                    for (j = 0; j < attrvals.length; ++j) {
                        this.checkTimeout();
                        mod0 = attrtype != null ? new BasicAttribute(attrtype, attrvals[j]) : new BasicAttribute(attrvals[j]);
                        mods[k] = new ModificationItem(3, mod0);
                        ++k;
                    }
                    continue;
                }
                throw new InvalidTagAttributeException("CFLDAP", "modifytype", this.modifytype);
            }
            ctx.modifyAttributes(this.dn, mods);
        }
        catch (AttributeModificationException e) {
            LdapTagException e1 = new LdapTagException("modify :" + e.getMessage());
            LdapTag.logException(e1);
            throw e1;
        }
    }

    public void do_ActionModifyDN(LdapContext ctx) throws JspException, NamingException {
        try {
            this.checkTimeout();
            ctx.rename(this.dn, this.attributes);
        }
        catch (NameAlreadyBoundException e) {
            LdapDuplicateDNException e1 = new LdapDuplicateDNException(this.dn);
            LdapTag.logException(e1);
            throw e1;
        }
    }

    public void do_ActionDelete(LdapContext ctx) throws JspException, NamingException {
        try {
            this.checkTimeout();
            ctx.destroySubcontext(this.dn);
        }
        catch (NameNotFoundException e) {
            LdapInvalidDNException e1 = new LdapInvalidDNException(this.dn);
            LdapTag.logException(e1);
            throw e1;
        }
    }

    public String getAttrValueType(String attribute) {
        if (attribute.indexOf(ATTRIBUTE_ASSIGNMENT_OPERATOR) != -1) {
            String type = attribute.substring(0, attribute.indexOf(ATTRIBUTE_ASSIGNMENT_OPERATOR));
            return type.trim();
        }
        return null;
    }

    public String[] getAttrValues(String attribute) {
        String value = attribute.substring(attribute.indexOf(ATTRIBUTE_ASSIGNMENT_OPERATOR) + 1, attribute.length());
        if (value.length() <= 0) {
            return null;
        }
        String[] svals = this.split(value, this.separator.equals(DEF_SEPARATOR) ? "," : this.separator);
        return svals;
    }

    protected String[] split(String line, String sep) {
        if (sep == null) {
            sep = ",";
        }
        StringTokenizer st = new StringTokenizer(line, sep, false);
        int number = st.countTokens();
        ArrayList<String> L = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            L.add(i, st.nextToken().trim());
        }
        return L.toArray(new String[0]);
    }

    public void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException(this.tagNameFromClass());
        }
    }

    public static class KeyStoreNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String filename;

        public KeyStoreNotFoundException(String filename) {
            this.filename = filename;
        }
    }

    public static class LdapThreadLocal {
        private static final ThreadLocal<LdapThreadLocal> certThreadLocal = new ThreadLocal();
        private String keystorePath;
        private String keystorePassword;

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public void setKeystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
        }

        public static void set(LdapThreadLocal certs) {
            certThreadLocal.set(certs);
        }

        public static void clear() {
            certThreadLocal.remove();
        }

        public static LdapThreadLocal get() {
            return certThreadLocal.get();
        }
    }

    public class SSLProviderNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class UnknownHostException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg;

        public UnknownHostException() {
        }

        public UnknownHostException(String m) {
            this.msg = m;
        }
    }

    public class LdapSortException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String sort;

        public LdapSortException(String s) {
            this.sort = s;
        }

        public String getSort() {
            return this.sort;
        }
    }

    public class InvalidClntCertException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class InvalidCredentialsException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg;

        public InvalidCredentialsException() {
        }

        public InvalidCredentialsException(String m) {
            this.msg = m;
        }
    }

    public class LdapDuplicateDNException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String dn;

        public LdapDuplicateDNException(String s) {
            this.dn = s;
        }

        public String getDn() {
            return this.dn;
        }
    }

    public class LdapInvalidDNException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String dn;

        public LdapInvalidDNException(String s) {
            this.dn = s;
        }

        public String getDn() {
            return this.dn;
        }
    }

    static final class SampleVerifier
    implements HostnameVerifier {
        SampleVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            boolean matches = false;
            try {
                Certificate[] cert = session.getPeerCertificates();
                for (int i = 0; i < cert.length; ++i) {
                    matches = true;
                }
            }
            catch (SSLPeerUnverifiedException e) {
                LdapTag.logException(e);
                matches = false;
            }
            return matches;
        }
    }

    public static class LdapBadCertificateException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String err = "";

        public LdapBadCertificateException() {
        }

        public LdapBadCertificateException(Exception e) {
            this.err = e.toString();
        }
    }

    public class LdapTagAttributeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String attr;

        public LdapTagAttributeException(String a) {
            this.attr = a;
        }

        public String getAttr() {
            return this.attr;
        }
    }
}

