/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ResolvePage {
    private static final String paramValue = "\\s*=\\s*[\"']([^\"']*)[\"']";
    private static final String match = "<(?!\\/)\\s*(?:(?:IMG\\s[^>]*SRC|A\\s[^>]*HREF|FRAME\\s[^>]*SRC|FORM\\s[^>]*ACTION|LINK\\s[^>]*HREF|APPLET\\s[^>]*CODE|SCRIPT\\s[^>]*SRC|AREA\\s[^>]*HREF|BODY\\s[^>]*BACKGROUND|TABLE\\s[^>]*BACKGROUND|TD\\s[^>]*BACKGROUND|TH\\s[^>]*BACKGROUND|BGSOUND\\s[^>]*SRC|INPUT\\s[^>]*SRC|IFRAME\\s[^>]*SRC)\\s*=\\s*[\"']([^\"']*)[\"'])|(?:EMBED(?:[^SP>]*(?:SRC\\s*=\\s*[\"']([^\"']*)[\"']|PLUGINSPACE\\s*=\\s*[\"']([^\"']*)[\"']).?)+)|(?:OBJECT(?:[^DCU>]*(?:DATA\\s*=\\s*[\"']([^\"']*)[\"']|CLASSID\\s*=\\s*[\"']([^\"']*)[\"']|CODEBASE\\s*=\\s*[\"']([^\"']*)[\"']|USEMAP\\s*=\\s*[\"']([^\"']*)[\"']).?)+)|(?:LAYER(?:[^SB>]*(?:SRC\\s*=\\s*[\"']([^\"']*)[\"']|BACKGROUND\\s*=\\s*[\"']([^\"']*)[\"']).?)+)|(?:ILAYER(?:[^SB>]*(?:SRC\\s*=\\s*[\"']([^\"']*)[\"']|BACKGROUND\\s*=\\s*[\"']([^\"']*)[\"']).?)+)";
    private static final String beginUrl = "^(?:\\w+:\\/\\/|mailto:|news:|newsrc:|nethelp:)";
    private static Pattern pattern;
    private static Pattern patternUrl;
    private static MalformedPatternException patternExc;

    public String resolve(String page, String newUrl) throws MalformedPatternException {
        if (patternExc != null) {
            throw patternExc;
        }
        newUrl = this.prepareUrl(newUrl);
        String baseUrl = this.baseUrl(newUrl);
        Perl5Matcher matcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(page);
        MatchResult result = null;
        ArrayList<SubString> addList = new ArrayList<SubString>();
        while (matcher.contains(input, pattern)) {
            result = matcher.getMatch();
            int groups = result.groups();
            for (int i = 1; i < groups + 1; ++i) {
                String toResolve;
                String url = result.group(i);
                if (url == null || (toResolve = this.resolveUrl(url, newUrl, baseUrl)) == null) continue;
                addList.add(new SubString(toResolve, result.beginOffset(i), result.endOffset(i)));
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = addList.iterator();
        int begin = 0;
        while (i.hasNext()) {
            SubString s = (SubString)i.next();
            int end = s.begin;
            sb.append(page.substring(begin, end));
            sb.append(s.string);
            begin = s.end;
        }
        sb.append(page.substring(begin, page.length()));
        return sb.toString();
    }

    public String resolveUrl(String url, String newUrl, String baseUrl) {
        String resolved = null;
        Perl5Matcher matcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(url);
        if (!matcher.contains(input, patternUrl)) {
            resolved = url.length() > 0 && url.charAt(0) == '/' ? baseUrl + url : newUrl + "/" + url;
        }
        return resolved;
    }

    public String prepareUrl(String newUrl) {
        int nuLen = newUrl.length();
        if (nuLen > 0 && newUrl.charAt(nuLen - 1) == '/') {
            newUrl = newUrl.substring(0, nuLen - 1);
        } else {
            int nuSlash = newUrl.lastIndexOf(47);
            if (nuSlash > 0 && newUrl.lastIndexOf(47, nuSlash - 1) != nuSlash - 1) {
                newUrl = newUrl.substring(0, nuSlash);
            }
        }
        return newUrl;
    }

    public String baseUrl(String newUrl) {
        String baseUrl = null;
        int nuSlash = newUrl.indexOf(47);
        baseUrl = nuSlash > 0 ? (newUrl.indexOf(47, nuSlash + 1) != nuSlash + 1 ? newUrl.substring(0, nuSlash) : ((nuSlash = newUrl.indexOf(47, nuSlash + 2)) > 0 ? newUrl.substring(0, nuSlash) : newUrl)) : newUrl;
        return baseUrl;
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Object strInput = "";
        while ((line = in.readLine()) != null) {
            strInput = (String)strInput + line + "\n";
        }
        String url = args.length != 0 ? args[0] : "http://localhost";
        ResolvePage rp = new ResolvePage();
        String page = rp.resolve((String)strInput, url);
        System.out.println("resolved: " + page);
    }

    static {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            pattern = compiler.compile(match, 1);
            patternUrl = compiler.compile(beginUrl, 1);
        }
        catch (MalformedPatternException mpe) {
            patternExc = mpe;
        }
    }

    class SubString {
        String string;
        int begin;
        int end;

        SubString(String string, int begin, int end) {
            this.string = string;
            this.begin = begin;
            this.end = end;
        }
    }
}

