/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SecurityScopeTracker;
import coldfusion.runtime.SecurityTable;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.Struct;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.wddx.Base64Encoder;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.UnsupportedEncodingException;

public class AuthenticateTag
extends GenericTag
implements TryCatchFinally {
    private static final String CFLOGIN_PASSWORD = "cflogin.password";
    private static final String CFLOGIN_NAME = "cflogin.name";
    private static final String NTLM = "NTLM";
    private static final String NEGOTIATE = "NEGOTIATE";
    private static final String BASIC = "BASIC";
    private static final long serialVersionUID = 1L;
    private Scope _sessionScope;
    private SecurityTable _secTab;
    private SecurityScopeTracker _securityScopeTracker = null;
    private String _auth;
    private String _name;
    private String _password;
    private String _domain;
    private String _appToken = null;
    private boolean credenialsUpdated = false;
    private long _maxInactiveInterval = 1800000L;
    private boolean _isNTLM = false;
    private boolean useBasicAuth = true;
    private boolean isAdminAPI = false;
    private boolean allowConcurrent = true;
    private static final String tokenSeparator = "\r";
    private static final int[] SCOPES_TO_SEARCH = new int[]{2, 3};

    @Override
    public void release() {
        super.release();
        this.cleanup();
    }

    private void cleanup() {
        this.credenialsUpdated = false;
        this._auth = null;
        this._name = null;
        this._password = null;
        this._domain = null;
        this._appToken = null;
        this._maxInactiveInterval = 1800000L;
        this._secTab = null;
        this._isNTLM = false;
        this.useBasicAuth = true;
        this.isAdminAPI = false;
        this.allowConcurrent = true;
    }

    public int doStartTag() {
        String password;
        String username;
        this.onTagStart();
        this._securityScopeTracker = SecurityScopeTracker.getInstance();
        String auth = null;
        FusionContext ctx = FusionContext.getCurrent();
        ctx.setApplicationToken(this._appToken);
        SecurityService securityService = ServiceFactory.getSecurityService();
        this.isAdminAPI = ctx.isAdminAPI();
        this._sessionScope = this.fContext.getCurrentSession();
        if (this.isAdminAPI) {
            this._secTab = securityService.getSecurityState();
            if (this._secTab != null) {
                return 0;
            }
            return 1;
        }
        if (auth == null) {
            username = null;
            try {
                username = (String)((NeoPageContext)this.pageContext).findAttribute("j_username", false, SCOPES_TO_SEARCH);
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.debug("no auth info found, executing cflogin...");
                return 1;
            }
            password = (String)((NeoPageContext)this.pageContext).findAttribute("j_password", false, SCOPES_TO_SEARCH);
            if (username != null) {
                if (password == null) {
                    password = "";
                }
                this._auth = auth = securityService.createAuthToken(username, this.getApplicationToken(), password, false, this.allowConcurrent);
                this.setName(username);
                this.setPassword(password);
            }
            username = null;
            password = null;
        }
        if (auth == null) {
            username = this.fContext.getSecureUsername();
            password = this.fContext.getSecurePassword();
            if (username != null || password != null) {
                if (username == null) {
                    username = "";
                }
                if (password == null) {
                    password = "";
                }
                auth = securityService.createAuthToken(username, this.getApplicationToken(), password, false, this.allowConcurrent);
                this.setName(username);
                this.setPassword(password);
                this._auth = auth;
                username = null;
                password = null;
            }
        }
        if (auth == null && this.storeSecurityKeyInSession() && (auth = (String)this._sessionScope.get(SecurityScopeTracker.getAppSecureCookieName())) != null) {
            this._secTab = this._securityScopeTracker.getSecurity(auth);
        }
        if (auth == null && (auth = SecurityScopeTracker.getSecurityCookie(this.pageContext)) != null) {
            this._secTab = this._securityScopeTracker.getSecurity(auth);
        }
        if ((auth == null || auth.length() == 0 && this._secTab == null) && this.useBasicAuth) {
            String prevAuth = auth;
            auth = this.request.getHeader("authorization");
            if (auth == null) {
                auth = prevAuth;
            } else {
                int index = auth.indexOf(" ");
                String aString = "";
                boolean hasspace = true;
                if (index != -1) {
                    aString = auth.substring(0, index);
                } else {
                    hasspace = false;
                    String upperAuth = auth.toUpperCase();
                    if (upperAuth.startsWith(BASIC)) {
                        index = BASIC.length();
                    } else if (upperAuth.startsWith(NEGOTIATE)) {
                        index = NEGOTIATE.length();
                    } else if (upperAuth.startsWith(NTLM)) {
                        index = NTLM.length();
                    }
                    if (index != -1) {
                        aString = auth.substring(0, index);
                    }
                }
                try {
                    String username2 = null;
                    String password2 = null;
                    if (index != -1 && aString.equalsIgnoreCase(BASIC)) {
                        this.debug("logintag: BASIC AUTH");
                        auth = hasspace ? auth.substring(index + 1) : auth.substring(index);
                        auth = this.decodeBase64(auth);
                        auth = auth.replace(":", tokenSeparator);
                        int index1 = auth.indexOf(tokenSeparator);
                        if (index1 != -1) {
                            if (!this.isDigest(auth)) {
                                username2 = auth.substring(0, index1);
                                password2 = auth.substring(index1 + 1);
                            } else {
                                username2 = this.request.getRemoteUser();
                            }
                        }
                        this._auth = auth = securityService.createAuthToken(username2, this.getApplicationToken(), password2, false, this.allowConcurrent);
                        this._secTab = this._securityScopeTracker.getSecurity(auth);
                        this.setName(username2);
                        this.setPassword(password2);
                        username2 = null;
                        password2 = null;
                    } else if (index != -1 && (aString.equalsIgnoreCase(NEGOTIATE) || aString.equalsIgnoreCase(NTLM))) {
                        this.debug("login tag: DIGEST AUTH or NTLM");
                        auth = null;
                        this._isNTLM = true;
                    } else {
                        auth = null;
                    }
                }
                catch (Exception e) {
                    auth = null;
                }
            }
        }
        if (auth == null) {
            CFLogs.SERVER_LOG.debug("no auth info found, executing cflogin...");
            return 1;
        }
        Object cflogin = null;
        if (this._secTab != null) {
            return 0;
        }
        if (auth != null) {
            if (auth.length() > 0 && this._name == null && this._password == null) {
                CFLogs.SERVER_LOG.debug("auth:[" + auth + "], apptoken:[" + this.getApplicationToken() + "]");
                this.parseAuthUpdate(auth, securityService);
            }
            if (this._name != null) {
                this.debug("logintag/username:" + this._name);
                this.debug("logintag/password:" + this._password);
                LocalScope localScope = ((NeoPageContext)this.pageContext).getActiveFunctionLocalScope();
                if (localScope != null) {
                    Struct loginStruct = new Struct();
                    loginStruct.put("name", (Object)this._name);
                    loginStruct.put("password", (Object)this._password);
                    localScope.put("cflogin", (Object)loginStruct);
                    cflogin = loginStruct;
                } else {
                    this.pageContext.setAttribute(CFLOGIN_NAME, (Object)this._name);
                    this.pageContext.setAttribute(CFLOGIN_PASSWORD, (Object)this._password);
                    cflogin = this.pageContext.getAttribute("cflogin");
                }
            }
        }
        this.debug("unknown auth info found, executing cflogin...: " + cflogin);
        return 1;
    }

    private void parseAuthUpdate(String auth, SecurityService securityService) {
        String username = null;
        String password = null;
        String[] usernamePassword = new String[]{username, password};
        if ((usernamePassword = securityService.parseAuthInfo(auth, usernamePassword)) != null && usernamePassword.length >= 2) {
            username = usernamePassword[0];
            password = usernamePassword[1];
            if (username == null || username != null && username.isEmpty()) {
                username = this.request.getRemoteUser();
            }
            this.setName(username);
            this.setPassword(password);
            this._auth = auth;
        }
    }

    protected void setRoles(SecurityTable roles) {
        this._secTab = roles;
    }

    protected void setName(String name) {
        this._name = name;
    }

    protected void setPassword(String pwd) {
        this._password = pwd;
    }

    protected String getPassword() {
        return this._password;
    }

    protected String getName() {
        return this._name;
    }

    protected void setCredentialsUpdated(boolean flag) {
        this.credenialsUpdated = true;
    }

    public void setIdleTimeOut(long idle) {
        this._maxInactiveInterval = idle;
    }

    public void setUseBasicAuth(boolean setUseBasicAuth) {
        this.useBasicAuth = setUseBasicAuth;
    }

    public void setAllowConcurrent(boolean allowConcurrent) {
        this.allowConcurrent = allowConcurrent;
    }

    public boolean isAllowConcurrent() {
        return this.allowConcurrent;
    }

    public void setApplicationToken(String token) {
        this._appToken = token;
    }

    private String getApplicationToken() {
        return this._appToken != null ? this._appToken : this.fContext.getApplicationName();
    }

    public void setCookieDomain(String domain) {
        this._domain = domain;
    }

    private String createAuthToken() {
        String appName = this.getApplicationToken();
        SecurityService securityService = ServiceFactory.getSecurityService();
        String encrypToken = !this._isNTLM ? securityService.createAuthToken(this._name, appName, this._password, false, this.allowConcurrent) : securityService.createAuthToken(this._name, appName, this._password, true, this.allowConcurrent);
        return encrypToken;
    }

    private void setCFAuthorizationCookie(String token) {
        Cookie cook = SecurityScopeTracker.createSecurityCookie(this.pageContext, token);
        if (this._domain != null) {
            cook.setDomain(this._domain);
        }
        SecurityScopeTracker.setSecurityCookie(this.pageContext, cook);
    }

    private boolean isDigest(String str) {
        return str.endsWith(":DIGEST-NTLM");
    }

    private String decodeBase64(String str) {
        String sr;
        if (this.isDigest(str)) {
            return str;
        }
        try {
            sr = new String(Base64Encoder.decode(str), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            sr = new String(Base64Encoder.decode(str));
        }
        return sr;
    }

    private boolean storeSecurityKeyInSession() {
        boolean rc = false;
        Scope _applicationScope = FusionContext.getApplicationScope();
        if (this._sessionScope instanceof SessionScope && _applicationScope instanceof ApplicationScope && ((ApplicationScope)_applicationScope).getStoreloginCredentialInSession()) {
            rc = true;
        }
        return rc;
    }

    private void setupSecurityContext(SecurityTable table) {
        String securityToken = this._auth;
        if (this.credenialsUpdated || securityToken == null || securityToken != null && securityToken.length() == 0) {
            securityToken = this.createAuthToken();
        }
        this._securityScopeTracker.setSecurity(securityToken, table);
        if (this.storeSecurityKeyInSession()) {
            this._sessionScope.put(SecurityScopeTracker.getAppSecureCookieName(), securityToken);
            table.setMaxInactiveInterval(((SessionScope)this._sessionScope).getMaxInactiveInterval() + 1L);
        } else {
            this.setCFAuthorizationCookie(securityToken);
        }
    }

    public int doEndTag() {
        try {
            if (this._secTab != null) {
                if (this.isAdminAPI) {
                    ServiceFactory.getSecurityService().setAuthenticated(true, this._secTab);
                } else {
                    this._secTab.setAppToken(this.getApplicationToken());
                    long inactiveInterval = this._maxInactiveInterval;
                    this._secTab.setMaxInactiveInterval(inactiveInterval);
                    this.fContext.setSecureTable(this._secTab);
                    if (this._name != null && this._name.length() > 0) {
                        this.setupSecurityContext(this._secTab);
                    }
                }
            } else {
                this._securityScopeTracker.logout(this.pageContext, "current");
            }
        }
        finally {
            LocalScope localScope = ((NeoPageContext)this.pageContext).getActiveFunctionLocalScope();
            if (localScope != null) {
                localScope.remove("cflogin");
            } else {
                this.pageContext.removeAttribute("cflogin");
            }
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    public void doFinally() {
        super.doFinally();
        this.cleanup();
    }

    @Override
    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }
}

