/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security;

import coldfusion.runtime.NeoException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTag;
import java.security.AccessControlException;
import java.security.Permission;

public class JavaTag
extends GenericTag
implements BodyTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfjava");
    private String content;
    private String handle;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public int doStartTag() {
        this.onTagStart();
        return 2;
    }

    public int doEndTag() throws JspException {
        this.release();
        this.onTagEnd();
        return 6;
    }

    @Override
    public int doAfterBody() throws JspException {
        String language;
        if (this.bodyContent != null) {
            String content = this.bodyContent.getString().trim();
            if (this.content != null && this.content.length() > 0 && content.length() > 0) {
                throw new FileAndBodyFoundException();
            }
            if (content.length() > 0) {
                this.content = content;
            }
            this.bodyContent.clearBody();
        }
        if ((language = "java").equals("java")) {
            try {
                this.runJava(this.content);
            }
            catch (AccessControlException ace) {
                throw ace;
            }
            catch (Exception e) {
                throw new RunException(e.getMessage());
            }
        } else {
            this.runJavaScript(this.content);
        }
        return 0;
    }

    private void runJavaScript(String content) {
        Object o = ServiceFactory.getLanguageService(true).runJavascript(content);
    }

    private void runJava(String content) throws Exception {
        Object o = ServiceFactory.getLanguageService(true).runJava(content, null);
        if (this.isStatic) {
            this.pageContext.setAttribute(this.handle, o, 101);
        } else {
            this.pageContext.setAttribute(this.handle, o);
        }
    }

    public void setHandle(String o) {
        this.handle = o;
    }

    public static class FileAndBodyFoundException
    extends NeoException {
    }

    public static class RunException
    extends NeoException {
        public String e;

        public RunException(String e) {
            this.e = e;
        }
    }

    public static class FileNotFoundException
    extends NeoException {
        public String file;

        public FileNotFoundException(String file) {
            this.file = file;
        }
    }

    public static class MethodNotFoundException
    extends NeoException {
        public String method;

        public MethodNotFoundException(String method) {
            this.method = method;
        }
    }

    public static class CompilationException
    extends NeoException {
        public String error;

        public CompilationException(String error) {
            this.error = error;
        }
    }

    public static class ClassCanNotRunException
    extends NeoException {
        public String msg;

        public ClassCanNotRunException(String msg) {
            this.msg = msg;
        }
    }

    public static class ClassNameNotExtractedException
    extends NeoException {
    }

    public static class SourceNotSavedException
    extends NeoException {
    }
}

