/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security;

import coldfusion.runtime.Struct;
import coldfusion.security.AuthenticationFailureException;
import coldfusion.security.NTAuthentication;
import coldfusion.security.UserNotInDirException;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.GenericTag;
import jakarta.servlet.jsp.JspException;
import java.util.Iterator;
import java.util.List;

public class NTAuthenticateTag
extends GenericTag {
    private String _username = null;
    private String _password = null;
    private String _domain = null;
    private String _result = "cfntauthenticate";
    private String _action = "auth";
    private boolean _bListGroups = false;
    private boolean _bThrowOnError = false;

    public void setUsername(String name) {
        this._username = name;
    }

    public String getUsername() {
        return this._username;
    }

    public void setPassword(String pwd) {
        this._password = pwd;
    }

    public String getPassword() {
        return this._password;
    }

    public void setDomain(String dom) {
        this._domain = dom;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setResult(String var) {
        this._result = var;
    }

    public String getResult() {
        return this._result;
    }

    public void setListGroups(boolean b) {
        if (b) {
            this._bListGroups = true;
            this._action = "authAndGroups";
        } else {
            this._bListGroups = false;
            this._action = "auth";
        }
    }

    public boolean getListGroups() {
        return this._bListGroups;
    }

    public void setThrowOnError(boolean b) {
        this._bThrowOnError = b;
    }

    public boolean getThrowOnError() {
        return this._bThrowOnError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        this.onTagStart();
        Struct resultSt = new Struct();
        if (!SystemInfo.isWindows()) return 0;
        NTAuthentication ntauth = new NTAuthentication(this._domain);
        if (this._username != null) {
            resultSt.put("username", (Object)this._username);
        }
        if (this._action.equals("auth")) {
            try {
                boolean bAuth = false;
                if (ntauth.IsUserInDirectory(this._username) && this._password != null && this._domain.length() != 0) {
                    bAuth = ntauth.AuthenticateUser(this._username, this._password);
                }
                resultSt.put("auth", (Object)new Boolean(bAuth));
                if (bAuth) {
                    resultSt.put("status", (Object)"success");
                } else {
                    resultSt.put("status", (Object)"AuthenticationFailure");
                }
                this.pageContext.setAttribute(this._result, (Object)resultSt);
                return 0;
            }
            catch (Exception e) {
                resultSt.put("auth", (Object)Boolean.FALSE);
                if (e instanceof UserNotInDirException) {
                    resultSt.put("status", (Object)"UserNotInDirFailure");
                } else if (e instanceof AuthenticationFailureException) {
                    resultSt.put("status", (Object)"AuthenticationFailure");
                }
                this.pageContext.setAttribute(this._result, (Object)resultSt);
                if (!this._bThrowOnError) return 0;
                throw new JspException((Throwable)e);
            }
        }
        if (!this._action.equals("authAndGroups")) return 0;
        try {
            boolean bAuth = false;
            if (ntauth.IsUserInDirectory(this._username) && this._password != null && this._domain.length() != 0) {
                bAuth = ntauth.AuthenticateUser(this._username, this._password);
            }
            if (bAuth) {
                List groups = ntauth.GetUserGroups(this._username);
                resultSt.put("auth", (Object)new Boolean(bAuth));
                resultSt.put("status", (Object)"success");
                Iterator i = groups.iterator();
                int j = 0;
                StringBuffer sList = new StringBuffer();
                while (i.hasNext()) {
                    if (j > 0) {
                        sList.append(",");
                    }
                    sList.append(i.next());
                    ++j;
                }
                resultSt.put("groups", (Object)sList.toString());
                this.pageContext.setAttribute(this._result, (Object)resultSt);
                return 0;
            } else {
                resultSt.put("auth", (Object)Boolean.FALSE);
                resultSt.put("status", (Object)"AuthenticationFailure");
                this.pageContext.setAttribute(this._result, (Object)resultSt);
            }
            return 0;
        }
        catch (Exception e) {
            resultSt.put("auth", (Object)Boolean.FALSE);
            if (e instanceof UserNotInDirException) {
                resultSt.put("status", (Object)"UserNotInDirFailure");
            } else if (e instanceof AuthenticationFailureException) {
                resultSt.put("status", (Object)"AuthenticationFailure");
            }
            this.pageContext.setAttribute(this._result, (Object)resultSt);
            if (!this._bThrowOnError) return 0;
            throw new JspException((Throwable)e);
        }
    }

    @Override
    public void release() {
        this._username = null;
        this._password = null;
        this._domain = null;
        this._result = null;
        this._action = null;
        super.release();
        this.onTagEnd();
    }
}

