/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.security.oauth.AuthorizationGrant;
import coldfusion.tagext.security.oauth.AuthorizationGrantFactory;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.HttpHelper;
import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.jsp.JspException;
import java.util.Collections;
import java.util.Optional;

public class OauthTag
extends GenericTag {
    private String result;
    private final OauthCredentials credentials = new OauthCredentials();

    public int doStartTag() {
        this.onTagStart();
        AuthorizationGrant grant = AuthorizationGrantFactory.INSTANCE.getAuthorizationGrant(this.request, this.response, this.credentials);
        try {
            Struct tokenResponse = grant.getToken();
            Optional.ofNullable(this.result).ifPresent(result -> this.pageContext.setAttribute(result, (Object)tokenResponse));
        }
        catch (AuthorizationException ex) {
            Optional.ofNullable(this.result).ifPresent(result -> this.pageContext.setAttribute(result, (Object)HttpHelper.handleError(this.request)));
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.credentials.release();
        this.onTagEnd();
        return 6;
    }

    public static boolean invalidateOauthAccesstoken(String token, String type) {
        try {
            VendorType vendorType = VendorType.valueOfIgnoreCase(type);
            String url = OauthConstants.getEndpoint(vendorType, OauthConstants.EndpointType.REVOKE);
            String params = OauthConstants.getEndpoint(vendorType, OauthConstants.EndpointType.REVOKE_KEY) + token;
            return OauthTag.validateResponse(HttpHelper.doGet(url + params, Collections.emptyMap()));
        }
        catch (IllegalArgumentException e) {
            throw new OauthInvalidTypeException();
        }
    }

    public static boolean isValidOauthAccesstoken(String token, String type) {
        try {
            VendorType vendorType = VendorType.valueOfIgnoreCase(type);
            String url = OauthConstants.getEndpoint(vendorType, OauthConstants.EndpointType.ID);
            String authorizationHeader = "Bearer " + token;
            return OauthTag.validateResponse(HttpHelper.doGet(url, Collections.singletonMap("Authorization", authorizationHeader)));
        }
        catch (IllegalArgumentException e) {
            throw new OauthInvalidTypeException();
        }
    }

    private static boolean validateResponse(String response) {
        if (response == null) {
            return false;
        }
        if (response.length() == 0 || "true".equalsIgnoreCase(response)) {
            return true;
        }
        Struct struct = (Struct)JSONUtils.deserializeJSON(response);
        if (struct.get("error") != null) {
            CFLogs.APPLICATION_LOG.error("Invalid accesstoken : " + response);
            return false;
        }
        return true;
    }

    public void setClientid(String socialclientid) {
        this.credentials.setClientId(socialclientid);
    }

    @Deprecated(since="16.0", forRemoval=true)
    public void setApiversion(String apiversion) {
        this.credentials.setApiVersion(apiversion);
    }

    public void setScope(String scope) {
        this.credentials.setScope(scope.toLowerCase());
    }

    public void setState(String state) {
        this.credentials.setState(state);
    }

    public void setType(String type) {
        try {
            this.credentials.setType(VendorType.valueOfIgnoreCase(type));
        }
        catch (IllegalArgumentException e) {
            throw new OauthInvalidTypeException();
        }
    }

    public void setAuthendpoint(String authendpoint) {
        this.credentials.setAuthorizationEndpoint(authendpoint);
    }

    public void setAccesstokenendpoint(String accesstokenendpoint) {
        this.credentials.setTokenEndpoint(accesstokenendpoint);
    }

    public void setSecretkey(String secretkey) {
        this.credentials.setClientSecret(secretkey);
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    public void setRedirecturi(String redirecturi) {
        this.credentials.setRedirectUri(redirecturi);
    }

    public void setUrlparams(String extraoptions) {
        this.credentials.setUrlParams(extraoptions);
    }

    public void setGranttype(String grant) {
        this.credentials.setGranttype(GrantType.valueOfIgnoreCase(grant));
    }

    public void setRefreshToken(String refreshToken) {
        this.credentials.setRefreshToken(refreshToken);
    }

    public void setProviderConfig(Struct providerConfig) {
        this.credentials.setProviderConfig(providerConfig);
    }

    public void setClient_assertion_type(String client_assertion_type) {
        this.credentials.setClientAssertionType(client_assertion_type);
    }

    public void setClient_assertion(String client_assertion) {
        this.credentials.setClientAssertion(client_assertion);
    }

    public static class AuthorizationException
    extends RuntimeException {
    }

    public static class OauthInvalidTypeException
    extends ExpressionException {
    }

    public static class StateMismatchException
    extends ExpressionException {
    }

    public static class NotSupportedAttributeException
    extends ExpressionException {
        public String attribute;

        public NotSupportedAttributeException(String attribute) {
            this.attribute = attribute;
        }
    }

    public static class RequiredAttributeException
    extends ExpressionException {
        public String attribute;

        public RequiredAttributeException(String attribute) {
            this.attribute = attribute;
        }
    }

    public static class ApiversionException
    extends ExpressionException {
    }

    public static class OauthAppAuthenticationException
    extends ExpressionException {
        public OauthAppAuthenticationException(Throwable e) {
            super(e);
        }
    }

    public static class OauthCannotInvalidateTokenException
    extends ExpressionException {
    }

    public static class OauthServiceException
    extends ExpressionException {
    }

    public static class OauthNoSecretkeyException
    extends ExpressionException {
    }

    public static class OauthNoTypeAndEndpointsException
    extends ExpressionException {
    }

    public static class OauthNoEndpointsException
    extends ExpressionException {
    }

    public static class OauthNoTypeException
    extends ExpressionException {
    }
}

