/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant;

import coldfusion.log.CFLogs;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.tagext.net.LocationTag;
import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.AuthorizationGrant;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.HttpHelper;
import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import coldfusion.tagext.security.oauth.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class AuthorizationCodeGrant
extends AuthorizationGrant {
    protected final OauthCredentials credentials;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    protected Set<String> required = Stream.of("client_id", "client_secret", "authorization_endpoint", "token_endpoint", "scope", "redirect_uri").collect(Collectors.toSet());
    protected Set<String> rejected = Stream.of("apiversion", "refresh_token", "tenant", "client_assertion").collect(Collectors.toSet());

    public AuthorizationCodeGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        if (OauthConstants.isNullOrEmpty(credentials.getRedirectUri())) {
            credentials.setRedirectUri(request.getRequestURL().toString());
        }
        this.getRequired().forEach(attribute -> Validator.INSTANCE.getRequiredValidators().get(attribute).accept(credentials));
        this.getRejected().forEach(attribute -> Validator.INSTANCE.getRejectedValidators().get(attribute).accept(credentials));
        this.credentials = credentials;
        this.request = request;
        this.response = response;
    }

    public String getAuthorizationEndpoint() {
        return this.credentials.getAuthorizationEndpoint();
    }

    public String getTokenEndpoint() {
        return this.credentials.getTokenEndpoint();
    }

    public String getCode() {
        return this.request.getParameter("code");
    }

    protected String getScope() {
        return this.credentials.getScope();
    }

    protected Set<String> getRequired() {
        return this.required;
    }

    protected Set<String> getRejected() {
        return this.rejected;
    }

    @Override
    public Struct getToken() {
        if (!HttpHelper.isError(this.request)) {
            if (HttpHelper.isFirstCall(this.request)) {
                this.authenticateUser();
            } else {
                return this.authenticateClient();
            }
        }
        throw new OauthTag.AuthorizationException();
    }

    private void authenticateUser() {
        String url = this.getAuthorizationURL();
        try {
            this.response.setStatus(302);
            this.response.setHeader("location", url);
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setHeader("Pragma", "no-cache");
        }
        catch (IllegalStateException e) {
            throw new LocationTag.InvalidLocationException(false);
        }
        CFLogs.SERVER_LOG.debug("OAuth login : Redirecting user to Oauth server");
        throw new AbortException();
    }

    protected String getAuthorizationURL() {
        StringBuilder url = new StringBuilder(this.getAuthorizationEndpoint());
        url.append("?").append("client_id").append("=").append(this.credentials.getClientId()).append("&").append("redirect_uri").append("=").append(this.credentials.getRedirectUri()).append("&").append("scope").append("=").append(this.getScope()).append("&").append("response_type").append("=").append("code");
        if (!OauthConstants.isNullOrEmpty(this.credentials.getState())) {
            url.append("&").append("state").append("=").append(this.credentials.getState());
        }
        if (!OauthConstants.isNullOrEmpty(this.credentials.getUrlParams())) {
            url.append("&").append(this.credentials.getUrlParams());
        }
        return url.toString();
    }

    private Struct authenticateClient() {
        String returnedState;
        String code = this.getCode();
        if (!OauthConstants.isNullOrEmpty(this.credentials.getState()) && !(returnedState = this.request.getParameter("state")).equals(this.credentials.getState())) {
            throw new OauthTag.StateMismatchException();
        }
        CFLogs.APPLICATION_LOG.debug("OAuth login : Oauth server returned code - " + code);
        String response = HttpHelper.doPost(this.getTokenEndpoint(), Collections.emptyMap(), this.getEntity());
        if (OauthConstants.isNullOrEmpty(response)) {
            throw new OauthTag.OauthServiceException();
        }
        return this.buildResponse(response);
    }

    protected String getUserInfoEndpoint() {
        throw new UnsupportedOperationException();
    }

    protected HttpEntity getEntity() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("client_id", this.credentials.getClientId()));
        params.add((NameValuePair)new BasicNameValuePair("client_secret", this.credentials.getClientSecret()));
        params.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.credentials.getRedirectUri()));
        params.add((NameValuePair)new BasicNameValuePair("grant_type", GrantType.AUTHORIZATION_CODE.toString()));
        params.add((NameValuePair)new BasicNameValuePair("code", this.getCode()));
        if (!OauthConstants.isNullOrEmpty(this.credentials.getUrlParams())) {
            HttpHelper.parseURLParams(this.credentials.getUrlParams(), params);
        }
        return new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
    }

    @Override
    protected Struct buildResponse(String response) {
        Struct cfoauthResponse = new Struct();
        try {
            cfoauthResponse = (Struct)JSONUtils.deserializeJSON(response);
            String authorizationHeader = "Bearer " + cfoauthResponse.get("access_token");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", authorizationHeader);
            String userInfo = HttpHelper.doGet(this.getUserInfoEndpoint() + (String)(this.credentials.getType().equals((Object)VendorType.FACEBOOK) ? "?appsecret_proof=" + CFPage.HMac(cfoauthResponse.get("access_token"), this.credentials.getClientSecret(), "HMACSHA256").toLowerCase() : ""), headers);
            if (!OauthConstants.isNullOrEmpty(userInfo)) {
                String[] keysToExtract;
                Struct jsonResponse = (Struct)JSONUtils.deserializeJSON(userInfo);
                for (String key : keysToExtract = new String[]{"id", "name", "locale", "gender"}) {
                    if (!jsonResponse.keyExists(key)) continue;
                    cfoauthResponse.put(key, jsonResponse.remove(key));
                }
                if (!jsonResponse.isEmpty()) {
                    cfoauthResponse.put("other", (Object)jsonResponse);
                }
            }
        }
        catch (IOException | UnsupportedOperationException ex) {
            CFLogs.APPLICATION_LOG.error(ex);
        }
        catch (JSONUtils.JSONParseException ex) {
            throw new OauthTag.OauthAppAuthenticationException(ex);
        }
        return cfoauthResponse;
    }
}

