/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant;

import coldfusion.runtime.Struct;
import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.AuthorizationGrant;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.HttpHelper;
import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import coldfusion.tagext.security.oauth.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class ClientCredentialsGrant
extends AuthorizationGrant {
    protected final OauthCredentials credentials;
    protected final Set<String> required = Stream.of("client_id", "client_secret", "token_endpoint").collect(Collectors.toSet());
    protected final Set<String> rejected = Stream.of("apiversion", "redirect_uri", "state", "urlparams", "authorization_endpoint", "client_assertion").collect(Collectors.toSet());

    public ClientCredentialsGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        this.getRequired().forEach(attribute -> Validator.INSTANCE.getRequiredValidators().get(attribute).accept(credentials));
        this.getRejected().forEach(attribute -> Validator.INSTANCE.getRejectedValidators().get(attribute).accept(credentials));
        this.credentials = credentials;
    }

    public String getTokenEndpoint() {
        return this.credentials.getTokenEndpoint();
    }

    protected Set<String> getRequired() {
        return this.required;
    }

    protected Set<String> getRejected() {
        return this.rejected;
    }

    @Override
    public Struct getToken() {
        String response = HttpHelper.doPost(this.getTokenEndpoint(), Collections.emptyMap(), this.getEntity());
        if (OauthConstants.isNullOrEmpty(response)) {
            throw new OauthTag.OauthServiceException();
        }
        return this.buildResponse(response);
    }

    protected String getUserInfoEndpoint() {
        throw new UnsupportedOperationException();
    }

    protected HttpEntity getEntity() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.credentials.getClientId()));
        params.add(new BasicNameValuePair("client_secret", this.credentials.getClientSecret()));
        params.add(new BasicNameValuePair("grant_type", GrantType.CLIENT_CREDENTIALS.toString()));
        if (!OauthConstants.isNullOrEmpty(this.credentials.getScope())) {
            params.add(new BasicNameValuePair("scope", this.credentials.getScope()));
        }
        return new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
    }
}

