/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant.facebook;

import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.grant.ClientCredentialsGrant;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;

public class FacebookClientCredentialsGrant
extends ClientCredentialsGrant {
    public FacebookClientCredentialsGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        super(request, response, credentials);
    }

    @Override
    public String getTokenEndpoint() {
        if (!OauthConstants.isNullOrEmpty(this.credentials.getApiVersion())) {
            return "https://www.facebook.com/" + this.credentials.getApiVersion() + "/oauth/access_token";
        }
        return OauthConstants.getEndpoint(VendorType.FACEBOOK, OauthConstants.EndpointType.TOKEN);
    }

    @Override
    public String getUserInfoEndpoint() {
        if (!OauthConstants.isNullOrEmpty(this.credentials.getApiVersion())) {
            return "https://www.facebook.com/" + this.credentials.getApiVersion() + "/me";
        }
        return OauthConstants.getEndpoint(VendorType.FACEBOOK, OauthConstants.EndpointType.ID);
    }

    @Override
    protected Set<String> getRejected() {
        super.getRejected().add("token_endpoint");
        return super.getRejected();
    }

    @Override
    protected Set<String> getRequired() {
        super.getRequired().removeAll(Set.of("token_endpoint"));
        return super.getRequired();
    }
}

