/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant.facebook;

import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.grant.RefreshTokenGrant;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class FacebookRefreshTokenGrant
extends RefreshTokenGrant {
    public FacebookRefreshTokenGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        super(request, response, credentials);
    }

    @Override
    public String getTokenEndpoint() {
        if (!OauthConstants.isNullOrEmpty(this.credentials.getApiVersion())) {
            return "https://www.facebook.com/" + this.credentials.getApiVersion() + "/me";
        }
        return OauthConstants.getEndpoint(VendorType.FACEBOOK, OauthConstants.EndpointType.TOKEN);
    }

    @Override
    public String getUserInfoEndpoint() {
        if (!OauthConstants.isNullOrEmpty(this.credentials.getApiVersion())) {
            return "https://www.facebook.com/" + this.credentials.getApiVersion() + "/me";
        }
        return OauthConstants.getEndpoint(VendorType.FACEBOOK, OauthConstants.EndpointType.ID);
    }

    @Override
    protected Set<String> getRejected() {
        super.getRejected().add("token_endpoint");
        return super.getRejected();
    }

    @Override
    protected Set<String> getRequired() {
        super.getRequired().removeAll(Set.of("token_endpoint"));
        return super.getRequired();
    }

    @Override
    protected HttpEntity getEntity() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.credentials.getClientId()));
        params.add(new BasicNameValuePair("client_secret", this.credentials.getClientSecret()));
        params.add(new BasicNameValuePair("grant_type", "fb_exchange_token"));
        params.add(new BasicNameValuePair("fb_exchange_token", this.credentials.getRefreshToken()));
        if (!OauthConstants.isNullOrEmpty(this.credentials.getScope())) {
            params.add(new BasicNameValuePair("scope", this.credentials.getScope()));
        }
        return new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
    }
}

