/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant.google;

import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.grant.AuthorizationCodeGrant;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;

public class GoogleAuthorizationCodeGrant
extends AuthorizationCodeGrant {
    public GoogleAuthorizationCodeGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        super(request, response, credentials);
    }

    @Override
    public String getScope() {
        String scope = this.credentials.getScope();
        if (!scope.contains("https://www.googleapis.com/auth/userinfo.profile")) {
            return "https://www.googleapis.com/auth/userinfo.profile+" + scope;
        }
        return scope;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return OauthConstants.getEndpoint(VendorType.GOOGLE, OauthConstants.EndpointType.AUTHORIZATION);
    }

    @Override
    public String getTokenEndpoint() {
        return OauthConstants.getEndpoint(VendorType.GOOGLE, OauthConstants.EndpointType.TOKEN);
    }

    @Override
    public String getUserInfoEndpoint() {
        return OauthConstants.getEndpoint(VendorType.GOOGLE, OauthConstants.EndpointType.ID);
    }

    @Override
    protected Set<String> getRejected() {
        super.getRejected().addAll(Set.of("authorization_endpoint", "token_endpoint"));
        return super.getRejected();
    }

    @Override
    protected Set<String> getRequired() {
        super.getRequired().removeAll(Set.of("authorization_endpoint", "token_endpoint"));
        return super.getRequired();
    }
}

