/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant.microsoft;

import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.HttpHelper;
import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.grant.AuthorizationCodeGrant;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class MicrosoftAuthorizationCodeGrant
extends AuthorizationCodeGrant {
    public MicrosoftAuthorizationCodeGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        super(request, response, credentials);
        if (!OauthConstants.isNullOrEmpty(credentials.getClientAssertion()) && !OauthConstants.isNullOrEmpty(credentials.getClientSecret())) {
            throw new OauthTag.NotSupportedAttributeException("secretkey and client_assertion");
        }
        if (OauthConstants.isNullOrEmpty(credentials.getClientAssertion()) && OauthConstants.isNullOrEmpty(credentials.getClientSecret())) {
            throw new OauthTag.RequiredAttributeException("secretkey or client_assertion");
        }
    }

    @Override
    public String getAuthorizationEndpoint() {
        return OauthConstants.getEndpoint(OauthConstants.EndpointType.AUTHORIZATION, this.credentials.getTenant());
    }

    @Override
    public String getTokenEndpoint() {
        return OauthConstants.getEndpoint(OauthConstants.EndpointType.TOKEN, this.credentials.getTenant());
    }

    @Override
    public String getUserInfoEndpoint() {
        return OauthConstants.getEndpoint(VendorType.MICROSOFT, OauthConstants.EndpointType.ID);
    }

    @Override
    protected Set<String> getRequired() {
        super.getRequired().add("tenant");
        super.getRequired().removeAll(Set.of("authorization_endpoint", "token_endpoint", "client_secret"));
        return super.getRequired();
    }

    @Override
    protected Set<String> getRejected() {
        super.getRejected().removeAll(Set.of("tenant", "client_assertion"));
        super.getRejected().addAll(Set.of("authorization_endpoint", "token_endpoint"));
        return super.getRejected();
    }

    @Override
    protected HttpEntity getEntity() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("client_id", this.credentials.getClientId()));
        params.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.credentials.getRedirectUri()));
        params.add((NameValuePair)new BasicNameValuePair("grant_type", GrantType.AUTHORIZATION_CODE.toString()));
        params.add((NameValuePair)new BasicNameValuePair("code", this.getCode()));
        if (OauthConstants.isNullOrEmpty(this.credentials.getClientSecret())) {
            params.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            params.add((NameValuePair)new BasicNameValuePair("client_assertion", this.credentials.getClientAssertion()));
        } else {
            params.add((NameValuePair)new BasicNameValuePair("client_secret", this.credentials.getClientSecret()));
        }
        if (!OauthConstants.isNullOrEmpty(this.credentials.getUrlParams())) {
            HttpHelper.parseURLParams(this.credentials.getUrlParams(), params);
        }
        return new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
    }
}

