/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.grant.microsoft;

import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.GrantType;
import coldfusion.tagext.security.oauth.OauthCredentials;
import coldfusion.tagext.security.oauth.VendorType;
import coldfusion.tagext.security.oauth.grant.ClientCredentialsGrant;
import coldfusion.tagext.security.oauth.util.OauthConstants;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;

public class MicrosoftClientCredentialsGrant
extends ClientCredentialsGrant {
    public MicrosoftClientCredentialsGrant(HttpServletRequest request, HttpServletResponse response, OauthCredentials credentials) {
        super(request, response, credentials);
        if (!OauthConstants.isNullOrEmpty(credentials.getClientAssertion()) && !OauthConstants.isNullOrEmpty(credentials.getClientSecret())) {
            throw new OauthTag.NotSupportedAttributeException("secretkey and client_assertion");
        }
        if (OauthConstants.isNullOrEmpty(credentials.getClientAssertion()) && OauthConstants.isNullOrEmpty(credentials.getClientSecret())) {
            throw new OauthTag.RequiredAttributeException("secretkey or client_assertion");
        }
    }

    @Override
    public String getTokenEndpoint() {
        return OauthConstants.getEndpoint(OauthConstants.EndpointType.TOKEN, this.credentials.getTenant());
    }

    @Override
    public String getUserInfoEndpoint() {
        return OauthConstants.getEndpoint(VendorType.MICROSOFT, OauthConstants.EndpointType.ID);
    }

    @Override
    protected Set<String> getRequired() {
        super.getRequired().addAll(Set.of("tenant", "scope"));
        super.getRequired().removeAll(Set.of("token_endpoint", "client_secret"));
        return super.getRequired();
    }

    @Override
    protected Set<String> getRejected() {
        super.getRejected().removeAll(Set.of("tenant", "client_assertion"));
        super.getRejected().add("token_endpoint");
        return super.getRejected();
    }

    @Override
    protected HttpEntity getEntity() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.credentials.getClientId()));
        params.add(new BasicNameValuePair("grant_type", GrantType.CLIENT_CREDENTIALS.toString()));
        if (OauthConstants.isNullOrEmpty(this.credentials.getClientSecret())) {
            params.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            params.add(new BasicNameValuePair("client_assertion", this.credentials.getClientAssertion()));
        } else {
            params.add(new BasicNameValuePair("client_secret", this.credentials.getClientSecret()));
        }
        if (!OauthConstants.isNullOrEmpty(this.credentials.getScope())) {
            params.add(new BasicNameValuePair("scope", this.credentials.getScope()));
        }
        return new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
    }
}

