/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.util;

import coldfusion.tagext.security.oauth.VendorType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class OauthConstants {
    public static final String FACEBOOK = "facebook";
    public static final String GOOGLE = "google";
    public static final String MICROSOFT = "microsoft";
    public static final String CODE = "code";
    public static final String CLIENT_ID = "client_id";
    public static final String CF_CLIENT_ID = "clientid";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CF_CLIENT_SECRET = "secretkey";
    public static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    public static final String CF_AUTHORIZATION_ENDPOINT = "authendpoint";
    public static final String TOKEN_ENDPOINT = "token_endpoint";
    public static final String CF_TOKEN_ENDPOINT = "accesstokenendpoint";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CF_REDIRECT_URI = "redirecturi";
    public static final String SCOPE = "scope";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String GRANT_TYPE = "grant_type";
    public static final String CF_GRANT_TYPE = "granttype";
    public static final String URL_PARAMS = "urlparams";
    public static final String API_VERSION = "apiversion";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String CF_REFRESH_TOKEN = "refreshtoken";
    public static final String TENANT = "tenant";
    public static final String PROVIDER_CONFIG = "providerConfig";
    public static final String TYPE = "type";
    public static final String CLIENT_ASSERTION_TYPE = "client_assertion_type";
    public static final String CLIENT_ASSERTION_TYPE_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    public static final String CLIENT_ASSERTION = "client_assertion";
    public static final String CLIENT_SECRET_OR_CLIENT_ASSERTION = "secretkey or client_assertion";
    public static final String CLIENT_SECRET_AND_CLIENT_ASSERTION = "secretkey and client_assertion";
    public static final String RESULT = "result";
    public static final String QUERY_SEPERATOR = "?";
    public static final String AMPERSAND = "&";
    public static final String EQUALS = "=";
    public static final String ACCESSTOKEN = "access_token";
    public static final String USERNAME = "name";
    public static final String LOCALE = "locale";
    public static final String GENDER = "gender";
    public static final String ID = "id";
    public static final String OTHER = "other";
    public static final String GOOGLE_BASIC_SCOPE = "https://www.googleapis.com/auth/userinfo.profile";
    public static final String STATE = "state";
    public static final String ERROR = "error";
    public static final String ERROR_REASON = "error_reason";
    public static final String ERROR_DESCRIPTION = "error_description";
    public static final String FB_EXCHANGE_TOKEN = "fb_exchange_token";
    public static final String FACEBOOK_ENDPOINT = "https://www.facebook.com/";
    public static final String FACEBOOK_AUTHORIZATION_RESOURCE_PATH = "/dialog/oauth";
    public static final String FACEBOOK_TOKEN_RESOURCE_PATH = "/oauth/access_token";
    public static final String FACEBOOK_ID_RESOURCE_PATH = "/me";
    private static final Map<String, String> endpoints = new HashMap<String, String>(32);

    private OauthConstants() {
    }

    public static boolean isNullOrEmpty(String string) {
        return Objects.isNull(string) || string.isEmpty();
    }

    public static String getEndpoint(VendorType vendorType, EndpointType endpointType) {
        return endpoints.get(vendorType.name() + endpointType.name());
    }

    public static String getEndpoint(EndpointType endpointType, String tenant) {
        String endpoint = endpoints.get(VendorType.MICROSOFT.name() + endpointType.name());
        return endpoint.replace("{tenant}", tenant);
    }

    static {
        endpoints.put(VendorType.GOOGLE.name() + EndpointType.AUTHORIZATION.name(), "https://accounts.google.com/o/oauth2/auth");
        endpoints.put(VendorType.GOOGLE.name() + EndpointType.TOKEN.name(), "https://oauth2.googleapis.com/token");
        endpoints.put(VendorType.GOOGLE.name() + EndpointType.ID.name(), "https://www.googleapis.com/oauth2/v1/userinfo");
        endpoints.put(VendorType.GOOGLE.name() + EndpointType.REVOKE.name(), "https://oauth2.googleapis.com/revoke");
        endpoints.put(VendorType.GOOGLE.name() + EndpointType.REVOKE_KEY.name(), "token=");
        endpoints.put(VendorType.FACEBOOK.name() + EndpointType.AUTHORIZATION.name(), "https://www.facebook.com/dialog/oauth");
        endpoints.put(VendorType.FACEBOOK.name() + EndpointType.TOKEN.name(), "https://graph.facebook.com/oauth/access_token");
        endpoints.put(VendorType.FACEBOOK.name() + EndpointType.ID.name(), "https://graph.facebook.com/me");
        endpoints.put(VendorType.FACEBOOK.name() + EndpointType.REVOKE.name(), "https://graph.facebook.com/me/permissions");
        endpoints.put(VendorType.FACEBOOK.name() + EndpointType.REVOKE_KEY.name(), "method=delete&access_token=");
        endpoints.put(VendorType.MICROSOFT.name() + EndpointType.AUTHORIZATION.name(), "https://login.microsoftonline.com/{tenant}/oauth2/v2.0/authorize");
        endpoints.put(VendorType.MICROSOFT.name() + EndpointType.TOKEN.name(), "https://login.microsoftonline.com/{tenant}/oauth2/v2.0/token");
        endpoints.put(VendorType.MICROSOFT.name() + EndpointType.ID.name(), "https://graph.microsoft.com/oidc/userinfo");
        endpoints.put(VendorType.MICROSOFT.name() + EndpointType.REVOKE.name(), "");
        endpoints.put(VendorType.MICROSOFT.name() + EndpointType.REVOKE_KEY.name(), "");
    }

    public static enum EndpointType {
        AUTHORIZATION,
        TOKEN,
        ID,
        REVOKE,
        REVOKE_KEY;

    }
}

