/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.security.oauth.util;

import coldfusion.tagext.security.OauthTag;
import coldfusion.tagext.security.oauth.OauthCredentials;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public enum Validator {
    INSTANCE;

    private final Map<String, Consumer<OauthCredentials>> requiredValidators = new HashMap<String, Consumer<OauthCredentials>>(32);
    private final Map<String, Consumer<OauthCredentials>> rejectedValidators = new HashMap<String, Consumer<OauthCredentials>>(32);

    private Validator() {
        this.requiredValidators.put("client_id", credentials -> {
            if (this.isNullOrEmpty(credentials.getClientId())) {
                throw new OauthTag.RequiredAttributeException("clientid");
            }
        });
        this.rejectedValidators.put("client_id", credentials -> {
            if (!this.isNullOrEmpty(credentials.getClientId())) {
                throw new OauthTag.NotSupportedAttributeException("clientid");
            }
        });
        this.requiredValidators.put("client_secret", credentials -> {
            if (this.isNullOrEmpty(credentials.getClientSecret())) {
                throw new OauthTag.OauthNoSecretkeyException();
            }
        });
        this.requiredValidators.put("scope", credentials -> {
            if (this.isNullOrEmpty(credentials.getScope())) {
                throw new OauthTag.RequiredAttributeException("scope");
            }
        });
        this.rejectedValidators.put("scope", credentials -> {
            if (!this.isNullOrEmpty(credentials.getScope())) {
                throw new OauthTag.NotSupportedAttributeException("scope");
            }
        });
        this.requiredValidators.put("state", credentials -> {
            if (this.isNullOrEmpty(credentials.getState())) {
                throw new OauthTag.RequiredAttributeException("state");
            }
        });
        this.rejectedValidators.put("state", credentials -> {
            if (!this.isNullOrEmpty(credentials.getState())) {
                throw new OauthTag.NotSupportedAttributeException("state");
            }
        });
        this.requiredValidators.put("authorization_endpoint", credentials -> {
            if (this.isNullOrEmpty(credentials.getAuthorizationEndpoint())) {
                throw new OauthTag.RequiredAttributeException("authendpoint");
            }
        });
        this.rejectedValidators.put("authorization_endpoint", credentials -> {
            if (!this.isNullOrEmpty(credentials.getAuthorizationEndpoint())) {
                throw new OauthTag.OauthNoTypeException();
            }
        });
        this.requiredValidators.put("redirect_uri", credentials -> {
            if (this.isNullOrEmpty(credentials.getRedirectUri())) {
                throw new OauthTag.RequiredAttributeException("redirecturi");
            }
        });
        this.rejectedValidators.put("redirect_uri", credentials -> {
            if (!this.isNullOrEmpty(credentials.getRedirectUri())) {
                throw new OauthTag.NotSupportedAttributeException("redirecturi");
            }
        });
        this.rejectedValidators.put("apiversion", credentials -> {
            if (!this.isNullOrEmpty(credentials.getApiVersion())) {
                throw new OauthTag.ApiversionException();
            }
        });
        this.requiredValidators.put("token_endpoint", credentials -> {
            if (this.isNullOrEmpty(credentials.getTokenEndpoint())) {
                throw new OauthTag.RequiredAttributeException("accesstokenendpoint");
            }
        });
        this.rejectedValidators.put("token_endpoint", credentials -> {
            if (!this.isNullOrEmpty(credentials.getTokenEndpoint())) {
                throw new OauthTag.OauthNoTypeException();
            }
        });
        this.requiredValidators.put("refresh_token", credentials -> {
            if (this.isNullOrEmpty(credentials.getRefreshToken())) {
                throw new OauthTag.RequiredAttributeException("refreshtoken");
            }
        });
        this.rejectedValidators.put("refresh_token", credentials -> {
            if (!this.isNullOrEmpty(credentials.getRefreshToken())) {
                throw new OauthTag.NotSupportedAttributeException("refreshtoken");
            }
        });
        this.requiredValidators.put("tenant", credentials -> {
            if (this.isNullOrEmpty(credentials.getTenant())) {
                throw new OauthTag.RequiredAttributeException("tenant");
            }
        });
        this.rejectedValidators.put("tenant", credentials -> {
            if (!this.isNullOrEmpty(credentials.getTenant())) {
                throw new OauthTag.NotSupportedAttributeException("tenant");
            }
        });
        this.requiredValidators.put("client_assertion", credentials -> {
            if (this.isNullOrEmpty(credentials.getClientAssertion())) {
                throw new OauthTag.RequiredAttributeException("secretkey or client_assertion");
            }
        });
        this.rejectedValidators.put("client_assertion", credentials -> {
            if (!this.isNullOrEmpty(credentials.getClientAssertion())) {
                throw new OauthTag.NotSupportedAttributeException("client_assertion");
            }
        });
        this.rejectedValidators.put("urlparams", credentials -> {
            if (!this.isNullOrEmpty(credentials.getUrlParams())) {
                throw new OauthTag.NotSupportedAttributeException("urlparams");
            }
        });
    }

    private boolean isNullOrEmpty(String clientId) {
        return Objects.isNull(clientId) || clientId.isEmpty();
    }

    public Map<String, Consumer<OauthCredentials>> getRequiredValidators() {
        return this.requiredValidators;
    }

    public Map<String, Consumer<OauthCredentials>> getRejectedValidators() {
        return this.rejectedValidators;
    }
}

