/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.runtime.NeoException;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.sql.DatabaseMetaDataUtil;
import coldfusion.sql.Table;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.sql.QueryTag;
import coldfusion.tagext.validation.MissingAttributeException;
import jakarta.servlet.jsp.JspException;
import java.security.Permission;
import java.sql.SQLException;

public class DBInfoTag
extends QueryTag {
    private static final long serialVersionUID = 1L;
    private static final GenericTagPermission tp = new GenericTagPermission("cfdbinfo");
    protected String type;
    protected String tablename;
    protected String pattern;
    protected DatabaseMetaDataUtil dbMetaDataUtil = null;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setType(String type) {
        if (type == null || type.trim().length() == 0) {
            throw new QueryTag.InvalidAttributeValueException(this, "type");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setTable(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new QueryTag.InvalidAttributeValueException(this, "table");
        }
        this.tablename = name;
    }

    public String getTable() {
        return this.tablename;
    }

    public void setPattern(String pattern) {
        if (pattern == null || pattern.trim().length() == 0) {
            throw new QueryTag.InvalidAttributeValueException(this, "pattern");
        }
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void release() {
        this.tablename = null;
        this.type = null;
        this.pattern = null;
    }

    @Override
    public int doStartTag() throws JspException {
        this.dbMetaDataUtil = new DatabaseMetaDataUtil();
        this.onTagStart();
        if (this.name == null || this.name.trim().length() == 0) {
            throw new QueryTag.InvalidAttributeValueException(this, "name");
        }
        int val = super.doStartTag();
        this.validate();
        try {
            this.impl.validate();
        }
        catch (SQLException ex) {
            throw new QueryTag.DataSourceException(this, ex, this.datasource.toString());
        }
        return val == 2 ? 1 : val;
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            Table resTable = this.fetchDBMetaData();
            this.setQueryResult(resTable);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)this.resultTable);
            }
        }
        catch (RequestTimedOutException ex) {
            throw this.setRequestTimedOutTagName(ex);
        }
        catch (SQLException ex) {
            throw new QueryTag.DatabaseQueryException(this, (Throwable)ex, this.impl, this.datasource);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    protected Table fetchDBMetaData() throws SQLException {
        this.dbMetaDataUtil.setSqlImpl(this.impl);
        if (this.type.equalsIgnoreCase("version")) {
            return this.dbMetaDataUtil.getVersion();
        }
        if (this.type.equalsIgnoreCase("tables")) {
            return this.dbMetaDataUtil.getTables(this.pattern);
        }
        if (this.type.equalsIgnoreCase("procedures")) {
            return this.dbMetaDataUtil.getProcedures(this.pattern);
        }
        if (this.type.equalsIgnoreCase("index")) {
            return this.dbMetaDataUtil.getIndex(this.tablename);
        }
        if (this.type.equalsIgnoreCase("foreignkeys")) {
            return this.dbMetaDataUtil.getForeignkeys(this.tablename);
        }
        if (this.type.equalsIgnoreCase("columns")) {
            return this.dbMetaDataUtil.getColumns(this.tablename, this.pattern);
        }
        if (this.type.equalsIgnoreCase("dbnames")) {
            return this.dbMetaDataUtil.getDbNames();
        }
        if (this.type.equalsIgnoreCase("clientinfo")) {
            return this.dbMetaDataUtil.getClientInfo();
        }
        return null;
    }

    private void validateAttributes() throws DBInfoAttributeException {
        if (this.type.equalsIgnoreCase("version")) {
            if (this.pattern != null) {
                throw new DBInfoAttributeException("version", "pattern");
            }
            if (this.tablename != null) {
                throw new DBInfoAttributeException("version", "table");
            }
        } else if (this.type.equalsIgnoreCase("tables")) {
            if (this.tablename != null) {
                throw new DBInfoAttributeException("tables", "table");
            }
        } else if (this.type.equalsIgnoreCase("procedures")) {
            if (this.tablename != null) {
                throw new DBInfoAttributeException("procedures", "table");
            }
        } else if (this.type.equalsIgnoreCase("index")) {
            if (this.pattern != null) {
                throw new DBInfoAttributeException("index", "pattern");
            }
            if (this.tablename == null) {
                throw new MissingAttributeException("table");
            }
        } else if (this.type.equalsIgnoreCase("foreignkeys")) {
            if (this.pattern != null) {
                throw new DBInfoAttributeException("foreignkeys", "pattern");
            }
            if (this.tablename == null) {
                throw new MissingAttributeException("table");
            }
        } else if (this.type.equalsIgnoreCase("dbnames")) {
            if (this.pattern != null) {
                throw new DBInfoAttributeException("dbnames", "pattern");
            }
            if (this.tablename != null) {
                throw new DBInfoAttributeException("dbnames", "table");
            }
        } else if (this.type.equalsIgnoreCase("columns")) {
            if (this.tablename == null) {
                throw new MissingAttributeException("table");
            }
        } else {
            throw new InvalidTypeException(this.type);
        }
    }

    public class DBInfoAttributeException
    extends NeoException {
        protected String type;
        protected String attribute;

        DBInfoAttributeException(String type, String attribute) {
            this.type = type;
            this.attribute = attribute;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String getAttribute() {
            return this.attribute;
        }
    }

    public class InvalidTypeException
    extends NeoException {
        protected String type;

        InvalidTypeException(String type) {
            this.type = type;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }
}

