/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.filter.FormScope;
import coldfusion.runtime.Array;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.TemplateException;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.sql.SqlImpl;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.sql.DatabaseMetaDataException;
import coldfusion.tagext.sql.InsertTag;
import coldfusion.tagext.sql.QueryTag;
import coldfusion.tagext.sql.TransactionTag;
import coldfusion.tagext.sql.UpdateTag;
import jakarta.servlet.jsp.JspException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;

public class GridUpdateTag
extends QueryTag {
    private static final long serialVersionUID = 1L;
    private static final int BIT_TRUE = 1;
    private static final int BIT_FALSE = 2;
    private static final int BIT_INVALID = 3;
    private static final GenericTagPermission tp = new GenericTagPermission("cfgridupdate");
    protected String table_name;
    protected String table_owner;
    protected String table_qualifier;
    protected String grid;
    protected boolean keyOnly = false;
    private static final String debugDisplayName = "CFGRIDUPDATE";
    private Exception loc = null;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setKeyonly(boolean keyOnly) {
        this.keyOnly = keyOnly;
    }

    public void setGrid(String grid) {
        this.grid = grid;
    }

    public void setTablename(String name) {
        if (name == null) {
            this.table_name = null;
        } else {
            int index = name.lastIndexOf(".");
            if (index != -1) {
                int firstdot = name.indexOf(46);
                if (firstdot == index) {
                    this.table_name = name;
                    this.table_owner = null;
                    this.table_qualifier = null;
                } else {
                    this.table_name = name.substring(index + 1);
                    this.table_qualifier = name.substring(0, firstdot);
                    this.table_owner = name.substring(firstdot + 1, index);
                }
            } else {
                this.table_name = name;
            }
        }
    }

    public void setTableowner(String owner) {
        this.table_owner = owner;
    }

    public void setTablequalifier(String s) {
        this.table_qualifier = s;
    }

    @Override
    public void release() {
        this.table_name = null;
        this.table_owner = null;
        this.table_qualifier = null;
        this.grid = null;
        this.keyOnly = false;
        super.release();
    }

    protected String substituteForBoolean(String pval, int stype) {
        String val = pval.trim();
        int type = val.equalsIgnoreCase("TRUE") ? 1 : (val.equalsIgnoreCase("YES") ? 1 : (val.equalsIgnoreCase("-1") ? 1 : (val.equalsIgnoreCase("ON") ? 1 : (val.equalsIgnoreCase("1") ? 1 : (val.equalsIgnoreCase("FALSE") ? 2 : (val.equalsIgnoreCase("NO") ? 2 : (val.equalsIgnoreCase("OFF") ? 2 : (val.equalsIgnoreCase("0") ? 2 : 3))))))));
        if (type == 1 || type == 3) {
            return "1";
        }
        return "0";
    }

    private ResultSet getColumns(final DatabaseMetaData meta, final String tname) throws SQLException {
        if (System.getSecurityManager() == null) {
            return meta.getColumns(this.table_qualifier, this.table_owner, tname, "%");
        }
        try {
            return (ResultSet)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return meta.getColumns(GridUpdateTag.this.table_qualifier, GridUpdateTag.this.table_owner, tname, "%");
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (SQLException)ex.getException();
        }
    }

    private ResultSet getPrimaryKeys(final DatabaseMetaData meta) throws SQLException {
        if (System.getSecurityManager() == null) {
            return meta.getPrimaryKeys(this.table_qualifier, this.table_owner, this.table_name);
        }
        try {
            return (ResultSet)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return meta.getPrimaryKeys(GridUpdateTag.this.table_qualifier, GridUpdateTag.this.table_owner, GridUpdateTag.this.table_name);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (SQLException)ex.getException();
        }
    }

    private ResultSet getBestRowIdentifier(final DatabaseMetaData meta) throws SQLException {
        if (System.getSecurityManager() == null) {
            return meta.getBestRowIdentifier(this.table_qualifier, this.table_owner, this.table_name, 0, false);
        }
        try {
            return (ResultSet)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return meta.getBestRowIdentifier(GridUpdateTag.this.table_qualifier, GridUpdateTag.this.table_owner, GridUpdateTag.this.table_name, 0, false);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (SQLException)ex.getException();
        }
    }

    private void resultSetClose(final ResultSet rset) throws SQLException {
        if (System.getSecurityManager() == null) {
            rset.close();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        rset.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw (SQLException)ex.getException();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int doStartTag() throws JspException {
        block51: {
            Column column;
            QueryTable pkQueryTable;
            QueryTable columnQueryTable;
            int actionsSize;
            Array actions;
            FormScope form;
            DebuggingService debuggingService;
            block52: {
                DatabaseMetaData meta22222;
                this.onTagStart();
                debuggingService = ServiceFactory.getDebuggingService();
                if (debuggingService != null && debuggingService.check(4)) {
                    this.loc = new Exception();
                }
                this.validate();
                try {
                    this.impl.validate();
                    int[] intar = new int[]{0};
                    this.impl.setResultSetList(intar);
                }
                catch (SQLException ex) {
                    throw new QueryTag.DataSourceException(this, ex, this.datasource);
                }
                form = (FormScope)this.pageContext.findAttribute("FORM");
                actions = (Array)form.get(this.grid + ".ROWSTATUS.ACTION");
                if (actions == null) {
                    throw new GridNotFoundException(this.grid);
                }
                actionsSize = actions.size();
                if (actionsSize <= 0) break block51;
                ResultSet rset = null;
                columnQueryTable = null;
                pkQueryTable = null;
                Connection con = this.impl.getConnection();
                if (con.getMetaData().getDatabaseProductName().contains("Oracle")) {
                    this.table_name = this.table_name.toUpperCase();
                }
                if ((columnQueryTable = new QueryTable(rset = this.getColumns(meta22222 = con.getMetaData(), this.table_name))).getRowCount() <= 0) {
                    throw new InsertTag.ColumnsNotFoundException(this.table_name);
                }
                this.resultSetClose(rset);
                try {
                    rset = this.getPrimaryKeys(meta22222);
                }
                catch (SQLException se) {
                    try {
                        rset = this.getBestRowIdentifier(meta22222);
                    }
                    catch (SQLException se2) {
                        throw new UpdateTag.PrimaryKeyNotFoundException(se2, this.table_name);
                    }
                }
                pkQueryTable = new QueryTable(rset);
                try {
                    this.resultSetClose(rset);
                }
                catch (SQLException meta22222) {}
                break block52;
                catch (SQLException ex) {
                    try {
                        throw new DatabaseMetaDataException(ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.resultSetClose(rset);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            ArrayList<Column> columns = new ArrayList<Column>();
            ArrayList<Column> pkColumns = new ArrayList<Column>();
            ArrayList<Column> valueColumns = new ArrayList<Column>();
            HashSet<String> pkColumnNames = new HashSet<String>();
            boolean bNoTablePKs = false;
            boolean bMissingPKs = false;
            Object missingPKs = "";
            try {
                String columnName;
                while (columnQueryTable.next()) {
                    columnName = columnQueryTable.getString("COLUMN_NAME");
                    if (!form.containsKey(this.grid + "." + columnName.toUpperCase())) continue;
                    int dataType = columnQueryTable.getInt("DATA_TYPE");
                    Array columnData = (Array)form.get(this.grid + "." + columnName);
                    Array origColumnData = (Array)form.get(this.grid + ".ORIGINAL." + columnName);
                    columns.add(new Column(columnName, dataType, columnData, origColumnData, null));
                }
                if (pkQueryTable.getRecordCount() == 0) {
                    bNoTablePKs = true;
                } else {
                    while (pkQueryTable.next()) {
                        columnName = pkQueryTable.getString("COLUMN_NAME");
                        pkColumnNames.add(columnName);
                        if (form.containsKey(this.grid + "." + columnName.toUpperCase())) continue;
                        if (bMissingPKs) {
                            missingPKs = (String)missingPKs + ", ";
                        }
                        missingPKs = (String)missingPKs + columnName;
                        bMissingPKs = true;
                    }
                }
            }
            catch (SQLException ex) {
                throw new DatabaseMetaDataException(ex);
            }
            int columnsSize = columns.size();
            StringBuffer lColumns = new StringBuffer();
            for (int i = 0; i < columnsSize; ++i) {
                column = (Column)columns.get(i);
                if (pkColumnNames.contains(column.name)) {
                    pkColumns.add(column);
                } else {
                    valueColumns.add(column);
                }
                lColumns.append(column.name);
                if (i == columnsSize - 1) continue;
                lColumns.append(", ");
            }
            String tableString = (String)(this.table_qualifier == null || this.table_qualifier.length() == 0 ? "" : this.table_qualifier + ".") + (String)(this.table_owner == null || this.table_owner.length() == 0 ? "" : this.table_owner + ".") + this.table_name;
            for (int row = 0; row < actionsSize; ++row) {
                String action = (String)actions.get(row);
                StringBuffer sql = new StringBuffer();
                ArrayList<InParam> inParams = new ArrayList<InParam>();
                this.impl.clearSqlParams();
                if (action.equals("I")) {
                    Object cols = "";
                    Object val = "";
                    for (int iCol = 0; iCol < columnsSize; ++iCol) {
                        column = (Column)columns.get(iCol);
                        if (column.data.get(row).toString().trim().equals(column.origData.get(row).toString().trim())) continue;
                        if (((String)cols).length() > 0) {
                            cols = (String)cols + ",";
                            val = (String)val + ",";
                        }
                        cols = (String)cols + column.name;
                        val = (String)val + "?";
                        inParams.add(new InParam((String)column.data.get(row), column.sqltype, null));
                    }
                    sql.append("insert into ").append(tableString).append(" (").append((String)cols).append(") ");
                    sql.append("values (").append((String)val).append(")");
                } else if (action.equals("D")) {
                    if (bNoTablePKs) {
                        throw new UpdateTag.NoPrimaryKeyException(this.table_name);
                    }
                    if (bMissingPKs) {
                        throw new GridUpdateMissingKeysException((String)missingPKs);
                    }
                    sql.append("delete from ").append(tableString).append(" where ");
                    int pkColumnsSize = pkColumns.size();
                    for (int iCol = 0; iCol < pkColumnsSize; ++iCol) {
                        column = (Column)pkColumns.get(iCol);
                        inParams.add(new InParam((String)column.origData.get(row), column.sqltype, null));
                        sql.append(column.name).append(" = ?");
                        if (iCol == pkColumnsSize - 1) continue;
                        sql.append(" and ");
                    }
                } else if (action.equals("U")) {
                    int iCol;
                    if (bNoTablePKs) {
                        throw new UpdateTag.NoPrimaryKeyException(this.table_name);
                    }
                    if (bMissingPKs) {
                        throw new GridUpdateMissingKeysException((String)missingPKs);
                    }
                    for (int iCol2 = 0; iCol2 < pkColumns.size(); ++iCol2) {
                        String origdata;
                        column = (Column)pkColumns.get(iCol2);
                        String data = (String)column.data.get(row);
                        if (data.equals(origdata = (String)column.origData.get(row))) continue;
                        throw new PrimaryKeysUpdationException(column.name);
                    }
                    sql.append("update ").append(tableString).append(" set ");
                    int valueColumnsSize = valueColumns.size();
                    for (int iCol3 = 0; iCol3 < valueColumnsSize; ++iCol3) {
                        column = (Column)valueColumns.get(iCol3);
                        inParams.add(new InParam((String)column.data.get(row), column.sqltype, null));
                        sql.append(column.name).append(" = ?");
                        if (iCol3 == valueColumnsSize - 1) continue;
                        sql.append(", ");
                    }
                    sql.append(" where ");
                    int pkColumnsSize = pkColumns.size();
                    for (iCol = 0; iCol < pkColumnsSize; ++iCol) {
                        column = (Column)pkColumns.get(iCol);
                        inParams.add(new InParam((String)column.data.get(row), column.sqltype, null));
                        sql.append(column.name).append(" = ?");
                        if (iCol == pkColumnsSize - 1) continue;
                        sql.append(" and ");
                    }
                    if (!this.keyOnly) {
                        for (iCol = 0; iCol < valueColumnsSize; ++iCol) {
                            column = (Column)valueColumns.get(iCol);
                            String data = (String)column.origData.get(row);
                            if (data == null || data.length() == 0) continue;
                            sql.append(" and ");
                            inParams.add(new InParam((String)column.origData.get(row), column.sqltype, null));
                            sql.append(column.name).append(" = ?");
                        }
                    }
                }
                this.impl.setSql(sql.toString());
                try {
                    boolean inTxn;
                    int inParamsSize = inParams.size();
                    for (int i = 0; i < inParamsSize; ++i) {
                        this.addInParam((InParam)inParams.get(i));
                    }
                    boolean bl = inTxn = TransactionTag.getCurrent() != null;
                    if (this.impl.getParamList() == null || this.impl.getParamList().length() <= 0) continue;
                    if (debuggingService != null && debuggingService.getDebugger() != null && debuggingService.check(4)) {
                        long startTime = System.currentTimeMillis();
                        this.impl.execute(inTxn, this.clientInfo);
                        debuggingService.getDebugger().sql(this.impl.getSql(), debugDisplayName, this.datasource, this.loc, startTime, System.currentTimeMillis());
                        continue;
                    }
                    this.impl.execute(inTxn, this.clientInfo);
                    continue;
                }
                catch (RequestTimedOutException ex) {
                    throw this.setRequestTimedOutTagName(ex);
                }
                catch (SQLException ex) {
                    throw new QueryTag.DatabaseQueryException(this, (Throwable)ex, this.impl, this.datasource);
                }
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        this.onTagEnd();
        return 6;
    }

    protected void addInParam(InParam inParam) throws SQLException {
        if (!(inParam.sqltype != 92 && inParam.sqltype != 93 && inParam.sqltype != 91 || inParam.param == null || inParam.param.equalsIgnoreCase(""))) {
            inParam.param = QueryTag.processSpecialSqlTypes(inParam.param, inParam.sqltype).toString();
        } else if (inParam.sqltype == -7 && inParam.param != null && !inParam.param.equalsIgnoreCase("")) {
            inParam.param = this.substituteForBoolean(inParam.param, inParam.sqltype);
        }
        this.impl.setInParam(inParam.param, inParam.sqltype, -1, null, null);
    }

    @Override
    protected RequestTimedOutException setRequestTimedOutTagName(RequestTimedOutException ex) {
        ex.tname = debugDisplayName;
        return ex;
    }

    public class GridNotFoundException
    extends TemplateException {
        private static final long serialVersionUID = 1L;
        public String grid;

        GridNotFoundException(String grid) {
            this.grid = grid;
        }
    }

    private class Column {
        public String name;
        public int sqltype;
        public String sqltype_name;
        public Array data;
        public Array origData;

        public Column(String name, int sqltype, Array data, Array origData, String sqltype_name) {
            this.name = name;
            this.sqltype = sqltype;
            this.sqltype_name = sqltype_name;
            this.data = data;
            this.origData = origData;
        }
    }

    private class InParam {
        public String param;
        public int sqltype;
        public String sqltype_name;

        public InParam(String param, int sqltype, String sqltype_name) {
            this.param = param;
            this.sqltype = sqltype;
            this.sqltype_name = sqltype_name;
        }
    }

    public class GridUpdateMissingKeysException
    extends TemplateException {
        private static final long serialVersionUID = 1L;
        public Object ds;
        public String table;
        public String missingPKs;

        GridUpdateMissingKeysException(String missingPKs) {
            this.ds = GridUpdateTag.this.datasource;
            this.table = GridUpdateTag.this.table_name;
            this.missingPKs = missingPKs;
        }
    }

    public class PrimaryKeysUpdationException
    extends TemplateException {
        private static final long serialVersionUID = 1L;
        public String primarykey;
        public Object ds;
        public String table;

        PrimaryKeysUpdationException(String primarykey) {
            this.ds = GridUpdateTag.this.datasource;
            this.table = GridUpdateTag.this.table_name;
            this.primarykey = primarykey;
        }
    }

    public class GridUpdateNoRowsException
    extends QueryTag.DatabaseQueryException {
        private static final long serialVersionUID = 1L;

        GridUpdateNoRowsException(SqlImpl impl) {
            super(GridUpdateTag.this, impl);
        }
    }
}

