/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.monitor.util.CommonUtil;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryColumn;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.tagext.sql.QueryTag;
import jakarta.servlet.jsp.JspException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class QueryUtils {
    private static String queryName;
    private static final String ARRAY = "array";
    private static final String RETURN_TYPE = "RETURNTYPE";
    private static final String STRUCT = "struct";
    private static final String QUERY = "query";
    private static final String JSON_ARRAY = "json/array";
    private static final String JSON_STRUCT = "json/struct";
    private static final String RESULTSET = "RESULTSET";
    public static final String NAMED_PARAM_SEPARATORS = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\";

    public static void setQueryName(String qName) {
        queryName = qName;
    }

    public static Object executeQuery(String sql) {
        return QueryUtils.executeQuery(sql, null, new HashMap());
    }

    public static Object executeQuery(String sql, Object queryParams) {
        return QueryUtils.executeQuery(sql, queryParams, new HashMap());
    }

    public static Object executeQuery(String sql, Object queryParams, Map queryOptions) {
        if (queryOptions == null) {
            queryOptions = new HashMap<String, String>();
        }
        queryOptions.put("queryName", queryName);
        QueryTag queryTag = new QueryTag(queryOptions);
        Object query = null;
        try {
            queryTag.initDebugSetting();
            queryTag.setSql(sql);
            if (queryParams != null) {
                QueryUtils.processQueryParam(sql, queryParams, queryTag);
            }
            queryTag.doValidate();
            queryTag.setSqlStringToImpl(queryTag.getSql());
            query = queryTag.startQueryExecution();
            Object returnType = queryOptions.get(RETURN_TYPE);
            if (returnType != null && returnType instanceof String && query instanceof QueryTable) {
                return QueryUtils.handleReturnType(query, returnType);
            }
        }
        catch (JspException e) {
            throw new QueryExecuteException((Exception)((Object)e));
        }
        return query;
    }

    public static Object handleReturnType(Object query, Object returnType) {
        QueryTable qTable = (QueryTable)query;
        String rType = (String)returnType;
        switch (rType.toLowerCase()) {
            case "array": {
                return QueryUtils.getResultsetFromTable(qTable);
            }
            case "json/array": {
                return JSONUtils.serializeJSON(QueryUtils.getResultsetFromTable(qTable));
            }
            case "struct": {
                return QueryUtils.tableToStruct(qTable);
            }
            case "json/struct": {
                return JSONUtils.serializeJSON(QueryUtils.tableToStruct(qTable));
            }
            case "": 
            case "query": {
                return qTable;
            }
        }
        throw new QueryMetadataException("returnType", rType);
    }

    public static Struct tableToStruct(QueryTable table) {
        Struct response = new Struct();
        response.put(RESULTSET, (Object)QueryUtils.getResultsetFromTable(table));
        QueryTableMetaData meta = table.getMeta();
        if (meta != null) {
            response.putAll((Map)meta.getExtendedMetaData());
        }
        return response;
    }

    public static List getResultsetFromTable(QueryTable query) {
        ResultSetMetaData metadata = query.getMetaData();
        try {
            int columns = metadata.getColumnCount();
            ArrayList<Struct> list = new ArrayList<Struct>(query.getRecordCount());
            QueryColumn[] resultsetColumns = new QueryColumn[columns];
            for (int i = 1; i <= columns; ++i) {
                resultsetColumns[i - 1] = (QueryColumn)query.getColumn(i);
            }
            int rowNum = 0;
            while (query.next()) {
                Struct row = new Struct(columns);
                for (int i = 1; i <= columns; ++i) {
                    row.put(metadata.getColumnName(i), resultsetColumns[i - 1].get(rowNum));
                }
                list.add(row);
                ++rowNum;
            }
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void processQueryParam(String sql, Object queryParams, QueryTag queryTag) {
        if (queryParams instanceof Map) {
            queryParams = QueryUtils.convertQueryParamsMapToList((Map)queryParams, queryTag);
            sql = queryTag.getSql();
        }
        if (queryParams instanceof List) {
            List qParamsList = (List)queryParams;
            int paramCount = 0;
            int stringLength = sql.length();
            StringBuilder formattedSql = new StringBuilder("");
            boolean withinQuotes = false;
            boolean singleLineComment = false;
            char lookingFor = 'a';
            for (int index = 0; index < stringLength; ++index) {
                char c = sql.charAt(index);
                if (singleLineComment && (c == '\n' || c == '\r')) {
                    singleLineComment = false;
                }
                if (!withinQuotes && c == '-' && index + 1 < stringLength && sql.charAt(index + 1) == '-') {
                    singleLineComment = true;
                }
                if (!(singleLineComment || c != '\"' && c != '\'')) {
                    if (withinQuotes && c == lookingFor) {
                        withinQuotes = false;
                    } else if (!withinQuotes) {
                        withinQuotes = true;
                        lookingFor = c;
                    }
                }
                if (c == '?' && !withinQuotes && !singleLineComment) {
                    boolean quoted = QueryUtils.isCharQuoted(sql, NAMED_PARAM_SEPARATORS, index + 1);
                    if (quoted) {
                        formattedSql.append(c);
                        continue;
                    }
                    Object param = null;
                    try {
                        param = qParamsList.get(paramCount++);
                    }
                    catch (Exception e) {
                        throw new QueryParseException("Lesser number (" + ((List)queryParams).size() + ") of positional parameters are defined for sql query':' [" + sql + "]");
                    }
                    String conditionStr = QueryUtils.parseAndAddParam(queryTag, param);
                    formattedSql.append(conditionStr);
                    continue;
                }
                formattedSql.append(c);
            }
            queryTag.setSql(formattedSql.toString());
            if (((List)queryParams).size() > paramCount) {
                throw new QueryParseException("Excess number (" + ((List)queryParams).size() + ") of positional parameters are defined for sql query':' [" + sql + "]");
            }
        }
    }

    private static List convertQueryParamsMapToList(Map paramsMap, QueryTag queryTag) {
        String query = queryTag.getSql().trim();
        ArrayList paramList = new ArrayList(paramsMap.size());
        if (paramsMap.size() == 0) {
            queryTag.setSql(query);
            return paramList;
        }
        Character singleQuoteChar = Character.valueOf('\'');
        Character doubleQuoteChar = Character.valueOf('\"');
        Character prevChar = Character.valueOf(' ');
        List<Character> namedParamStartCharList = Arrays.asList(Character.valueOf(':'));
        int length = query.length();
        StringBuffer parsedQuery = new StringBuffer(length);
        boolean isSingleQuote = false;
        boolean isDoubleQuote = false;
        boolean sqlTypeComment = false;
        for (int index = 0; index < length; ++index) {
            char currentChar = query.charAt(index);
            if (!isSingleQuote && !isDoubleQuote && prevChar.charValue() == '-' && currentChar == '-') {
                sqlTypeComment = true;
            }
            if (!isSingleQuote && !isDoubleQuote && (currentChar == '\n' || currentChar == '\r' && sqlTypeComment)) {
                sqlTypeComment = false;
            }
            if (!sqlTypeComment) {
                if (isSingleQuote) {
                    if (currentChar == singleQuoteChar.charValue()) {
                        isSingleQuote = false;
                    }
                } else if (isDoubleQuote) {
                    if (currentChar == doubleQuoteChar.charValue()) {
                        isDoubleQuote = false;
                    }
                } else if (currentChar == singleQuoteChar.charValue()) {
                    isSingleQuote = true;
                } else if (currentChar == doubleQuoteChar.charValue()) {
                    isDoubleQuote = true;
                } else if (namedParamStartCharList.contains(Character.valueOf(currentChar)) && index + 1 < length) {
                    if (namedParamStartCharList.contains(Character.valueOf(query.charAt(index + 1)))) {
                        parsedQuery.append(currentChar);
                        parsedQuery.append(query.charAt(index + 1));
                        ++index;
                        continue;
                    }
                    if (Character.isJavaIdentifierStart(query.charAt(index + 1))) {
                        int j;
                        for (j = index + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                        }
                        String name = query.substring(index + 1, j);
                        currentChar = '?';
                        index += name.length();
                        Object paramObj = paramsMap.get(name);
                        if (paramObj != null) {
                            paramList.add(paramObj);
                        }
                    }
                }
            }
            parsedQuery.append(currentChar);
            prevChar = Character.valueOf(currentChar);
        }
        queryTag.setSql(parsedQuery.toString());
        return paramList;
    }

    private static int firstIndexOfChar(String sqlString, String namedSeparators, int startindex) {
        int matchAt = -1;
        for (int i = 0; i < namedSeparators.length(); ++i) {
            int curMatch = sqlString.indexOf(namedSeparators.charAt(i), startindex);
            if (curMatch < 0) continue;
            matchAt = matchAt == -1 ? curMatch : Math.min(matchAt, curMatch);
        }
        return matchAt;
    }

    private static boolean isCharQuoted(String sqlString, String string, int startindex) {
        int permissibleCharMatch = QueryUtils.firstIndexOfChar(sqlString, string, startindex);
        return QueryUtils.isCharQuoted(sqlString, startindex, permissibleCharMatch);
    }

    private static boolean isCharQuoted(String sqlString, int startindex, int permissibleCharIndex) {
        int QuoteMatchAt;
        int indexOfSingleQuote;
        int indexOfDoubleQuote = sqlString.indexOf(34, startindex);
        if (indexOfDoubleQuote <= 0) {
            indexOfDoubleQuote = sqlString.length();
        }
        if ((indexOfSingleQuote = sqlString.indexOf(39, startindex)) <= 0) {
            indexOfSingleQuote = sqlString.length();
        }
        return permissibleCharIndex >= (QuoteMatchAt = Math.min(indexOfDoubleQuote, indexOfSingleQuote));
    }

    private static String parseAndAddParam(QueryTag queryTag, Object param) {
        String sqltype_name = "CF_SQL_CHAR";
        int sqltype = 1;
        int scale = 0;
        String sqlCondition = "?";
        if (param instanceof Map) {
            Object listParam;
            boolean isList;
            Map paramMap = (Map)param;
            Object value = paramMap.get("VALUE");
            sqltype_name = (String)paramMap.get("CFSQLTYPE");
            if (sqltype_name == null) {
                sqltype_name = "CF_SQL_CHAR";
                sqltype = 1;
            } else {
                sqltype = QueryUtils.resolveSqlType(sqltype_name);
            }
            if (sqltype == 0) {
                throw new QueryMetadataException("CFSQLType", sqltype_name);
            }
            String scaleParam = null;
            if (paramMap.get("SCALE") != null) {
                scaleParam = paramMap.get("SCALE").toString();
            }
            if (scaleParam != null) {
                try {
                    scale = Integer.parseInt(scaleParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = isList = (listParam = paramMap.get("LIST")) == null ? false : Cast._boolean(listParam);
            if (isList && value instanceof String) {
                sqlCondition = QueryUtils.setInListParam(value, sqltype, scale, sqltype_name, queryTag, paramMap);
            } else {
                QueryUtils.setInParam(value, sqltype, scale, sqltype_name, queryTag, paramMap);
            }
        } else {
            QueryUtils.setInParam(param, sqltype, scale, sqltype_name, queryTag, null);
        }
        return sqlCondition;
    }

    private static String setInListParam(Object value, int sqltype, int scale, String sqltype_name, QueryTag queryTag, Map paramProps) {
        String sep = (String)paramProps.get("SEPARATOR");
        StringBuffer sb = new StringBuffer();
        if (sep == null) {
            sep = ",";
        }
        StringTokenizer tok = new StringTokenizer((String)value, sep);
        int i = 0;
        int count = tok.countTokens();
        if (count == 0) {
            sb.append('?');
            QueryUtils.setInParam("", 1, scale, sqltype_name, queryTag, paramProps);
        } else {
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                sb.append('?');
                if (i < count - 1) {
                    sb.append(',');
                }
                QueryUtils.setInParam(token, sqltype, scale, sqltype_name, queryTag, paramProps);
                ++i;
            }
        }
        return sb.toString();
    }

    protected static void setInParam(Object v, int sqltype, int sc, String stype_name, QueryTag queryTag, Map paramProps) {
        if (paramProps != null && paramProps.size() > 0) {
            int maxlength = -1;
            String sNull = paramProps.get("NULL") == null ? null : "" + paramProps.get("NULL");
            String sMaxLength = null;
            if (paramProps.get("MAXLENGTH") != null) {
                sMaxLength = paramProps.get("MAXLENGTH").toString();
            }
            if (sNull != null && Cast._boolean(sNull)) {
                v = null;
                sc = -1;
            } else if (sMaxLength != null && (maxlength = Integer.parseInt(sMaxLength)) >= 0 && (v instanceof String && ((String)v).length() > maxlength || v instanceof char[] && ((char[])v).length > maxlength)) {
                throw new InvalidDataException(v, maxlength);
            }
        }
        if (sqltype != 2 && sqltype != 3) {
            sc = -1;
        }
        if ((sqltype == 92 || sqltype == 93 || sqltype == 91) && v != null) {
            v = QueryTag.processSpecialSqlTypes(v, sqltype);
        }
        queryTag.getSqlImpl().setInParam(v, sqltype, sc, stype_name, null);
    }

    protected static int resolveSqlType(String s) {
        int sqltype = "CF_SQL_BIGINT".equalsIgnoreCase(s) || "BIGINT".equalsIgnoreCase(s) ? -5 : ("CF_SQL_ARRAY".equalsIgnoreCase(s) || "ARRAY".equalsIgnoreCase(s) ? 2003 : ("CF_SQL_BINARY".equalsIgnoreCase(s) || "BINARY".equalsIgnoreCase(s) ? -2 : ("CF_SQL_BIT".equalsIgnoreCase(s) || "BIT".equalsIgnoreCase(s) ? -7 : ("CF_SQL_BLOB".equalsIgnoreCase(s) || "BLOB".equalsIgnoreCase(s) ? 2004 : ("CF_SQL_CHAR".equalsIgnoreCase(s) || "CHAR".equalsIgnoreCase(s) ? 1 : ("CF_SQL_CLOB".equalsIgnoreCase(s) || "CLOB".equalsIgnoreCase(s) ? 2005 : ("CF_SQL_DATE".equalsIgnoreCase(s) || "DATE".equalsIgnoreCase(s) ? 91 : ("CF_SQL_DECIMAL".equalsIgnoreCase(s) || "DECIMAL".equalsIgnoreCase(s) ? 3 : ("CF_SQL_DISTINCT".equalsIgnoreCase(s) || "DISTINCT".equalsIgnoreCase(s) ? 2001 : ("CF_SQL_DOUBLE".equalsIgnoreCase(s) || "DOUBLE".equalsIgnoreCase(s) ? 8 : ("CF_SQL_MONEY4".equalsIgnoreCase(s) || "MONEY4".equalsIgnoreCase(s) ? 8 : ("CF_SQL_FLOAT".equalsIgnoreCase(s) || "FLOAT".equalsIgnoreCase(s) ? 6 : ("CF_SQL_MONEY".equalsIgnoreCase(s) || "MONEY".equalsIgnoreCase(s) ? 8 : ("CF_SQL_INTEGER".equalsIgnoreCase(s) || "INTEGER".equalsIgnoreCase(s) ? 4 : ("CF_SQL_IDSTAMP".equalsIgnoreCase(s) || "IDSTAMP".equalsIgnoreCase(s) ? 1 : ("CF_SQL_LONGVARBINARY".equalsIgnoreCase(s) || "LONGVARBINARY".equalsIgnoreCase(s) ? -4 : ("CF_SQL_LONGVARCHAR".equalsIgnoreCase(s) || "LONGVARCHAR".equalsIgnoreCase(s) ? -1 : ("CF_SQL_NULL".equalsIgnoreCase(s) || CommonUtil.checkNullKey(s) ? 0 : ("CF_SQL_NUMERIC".equalsIgnoreCase(s) || "NUMERIC".equalsIgnoreCase(s) ? 2 : ("CF_SQL_OTHER".equalsIgnoreCase(s) || "OTHER".equalsIgnoreCase(s) ? 1111 : ("CF_SQL_REAL".equalsIgnoreCase(s) || "REAL".equalsIgnoreCase(s) ? 7 : ("CF_SQL_REFCURSOR".equalsIgnoreCase(s) || "REFCURSOR".equalsIgnoreCase(s) ? 2006 : ("CF_SQL_SMALLINT".equalsIgnoreCase(s) || "SMALLINT".equalsIgnoreCase(s) ? 5 : ("CF_SQL_STRUCT".equalsIgnoreCase(s) || "STRUCT".equalsIgnoreCase(s) ? 2002 : ("CF_SQL_TIME".equalsIgnoreCase(s) || "TIME".equalsIgnoreCase(s) ? 92 : ("CF_SQL_TIMESTAMP".equalsIgnoreCase(s) || "TIMESTAMP".equalsIgnoreCase(s) ? 93 : ("CF_SQL_TINYINT".equalsIgnoreCase(s) || "TINYINT".equalsIgnoreCase(s) ? -6 : ("CF_SQL_VARBINARY".equalsIgnoreCase(s) || "VARBINARY".equalsIgnoreCase(s) ? -3 : ("CF_SQL_VARCHAR".equalsIgnoreCase(s) || "VARCHAR".equalsIgnoreCase(s) ? 12 : ("CF_SQL_NCHAR".equalsIgnoreCase(s) || "NCHAR".equalsIgnoreCase(s) ? -15 : ("CF_SQL_NVARCHAR".equalsIgnoreCase(s) || "NVARCHAR".equalsIgnoreCase(s) ? -9 : ("CF_SQL_LONGNVARCHAR".equalsIgnoreCase(s) || "LONGNVARCHAR".equalsIgnoreCase(s) ? -16 : ("CF_SQL_NCLOB".equalsIgnoreCase(s) || "NCLOB".equalsIgnoreCase(s) ? 2011 : ("CF_SQL_SQLXML".equalsIgnoreCase(s) || "SQLXML".equalsIgnoreCase(s) ? 2009 : ("CF_SQL_ROWID".equalsIgnoreCase(s) || "ROWID".equalsIgnoreCase(s) ? -8 : 0)))))))))))))))))))))))))))))))))));
        return sqltype;
    }

    public static class QueryExecuteException
    extends ApplicationException {
        public QueryExecuteException(Exception e) {
            super(e);
            if (e instanceof JspException) {
                this.rootCause = ((JspException)((Object)e)).getCause();
            }
        }
    }

    public static class QueryMetadataException
    extends ApplicationException {
        public String Message;

        public QueryMetadataException(String attribute, String value) {
            this.Message = value + " for attribute " + attribute;
        }
    }

    public static class QueryParseException
    extends ApplicationException {
        public String message;

        public QueryParseException(String message) {
            this.message = message;
        }
    }

    public static class InvalidDataException
    extends DatabaseException {
        private static final long serialVersionUID = 1L;
        public Object value;
        public int maxlength;

        InvalidDataException(Object value, int maxlength) {
            this.value = value;
            this.maxlength = maxlength;
        }
    }
}

