/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.runtime.Struct;
import coldfusion.server.DebuggingService;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.InOutParameter;
import coldfusion.sql.InParameter;
import coldfusion.sql.OutParameter;
import coldfusion.sql.Parameter;
import coldfusion.sql.ParameterList;
import coldfusion.sql.QueryDetails;
import coldfusion.sql.QueryTable;
import coldfusion.sql.Table;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.sql.ProcParamTag;
import coldfusion.tagext.sql.ProcResultTag;
import coldfusion.tagext.sql.QueryTag;
import coldfusion.tagext.sql.TransactionTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.security.Permission;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class StoredProcTag
extends QueryTag {
    private static final long serialVersionUID = 1L;
    private static final GenericTagPermission tp = new GenericTagPermission("cfstoredproc");
    protected ArrayList params;
    protected ArrayList maxlenList;
    protected StringBuffer sql;
    protected String procedure;
    protected boolean returncode = false;
    protected TreeMap rs_name_list;
    protected TreeMap rs_name_maxrows;
    private Exception loc = null;
    private long startTime = 0L;
    private QueryTable param_table;

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setProcedure(String name) {
        this.procedure = name;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setReturncode(boolean b) {
        this.returncode = b;
    }

    public boolean isReturncode() {
        return this.returncode;
    }

    @Override
    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void release() {
        this.procedure = null;
        if (this.params != null) {
            this.params.clear();
        }
        if (this.maxlenList != null) {
            this.maxlenList.clear();
        }
        if (this.rs_name_list != null) {
            this.rs_name_list.clear();
        }
        if (this.rs_name_maxrows != null) {
            this.rs_name_maxrows.clear();
        }
        this.returncode = false;
        this.param_table = null;
        this.startTime = 0L;
        super.release();
    }

    @Override
    public int doStartTag() throws JspException {
        this.onTagStart();
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        if (this.debugState > 0 || this.debugState == -1 && debuggingService != null && debuggingService.check(4)) {
            this.loc = new Exception();
        }
        this.startTime = System.currentTimeMillis();
        int val = super.doStartTag();
        this.validate();
        try {
            this.impl.validate();
        }
        catch (SQLException ex) {
            throw new QueryTag.DataSourceException(ex, this.datasource.toString());
        }
        this.sql = new StringBuffer();
        if (this.returncode) {
            this.sql.append("{? = call ");
            ProcParamTag ppt = new ProcParamTag();
            ppt.setAncestor((Tag)this);
            ppt.setCfsqltype("CF_SQL_INTEGER");
            ppt.setType("OUT");
            ppt.setVariable("CFSTOREDPROC.StatusCode");
            ppt.doStartTag();
            ppt.doEndTag();
        } else {
            this.sql.append("{call ");
        }
        this.sql.append(this.procedure);
        return val == 2 ? 1 : val;
    }

    @Override
    public int doAfterBody() throws JspException {
        return 0;
    }

    private void resetDataSource() {
        this.dimpl.setDatasrc(this.datasource);
        try {
            this.dimpl.validate();
        }
        catch (SQLException sqlException) {
            throw new QueryTag.DatabaseQueryException((Throwable)sqlException, this.impl, this.datasource);
        }
        this.impl.setConnectionSource(this.dimpl);
        this.impl.setCloseConnection(false);
    }

    @Override
    public int doEndTag() throws JspException {
        int start;
        boolean inTxn = TransactionTag.getCurrent() != null;
        this.validateDbVarName();
        if (this.datasource instanceof String && !this.impl.getDSN().equalsIgnoreCase(this.datasource.toString())) {
            this.resetDataSource();
        }
        ParameterList plist = this.impl.getParamList();
        ArrayList allParamList = null;
        if (plist != null) {
            allParamList = plist.getAllParameters();
        }
        int len = allParamList != null ? allParamList.size() : 0;
        for (int i = start = this.returncode ? 1 : 0; i < len; ++i) {
            String dbVarName;
            Parameter param = (Parameter)allParamList.get(i);
            if (i == start) {
                this.sql.append("(");
            }
            if ((dbVarName = param.getDbVarName()) != null) {
                this.sql.append(dbVarName);
                this.sql.append(" = ?");
            } else {
                this.sql.append("?");
            }
            if (i != len - 1) {
                this.sql.append(", ");
                continue;
            }
            this.sql.append(")");
        }
        this.sql.append("}");
        this.debug(this.sql.toString());
        this.impl.setSql(this.sql.toString());
        this.impl.setResultSetList(this.getResultSetList());
        this.impl.setResultSetRows(this.getResultSetRows());
        try {
            if (this.cacheMaxIdleTime != null || this.cachedafter != null || this.cachedwithin != null || this.cacheRegion != null) {
                this.setupCachedQuery(inTxn);
            } else {
                Table resTable = this.executeQuery(inTxn);
                this.setQueryResult(resTable);
            }
        }
        catch (RequestTimedOutException ex) {
            throw this.setRequestTimedOutTagName(ex);
        }
        catch (SQLException ex) {
            throw new QueryTag.DatabaseQueryException((Throwable)ex, this.impl, this.datasource);
        }
        finally {
            this.release();
        }
        this.onTagEnd();
        return 6;
    }

    @Override
    protected QueryDetails getQueryDetails() {
        String dsname = this.datasource == null ? null : this.datasource.toString();
        ParameterList tempList = this.impl.getParamList();
        if (tempList != null) {
            tempList = (ParameterList)tempList.clone();
        }
        return new QueryDetails(dsname, this.impl.getSql().trim(), this.impl.getUsername(), tempList, this.cacheId);
    }

    @Override
    protected Table executeQuery(boolean inTxn) throws SQLException {
        if (this.procedure != null) {
            this.impl.setStoredProcName(this.procedure);
        }
        Table resTable = this.impl.executeCall(inTxn, this.clientInfo);
        return resTable;
    }

    @Override
    protected RequestTimedOutException setRequestTimedOutTagName(RequestTimedOutException ex) {
        ex.tname = "CFSTOREDPROC";
        return ex;
    }

    protected void registerParameter(ProcParamTag tag) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        if (this.maxlenList == null) {
            this.maxlenList = new ArrayList();
        }
        this.params.add(tag.getId());
        this.maxlenList.add(new Integer(tag.getMaxlength()));
    }

    protected void registerResultSet(ProcResultTag tag) {
        String rs_name = tag.getId();
        int rs_pos = tag.getResultset();
        int rs_row = tag.getMaxrows();
        if (this.rs_name_list == null) {
            this.rs_name_list = new TreeMap();
        }
        this.rs_name_list.put(new Integer(rs_pos - 1), rs_name);
        if (this.rs_name_maxrows == null) {
            this.rs_name_maxrows = new TreeMap();
        }
        this.rs_name_maxrows.put(new Integer(rs_pos - 1), new Integer(rs_row));
    }

    protected int[] getResultSetList() {
        if (this.rs_name_list == null) {
            return null;
        }
        int[] intar = new int[this.rs_name_list.size()];
        int k = 0;
        Iterator i = this.rs_name_list.keySet().iterator();
        while (i.hasNext()) {
            intar[k] = (Integer)i.next();
            ++k;
        }
        return intar;
    }

    protected int[] getResultSetRows() {
        if (this.rs_name_maxrows == null) {
            return null;
        }
        int[] intar = new int[this.rs_name_maxrows.size()];
        int k = 0;
        Iterator i = this.rs_name_maxrows.values().iterator();
        while (i.hasNext()) {
            intar[k] = (Integer)i.next();
            ++k;
        }
        return intar;
    }

    protected void validateDbVarName() throws JspException {
        ParameterList plist = this.impl.getParamList();
        ArrayList allParamList = null;
        if (plist != null) {
            allParamList = plist.getAllParameters();
        }
        int len = allParamList != null ? allParamList.size() : 0;
        int start = this.returncode ? 1 : 0;
        boolean dbvarnamefound = false;
        boolean dbvarnamenotfound = false;
        for (int i = start; i < len; ++i) {
            Parameter param = (Parameter)allParamList.get(i);
            String dbVarName = param.getDbVarName();
            if (dbVarName != null) {
                dbvarnamefound = true;
                if (!dbvarnamefound || !dbvarnamenotfound) continue;
                throw new FoundDbVarNameException(dbVarName);
            }
            dbvarnamenotfound = true;
            if (!dbvarnamefound || !dbvarnamenotfound) continue;
            throw new MissingDbVarNameException();
        }
    }

    @Override
    protected void setQueryResult(Table table) {
        Object obj;
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        Iterator i = null;
        if (this.rs_name_list != null) {
            i = this.rs_name_list.keySet().iterator();
        }
        while (i != null && i.hasNext() && table != null) {
            this.pageContext.setAttribute((String)this.rs_name_list.get(i.next()), (Object)table);
            table = table.nextTable();
        }
        ParameterList pl = this.impl.getParamList();
        ArrayList list = pl == null ? null : pl.getAllParameters();
        int size = list == null ? 0 : list.size();
        Object statuscode = "0";
        for (int j = 0; j < size; ++j) {
            String name = (String)this.params.get(j);
            int maxlength = (Integer)this.maxlenList.get(j);
            obj = list.get(j);
            if (!(obj instanceof OutParameter) || name == null) continue;
            Object outValue = ((OutParameter)obj).getOutput();
            if (outValue == null) {
                this.pageContext.setAttribute(name, (Object)"");
                continue;
            }
            if (outValue instanceof String) {
                String outString = (String)outValue;
                int out_len = outString.length();
                if (maxlength != -1 && out_len > maxlength) {
                    this.pageContext.setAttribute(name, (Object)outString.substring(0, maxlength).trim());
                    continue;
                }
                this.pageContext.setAttribute(name, outValue);
                continue;
            }
            if (this.returncode && this.result != null && "CFSTOREDPROC.StatusCode".equals(name)) {
                statuscode = outValue;
                continue;
            }
            this.pageContext.setAttribute(name, outValue);
        }
        long endTime = System.currentTimeMillis();
        this.debug("START TIME:" + this.startTime);
        Long elapsedTime = null;
        elapsedTime = this.cached ? new Long(0L) : new Long(endTime - this.startTime);
        if (this.result != null) {
            Struct s = new Struct();
            s.put("EXECUTIONTIME", (Object)elapsedTime);
            s.put("CACHED", (Object)String.valueOf(this.cached));
            if (this.returncode) {
                s.put("STATUSCODE", statuscode);
            }
            this.fetchClientInfo(s);
            this.pageContext.setAttribute(this.result, (Object)s);
        } else {
            this.pageContext.setAttribute("CFSTOREDPROC.ExecutionTime", (Object)elapsedTime);
        }
        if (debuggingService != null && debuggingService.getDebugger() != null && (this.debugState > 0 || this.debugState == -1 && debuggingService.check(4))) {
            Vector<Struct> vParameters = new Vector<Struct>();
            for (int k = 0; k < size; ++k) {
                Struct stParam = new Struct();
                Object valObj = "NULL";
                obj = list.get(k);
                if (obj instanceof InParameter) {
                    stParam.put("type", (Object)"IN");
                    if (((InParameter)obj).getObject() != null) {
                        valObj = ((InParameter)obj).getObject();
                    }
                    stParam.put("value", valObj);
                    stParam.put("sqlType", (Object)((InParameter)obj).getSqltypeName());
                } else {
                    obj = list.get(k);
                    if (obj instanceof OutParameter && (this.name = (String)this.params.get(k)) != null && !"CFSTOREDPROC.StatusCode".equals(this.name)) {
                        if (obj instanceof InOutParameter) {
                            stParam.put("type", (Object)"INOUT");
                            if (((InOutParameter)obj).getObject() != null) {
                                valObj = ((InOutParameter)obj).getObject();
                            }
                            stParam.put("value", valObj);
                        } else {
                            stParam.put("type", (Object)"OUT");
                        }
                        stParam.put("variable", (Object)this.name);
                        stParam.put("type", (Object)"OUT");
                        stParam.put("sqlType", (Object)((OutParameter)obj).getSqltypeName());
                    }
                }
                if (stParam.isEmpty()) continue;
                vParameters.add(stParam);
            }
            Vector<Struct> vResults = new Vector<Struct>();
            if (this.rs_name_list != null) {
                i = this.rs_name_list.keySet().iterator();
            }
            while (i != null && i.hasNext()) {
                int foo = (Integer)i.next();
                Struct stResult = new Struct();
                stResult.put("name", this.rs_name_list.get(new Integer(foo)));
                stResult.put("resultSet", (Object)new Integer(foo + 1));
                vResults.add(stResult);
            }
            debuggingService.getDebugger().storedproc(this.procedure, this.datasource, vResults, vParameters, this.loc, this.startTime, endTime);
        }
    }

    private void setupStoredProc() {
        block12: {
            String dbProcedureCatalog = "";
            String dbProcedureSchema = "";
            String dbProcedureName = "";
            ResultSet rs = null;
            try {
                Connection con = this.impl.getConnection();
                DatabaseMetaData dbmd = con.getMetaData();
                rs = dbmd.getProcedures(null, null, this.procedure);
                boolean found = false;
                while (rs.next()) {
                    dbProcedureCatalog = rs.getString(1);
                    dbProcedureSchema = rs.getString(2);
                    dbProcedureName = rs.getString(3);
                    if (!dbProcedureName.toLowerCase().startsWith(this.procedure.toLowerCase())) continue;
                    found = true;
                    break;
                }
                rs.close();
                if (found) {
                    rs = dbmd.getProcedureColumns(dbProcedureCatalog, dbProcedureSchema, dbProcedureName, "%");
                    this.param_table = new QueryTable(rs);
                    this.pageContext.setAttribute("CFSTOREDPROC.ProcedureColumns", (Object)this.param_table);
                    break block12;
                }
                this.pageContext.setAttribute("CFSTOREDPROC.ProcedureColumns", (Object)"");
                throw new StoredProcNotFoundException(this.procedure);
            }
            catch (SQLException ex) {
                throw new QueryTag.DatabaseQueryException((Throwable)ex, this.impl, this.datasource);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    public static class FoundDbVarNameException
    extends NeoException {
        public String dbVarName;

        FoundDbVarNameException(String dbVarName) {
            this.dbVarName = dbVarName;
        }
    }

    public static class MissingDbVarNameException
    extends NeoException {
        MissingDbVarNameException() {
        }
    }

    public static class StoredProcNotFoundException
    extends DatabaseException {
        public String name;

        StoredProcNotFoundException(String name) {
            this.name = name;
        }
    }
}

