/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.sql;

import coldfusion.monitor.beans.TagAttribute;
import coldfusion.runtime.DatabaseException;
import coldfusion.runtime.EventListeners;
import coldfusion.runtime.TransactionEventListener;
import coldfusion.server.j2ee.sql.JRunConnectionHandle;
import coldfusion.sql.DataSrcImpl;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.sql.DataSourceException;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.security.Permission;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TransactionTag
extends GenericTag
implements TryCatchFinally {
    private static final GenericTagPermission tp = new GenericTagPermission("cftransaction");
    private String action = "BEGIN";
    private String isolation;
    private String savepoint;
    private boolean nested = true;
    private boolean outerMost = false;
    private FastHashtable namedSavepoints = new FastHashtable();
    private ArrayList savepointOrder = new ArrayList();
    private int default_isolation;
    private DataSrcImpl dimpl;
    private Object datasource;
    private String username;
    private String password;
    private boolean success = true;
    private TransactionTag txn;
    private long startTime = 0L;
    boolean calledEndTag = false;
    boolean commitPending = true;
    private static ThreadLocal currentTT = new ThreadLocal();

    @Override
    protected Permission getPermission() {
        return tp;
    }

    public void setCommitPending(boolean st) {
        this.commitPending = st;
    }

    public boolean getCommitPending() {
        return this.commitPending;
    }

    public void setIsolation(String s) {
        this.isolation = s;
    }

    public String getIsolation() {
        return this.isolation;
    }

    public void setAction(String a) {
        this.action = a;
    }

    public String getAction() {
        return this.action;
    }

    public void setNested(boolean s) {
        this.nested = s;
    }

    public boolean getNested() {
        return this.nested;
    }

    public void setSavepoint(String s) {
        this.savepoint = "".equals(s) ? null : s;
    }

    public String getSavepoint() {
        return this.savepoint;
    }

    private boolean isOuterMost() {
        return this.outerMost;
    }

    private void setOuterMost(boolean b) {
        this.outerMost = b;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public String getDatasource() {
        return this.datasource != null ? this.datasource.toString() : null;
    }

    @Override
    public void release() {
        this.success = true;
        this.action = "BEGIN";
        this.calledEndTag = false;
        this.isolation = null;
        this.savepoint = null;
        this.commitPending = true;
        this.dimpl = null;
        this.datasource = null;
        this.username = null;
        this.password = null;
        this.startTime = 0L;
        this.nested = true;
        this.outerMost = false;
        this.namedSavepoints = new FastHashtable();
        this.savepointOrder = new ArrayList();
        super.release();
    }

    protected void validate() throws JspException {
        if (!("BEGIN".equalsIgnoreCase(this.action) || "COMMIT".equalsIgnoreCase(this.action) || "ROLLBACK".equalsIgnoreCase(this.action) || "SETSAVEPOINT".equalsIgnoreCase(this.action))) {
            throw new InvalidTagAttributeException("CFTRANSACTION", "action", this.action);
        }
        if (!(this.isolation == null || "Read_Uncommitted".equalsIgnoreCase(this.isolation) || "Read_Committed".equalsIgnoreCase(this.isolation) || "Repeatable_Read".equalsIgnoreCase(this.isolation) || "Serializable".equalsIgnoreCase(this.isolation))) {
            throw new InvalidTagAttributeException("CFTRANSACTION", "isolation", this.isolation);
        }
    }

    public static TransactionTag getCurrent() {
        return (TransactionTag)((Object)currentTT.get());
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        this.startTime = System.currentTimeMillis();
        this.validate();
        this.txn = TransactionTag.getCurrent();
        if (this.txn == null) {
            this.fireBeforeTransactionBegin();
            currentTT.set(this);
            this.setNested(false);
            this.setOuterMost(true);
            this.fireAfterTransactionBegin();
            return 1;
        }
        if ("COMMIT".equalsIgnoreCase(this.action)) {
            this.txn.commit();
            return 1;
        }
        if ("ROLLBACK".equalsIgnoreCase(this.action)) {
            this.txn.rollback(this.savepoint);
            return 1;
        }
        if ("SETSAVEPOINT".equalsIgnoreCase(this.action)) {
            this.fireOnSetSavePoint(this.savepoint);
            this.txn.doSetSavepoint(this.savepoint);
            return 1;
        }
        if ("BEGIN".equalsIgnoreCase(this.action)) {
            this.handleNestedTxTag();
            return 1;
        }
        throw new InvalidTagAttributeException("CFTRANSACTION", "action", this.action);
    }

    private void handleNestedTxTag() {
        if (!this.getNested()) {
            throw new NestedTransactionException();
        }
        String il = TransactionTag.getCurrent().getIsolation();
        if (this.getIsolation() != null) {
            String string = il = il == null ? this.getCFIsolationLevel(TransactionTag.getCurrent().default_isolation) : il;
            if (!this.getIsolation().equalsIgnoreCase(il)) {
                throw new InvalidIsolationException(il, this.getIsolation());
            }
            this.setIsolation(TransactionTag.getCurrent().getIsolation());
        }
    }

    protected Tag findTransactionTag() {
        TransactionTag tag = this;
        while ((tag = tag.getParent()) != null && !(tag instanceof TransactionTag)) {
        }
        return tag;
    }

    public int doEndTag() throws JspException {
        this.calledEndTag = true;
        if (this.txn == null && this.getCommitPending()) {
            this.commit();
        }
        List<TagAttribute> tagAttributes = this.captureAttributes(Arrays.asList("success", "savepoint", "savepointorder", "isolation", "outermost"), Arrays.asList(this.success, this.convertUpperCase(this.savepoint), this.savepointOrder, this.isolation, this.outerMost));
        this.onTagEnd(tagAttributes);
        return 6;
    }

    public void verifyDataSrc(Object ds, String u, String p) throws SQLException {
        if (this.datasource == null) {
            try {
                this.dimpl = DataSrcImpl.getSqlProxy();
                this.dimpl.setDatasrc(ds);
                this.dimpl.validate();
            }
            catch (SQLException ex) {
                this.dimpl = null;
                throw new DataSourceException(ds);
            }
            try {
                Connection con = this.dimpl.getConnection(u, p);
                if (con.getAutoCommit()) {
                    con.setAutoCommit(false);
                }
                this.default_isolation = con.getTransactionIsolation();
                if ("Read_Uncommitted".equalsIgnoreCase(this.isolation)) {
                    con.setTransactionIsolation(1);
                } else if ("Read_Committed".equalsIgnoreCase(this.isolation)) {
                    con.setTransactionIsolation(2);
                } else if ("Repeatable_Read".equalsIgnoreCase(this.isolation)) {
                    con.setTransactionIsolation(4);
                } else if ("Serializable".equalsIgnoreCase(this.isolation)) {
                    con.setTransactionIsolation(8);
                }
            }
            catch (SQLException ex) {
                this.dimpl = null;
                throw ex;
            }
            if (ds != null) {
                this.datasource = ds.toString();
            }
            this.username = u;
            this.password = p;
        } else if (!this.equals(this.datasource, ds)) {
            throw new SQLException(RB.getString((Object)this, "TransactionTag.2"));
        }
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.equals(obj2)) {
            return true;
        }
        if (obj1 instanceof String) {
            return ((String)obj1).equalsIgnoreCase(obj2.toString());
        }
        return false;
    }

    protected void commit() {
        try {
            this.fireOnCommit();
            if (this.dimpl != null) {
                Connection con = this.dimpl.getConnection(this.username, this.password);
                con.commit();
            }
        }
        catch (Throwable ex) {
            this.success = false;
            try {
                this.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new TransactionCommitException(ex);
        }
        finally {
            if (this.getCommitPending()) {
                this.setCommitPending(false);
            }
            this.revertToOldDBSettings();
            this.datasource = null;
            this.username = null;
            this.password = null;
            this.namedSavepoints.clear();
            this.savepointOrder.clear();
        }
    }

    protected void rollback() {
        if (!this.isOuterMost()) {
            TransactionTag.getCurrent().rollback();
        } else {
            this.rollback(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rollback(String savename) {
        boolean keepalive = false;
        Connection con = null;
        try {
            this.fireOnRollback(savename);
            this.verifyDataSrc(this.datasource, this.username, this.password);
            if (this.dimpl == null) return;
            con = this.dimpl.getConnection(this.username, this.password);
            if (savename != null) {
                Connection phyCon;
                String className;
                this.verifySavepointSupport();
                savename = savename.toLowerCase();
                int index = this.savepointOrder.indexOf(savename);
                if (index <= -1) throw new InvalidSavepointException();
                for (int lastindex = this.savepointOrder.size() - 1; lastindex > index; --lastindex) {
                    this.namedSavepoints.remove(this.savepointOrder.get(lastindex));
                    this.savepointOrder.remove(lastindex);
                }
                con.rollback((Savepoint)this.namedSavepoints.get(savename));
                if (con instanceof JRunConnectionHandle && (className = (phyCon = ((JRunConnectionHandle)con).getPhysicalConnection()).getClass().getName()).startsWith("macromedia")) {
                    this.doSetSavepoint(savename);
                }
                keepalive = true;
                return;
            } else {
                con.rollback();
            }
            return;
        }
        catch (Throwable ex) {
            this.success = false;
            if (con != null) {
                try {
                    con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (ex instanceof SavepointsNotSupportedException) {
                throw (SavepointsNotSupportedException)ex;
            }
            if (ex instanceof DataSourceException) {
                if (savename == null) return;
                throw new InvalidSavepointException();
            }
            if (!(ex instanceof InvalidSavepointException)) throw new TransactionException(ex);
            throw (InvalidSavepointException)ex;
        }
        finally {
            if (!keepalive) {
                if (this.getCommitPending()) {
                    this.setCommitPending(false);
                }
                this.revertToOldDBSettings();
                this.datasource = null;
                this.username = null;
                this.password = null;
                this.namedSavepoints.clear();
                this.savepointOrder.clear();
            }
        }
    }

    protected void doSetSavepoint(String savename) {
        try {
            this.verifyDataSrc(this.datasource, this.username, this.password);
            this.verifySavepointSupport();
            Connection con = this.dimpl.getConnection(this.username, this.password);
            if (savename != null) {
                int index = this.savepointOrder.indexOf(savename = savename.toLowerCase());
                if (index > -1) {
                    this.savepointOrder.remove(index);
                }
                this.savepointOrder.add(savename);
                this.namedSavepoints.put(savename, (Object)con.setSavepoint(savename));
            }
        }
        catch (Throwable ex) {
            this.success = false;
            try {
                this.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ex instanceof SavepointsNotSupportedException) {
                throw (SavepointsNotSupportedException)ex;
            }
            if (ex instanceof DataSourceException) {
                throw new InvalidSavepointActionException();
            }
            throw new TransactionException(ex);
        }
    }

    private void verifySavepointSupport() throws SavepointsNotSupportedException {
        try {
            if (!this.dimpl.getConnection(this.username, this.password).getMetaData().supportsSavepoints()) {
                throw new SavepointsNotSupportedException();
            }
        }
        catch (SQLException ex) {
            throw new SavepointsNotSupportedException(ex);
        }
    }

    @Override
    public void doCatch(Throwable t) throws Throwable {
        try {
            this.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw t;
    }

    public void revertToOldDBSettings() {
        if (this.dimpl == null) {
            return;
        }
        Connection con = null;
        try {
            con = this.dimpl.getConnection(this.username, this.password);
        }
        catch (Throwable t) {
            this.warning(t.getMessage());
            return;
        }
        try {
            if (!con.getAutoCommit()) {
                con.setAutoCommit(true);
            }
        }
        catch (Throwable ex) {
            this.warning(ex.getMessage());
        }
        try {
            con.setTransactionIsolation(this.default_isolation);
        }
        catch (Throwable ex) {
            this.warning(ex.getMessage());
        }
    }

    @Override
    public void doFinally() {
        if (this.findTransactionTag() == null && this.isOuterMost()) {
            this.fireAfterTransactionCompletion();
            currentTT.set(null);
            if (!this.calledEndTag) {
                this.revertToOldDBSettings();
            }
        }
        this.datasource = null;
        this.username = null;
        this.password = null;
        this.namedSavepoints.clear();
        this.savepointOrder.clear();
    }

    private void fireBeforeTransactionBegin() {
        List<TransactionEventListener> listeners = EventListeners.getTransactionEventListeners();
        if (listeners == null) {
            return;
        }
        for (TransactionEventListener listener : listeners) {
            listener.beforeTransactionBegin();
        }
    }

    private void fireAfterTransactionBegin() {
        List<TransactionEventListener> listeners = EventListeners.getTransactionEventListeners();
        if (listeners == null) {
            return;
        }
        for (TransactionEventListener listener : listeners) {
            listener.afterTransactionBegin();
        }
    }

    private void fireOnCommit() {
        List<TransactionEventListener> listeners = EventListeners.getTransactionEventListeners();
        if (listeners == null) {
            return;
        }
        for (TransactionEventListener listener : listeners) {
            listener.onCommit();
        }
    }

    private void fireOnSetSavePoint(String name) {
        List<TransactionEventListener> listeners = EventListeners.getTransactionEventListeners();
        if (listeners == null) {
            return;
        }
        for (TransactionEventListener listener : listeners) {
            listener.onSetSavePoint(name);
        }
    }

    private void fireOnRollback(String savePointName) {
        List<TransactionEventListener> listeners = EventListeners.getTransactionEventListeners();
        if (listeners == null) {
            return;
        }
        for (TransactionEventListener listener : listeners) {
            if (savePointName == null) {
                listener.onRollback();
                continue;
            }
            listener.onRollback(savePointName);
        }
    }

    private void fireAfterTransactionCompletion() {
        List<TransactionEventListener> listeners = EventListeners.getTransactionEventListeners();
        if (listeners == null) {
            return;
        }
        for (TransactionEventListener listener : listeners) {
            listener.afterTransactionCompletion();
        }
    }

    private String getCFIsolationLevel(int il) {
        switch (il) {
            case 1: {
                return "Read_Uncommitted";
            }
            case 2: {
                return "Read_Committed";
            }
            case 4: {
                return "Repeatable_Read";
            }
            case 8: {
                return "Serializable";
            }
        }
        return "Unspecified";
    }

    public static void callScriptMethod(String actionName, String saveName) {
        TransactionTag curentTx = TransactionTag.getCurrent();
        if (curentTx == null) {
            throw new NoCurrentTransactionException();
        }
        String oldAction = curentTx.getAction();
        curentTx.setAction(actionName);
        if ("COMMIT".equals(actionName)) {
            curentTx.txCommit();
        } else if ("ROLLBACK".equals(actionName)) {
            curentTx.txRollback(saveName);
        } else if ("SETSAVEPOINT".equals(actionName)) {
            curentTx.txSetSavepoint(saveName);
        }
        curentTx.setAction(oldAction);
    }

    public void txCommit() {
        this.commit();
    }

    public void txRollback(String saveName) {
        this.rollback(saveName);
    }

    public void txSetSavepoint(String saveName) {
        this.fireOnSetSavePoint(this.savepoint);
        this.doSetSavepoint(saveName);
    }

    public class NestedTransactionException
    extends DatabaseException {
        NestedTransactionException() {
        }
    }

    public class InvalidIsolationException
    extends DatabaseException {
        public String pil;
        public String cil;

        InvalidIsolationException(String pil, String cil) {
            this.pil = pil;
            this.cil = cil;
        }
    }

    public class TransactionCommitException
    extends DatabaseException {
        TransactionCommitException() {
        }

        TransactionCommitException(Throwable ex) {
            super(ex);
        }
    }

    public class InvalidSavepointException
    extends DatabaseException {
        InvalidSavepointException() {
        }
    }

    public class SavepointsNotSupportedException
    extends DatabaseException {
        SavepointsNotSupportedException() {
        }

        SavepointsNotSupportedException(SQLException ex) {
            super(ex);
        }
    }

    public class TransactionException
    extends DatabaseException {
        TransactionException() {
        }

        TransactionException(Throwable ex) {
            super(ex);
        }
    }

    public class InvalidSavepointActionException
    extends DatabaseException {
        InvalidSavepointActionException() {
        }
    }

    public static class NoCurrentTransactionException
    extends DatabaseException {
    }

    public class TransactionBeginException
    extends DatabaseException {
        TransactionBeginException() {
        }

        TransactionBeginException(Throwable ex) {
            super(ex);
        }
    }
}

