/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.tagext.validation.CFIntegerValidator;
import coldfusion.tagext.validation.CFMLTagValidator;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFStringValidator;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.tagext.validation.MetaInfoLookupException;
import coldfusion.tagext.validation.SimpleTagAttrConfig;
import coldfusion.tagext.validation.SwitchedTagAttrConfig;
import coldfusion.tagext.validation.TagAttrConfiguration;
import coldfusion.tagext.validation.TagContextRule;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class CFMLTagLibrary {
    private static Map<String, CFMLTagValidator> _taglib;

    public static CFMLTagValidator lookup(String tagName) {
        return _taglib.get(tagName.toLowerCase());
    }

    public static boolean isCFTag(String tagName) {
        if (tagName == null) {
            return false;
        }
        return _taglib.get(tagName.toLowerCase()) != null;
    }

    private static Map<String, CFMLTagValidator> importLibrary(InputStream uri) throws Exception {
        HashMap<String, CFMLTagValidator> validators = new HashMap<String, CFMLTagValidator>();
        CFMLTagLibrary.load(uri, validators);
        return validators;
    }

    private static void load(InputStream uri, Map validators) throws Exception {
        SAXBuilder jdomBuilder = new SAXBuilder();
        Document jdom = jdomBuilder.build(uri);
        Element root = jdom.getRootElement();
        CFMLTagLibrary.load(root.getChild("Map"), validators);
    }

    private static void load(Element map, Map validators) {
        List children = map.getChildren();
        for (Element mapItem : children) {
            String key = mapItem.getChildText("Key").toLowerCase().intern();
            Element value = mapItem.getChild("Value");
            CFMLTagValidator validator = CFMLTagLibrary.loadCFMLTagValidator(value);
            validators.put(key, validator);
        }
    }

    private static CFMLTagValidator loadCFMLTagValidator(Element value) {
        List children = value.getChildren();
        CFMLTagValidator validator = new CFMLTagValidator();
        TagAttrConfiguration tagConfig = null;
        for (Element valueItem : children) {
            String name = valueItem.getName();
            if (name.equals("Name")) {
                validator.setTagName(valueItem.getText().toLowerCase().intern());
                continue;
            }
            if (name.equals("ContextRules")) {
                validator.setContextRule(CFMLTagLibrary.loadContextRule(valueItem));
                continue;
            }
            if (name.equals("NoAttributeValidator")) {
                validator.setAttrConfiguration(null);
                continue;
            }
            if (name.equals("SimpleAttributeValidator")) {
                tagConfig = CFMLTagLibrary.loadSimpleTagAttrConfig(valueItem);
                validator.setAttrConfiguration(tagConfig);
                continue;
            }
            if (name.equals("SwitchedAttributeValidator")) {
                tagConfig = CFMLTagLibrary.loadSwitchedTagAttrConfig(valueItem);
                validator.setAttrConfiguration(tagConfig);
                continue;
            }
            if (name.equals("Attributes")) {
                validator.setAttrConstraints(CFMLTagLibrary.loadAttributeProperties(valueItem, tagConfig));
                continue;
            }
            if (name.equals("CanHaveOtherAttributes")) {
                validator.setAllowOtherAttributes(valueItem.getText().equalsIgnoreCase("Yes"));
                continue;
            }
            if (!name.equals("CanAllowSuperfluousAttributes")) continue;
            validator.setAllowSuperfluousAttrs(valueItem.getText().equalsIgnoreCase("Yes"));
        }
        return validator;
    }

    private static TagContextRule loadContextRule(Element contextRule) {
        TagContextRule rule = new TagContextRule();
        List children = contextRule.getChildren();
        for (Element ruleItem : children) {
            String ruleName = ruleItem.getName();
            if (ruleName.equals("Ancestor")) {
                rule.setAncestor(ruleItem.getText().toLowerCase().intern());
                continue;
            }
            if (ruleName.equals("Parent")) {
                rule.setParent(ruleItem.getText().toLowerCase().intern());
                continue;
            }
            if (ruleName.equals("Content")) {
                rule.setAllowContent(ruleItem.getText().intern());
                continue;
            }
            if (ruleName.equals("ContentType")) {
                rule.setContentType(ruleItem.getText().intern());
                continue;
            }
            if (ruleName.equals("MustHaveEndTag")) {
                rule.setMustHaveEndTag(ruleItem.getText().equalsIgnoreCase("YES"));
                continue;
            }
            if (!ruleName.equals("CannotHaveEndTag")) continue;
            rule.setNoEndTag(ruleItem.getText().equalsIgnoreCase("YES"));
        }
        return rule;
    }

    private static Collection loadCollection(Element collection) {
        List children = collection.getChild("Collection").getChildren();
        TreeSet<String> set = new TreeSet<String>();
        for (Element item : children) {
            set.add(item.getText().toLowerCase().intern());
        }
        return set;
    }

    private static SimpleTagAttrConfig loadSimpleTagAttrConfig(Element simple) {
        SimpleTagAttrConfig attrValidator = new SimpleTagAttrConfig();
        List children = simple.getChildren();
        for (Element item : children) {
            String name = item.getName();
            if (!item.getText().equals("") && name.equals("AllowedAttributes")) {
                attrValidator.setAllowedAttributes(CFMLTagLibrary.tokenize(item.getText()));
                continue;
            }
            if (!item.getText().equals("") && name.equals("RequiredAttributes")) {
                attrValidator.setRequiredAttributes(CFMLTagLibrary.tokenize(item.getText()));
                continue;
            }
            if (!item.getText().equals("") && name.equals("IrrelevantAttributes")) {
                attrValidator.setIrrelevantAttributes(CFMLTagLibrary.tokenize(item.getText()));
                continue;
            }
            if (!name.equals("PossibleConfigurations")) continue;
            attrValidator.setAttrConfig(CFMLTagLibrary.loadCollection(item));
        }
        return attrValidator;
    }

    private static Collection tokenize(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        TreeSet<String> tokens = new TreeSet<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken().toLowerCase().intern());
        }
        return tokens;
    }

    private static TagAttrConfiguration loadSwitchedTagAttrConfig(Element switched) {
        SwitchedTagAttrConfig attrValidator = new SwitchedTagAttrConfig();
        attrValidator.setSwitchAttribute(switched.getChildText("SwitchAttribute"));
        List children = switched.getChild("Rules").getChild("Collection").getChildren();
        for (Element item : children) {
            String switchingValue = item.getChildText("SwitchingValue");
            SimpleTagAttrConfig simple = CFMLTagLibrary.loadSimpleTagAttrConfig(item.getChild("SimpleAttributeValidator"));
            attrValidator.setSimpleTagAttrConfig(switchingValue, simple);
        }
        return attrValidator;
    }

    private static Map loadAttributeProperties(Element attrs, TagAttrConfiguration tagConfig) {
        HashMap<String, CFTypeValidator> table = new HashMap<String, CFTypeValidator>();
        List children = attrs.getChild("Collection").getChildren();
        for (Element item : children) {
            String attrName = item.getChildText("Name").toLowerCase().intern();
            CFTypeValidator typeValidator = CFMLTagLibrary.loadAttrTypeConstraint(item);
            if (typeValidator != null && tagConfig != null && tagConfig.isSwitched() && attrName.equalsIgnoreCase(tagConfig.getSwitchAttribute()) && item.getChildText("DefaultValue") != null) {
                typeValidator = (CFTypeValidator)typeValidator.clone();
                typeValidator.setDefault(item.getChildText("DefaultValue").intern());
            }
            table.put(attrName, typeValidator);
        }
        return table;
    }

    private static CFTypeValidator loadAttrTypeConstraint(Element attrType) {
        Element type = (Element)attrType.getChild("Type").getChildren().get(0);
        String typeName = type.getName();
        CFTypeValidator typeValidator = CFTypeValidatorFactory.getValidator(typeName);
        Double boundValue = new Double(-1.0);
        for (Element element : type.getChildren()) {
            String elementName = element.getName();
            try {
                boundValue = new Double(element.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == typeValidator && typeName.equals("Integer")) {
                typeValidator = CFTypeValidatorFactory.getExtendedValidator(typeName);
            }
            if (elementName.equals("OpenLowerBound")) {
                typeValidator = (CFTypeValidator)typeValidator.clone();
                if (typeName.equals("Numeric")) {
                    ((CFNumberValidator)typeValidator).setLowerBound(true, boundValue);
                    continue;
                }
                if (!typeName.equals("Integer")) continue;
                ((CFIntegerValidator)typeValidator).setLowerBound(true, boundValue);
                continue;
            }
            if (elementName.equals("ClosedUpperBound")) {
                typeValidator = (CFTypeValidator)typeValidator.clone();
                if (typeName.equals("Numeric")) {
                    ((CFNumberValidator)typeValidator).setUpperBound(false, boundValue);
                    continue;
                }
                if (!typeName.equals("Integer")) continue;
                ((CFIntegerValidator)typeValidator).setUpperBound(false, boundValue);
                continue;
            }
            if (elementName.equals("ClosedLowerBound")) {
                typeValidator = (CFTypeValidator)typeValidator.clone();
                if (typeName.equals("Numeric")) {
                    ((CFNumberValidator)typeValidator).setLowerBound(false, boundValue);
                    continue;
                }
                if (!typeName.equals("Integer")) continue;
                ((CFIntegerValidator)typeValidator).setLowerBound(false, boundValue);
                continue;
            }
            if (elementName.equals("LowerBound") && typeName.equals("String")) {
                typeValidator = (CFTypeValidator)typeValidator.clone();
                ((CFStringValidator)typeValidator).setLowerBound(boundValue.intValue());
                continue;
            }
            if (!elementName.equals("UpperBound") || !typeName.equals("String")) continue;
            typeValidator = (CFTypeValidator)typeValidator.clone();
            ((CFStringValidator)typeValidator).setUpperBound(boundValue.intValue());
        }
        return typeValidator;
    }

    private static InputStream getCFMLData() {
        InputStream in = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CFMLTagLibrary.class.getResourceAsStream("cfml_data.xml");
            }
        });
        return in;
    }

    static {
        try {
            _taglib = CFMLTagLibrary.importLibrary(CFMLTagLibrary.getCFMLData());
        }
        catch (Throwable ex) {
            throw new MetaInfoLookupException(ex);
        }
    }
}

