/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.filter.StringValidator;
import coldfusion.runtime.CFMethod;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.CFVariableLexer;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.QueryFunction;
import coldfusion.runtime.StringFunc;
import coldfusion.runtime.StructUtils;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.validation.CFIntegerValidator;
import coldfusion.tagext.validation.CFNumberLegacyValidator;
import coldfusion.tagext.validation.CFNumberValidator;
import coldfusion.tagext.validation.CFStringValidator;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import coldfusion.tagext.validation.CFTypedArrayValidator;
import coldfusion.tagext.validation.InvalidSimpleTypeException;
import coldfusion.util.DateUtils;
import coldfusion.xml.XmlProcessException;
import com.ibm.icu.text.IDNA;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

public class CFTypeValidatorFactory {
    CFTypeValidator validator;
    private static Map<String, CFTypeValidator> validators;
    private static Map<String, CFTypeValidator> extendedValidators;
    static IDNA idn;
    public static final CFTypeValidator ARRAY_VALIDATOR;
    public static final CFTypeValidator BINARY_VALIDATOR;
    public static final CFTypeValidator BOOL_VALIDATOR;
    public static final CFTypeValidator CREDITCARD_VALIDATOR;
    public static final CFTypeValidator DATE_VALIDATOR;
    public static final CFTypeValidator DATETIMEOBJECT_VALIDATOR;
    public static final CFTypeValidator DATETIMEOBJECTVALIDATOR;
    public static final CFTypeValidator EMAIL_VALIDATOR;
    public static final CFTypeValidator EURODATE_VALIDATOR;
    public static final CFTypeValidator FLOAT_VALIDATOR;
    public static final CFTypeValidator FUNCTION_VALIDATOR;
    public static final CFTypeValidator GUID_VALIDATOR;
    public static final CFTypeValidator INTEGER_VALIDATOR;
    public static final CFTypeValidator NUMBER_VALIDATOR;
    public static final CFTypeValidator QUERY_VALIDATOR;
    public static final CFTypeValidator REGEX_VALIDATOR;
    public static final CFTypeValidator SSN_VALIDATOR;
    public static final CFTypeValidator STRING_VALIDATOR;
    public static final CFTypeValidator STRUCT_VALIDATOR;
    public static final CFTypeValidator TELEPHONE_VALIDATOR;
    public static final CFTypeValidator TIME_VALIDATOR;
    public static final CFTypeValidator URL_VALIDATOR;
    public static final CFTypeValidator URL_IPV6_VALIDATOR;
    public static final CFTypeValidator USDATE_VALIDATOR;
    public static final CFTypeValidator UUID_VALIDATOR;
    public static final CFTypeValidator VARIABLE_VALIDATOR;
    public static final CFTypeValidator XML_VALIDATOR;
    public static final CFTypeValidator ZIPCODE_VALIDATOR;
    public static final CFTypeValidator TYPED_ARRAY_VALIDATOR;

    public static String getValidatorString(String typeName) {
        String str = typeName.toLowerCase();
        if (str.endsWith("[]")) {
            return "TYPED_ARRAY_VALIDATOR";
        }
        if (str.equals("any")) {
            return null;
        }
        if (str.equals("array")) {
            return "ARRAY_VALIDATOR";
        }
        if (str.equals("binary")) {
            return "BINARY_VALIDATOR";
        }
        if (str.equals("boolean")) {
            return "BOOL_VALIDATOR";
        }
        if (str.equals("creditcard")) {
            return "CREDITCARD_VALIDATOR";
        }
        if (str.equals("date")) {
            return "DATE_VALIDATOR";
        }
        if (str.equals("email")) {
            return "EMAIL_VALIDATOR";
        }
        if (str.equals("eurodate")) {
            return "EURODATE_VALIDATOR";
        }
        if (str.equals("float")) {
            return "FLOAT_VALIDATOR";
        }
        if (str.equals("function")) {
            return "FUNCTION_VALIDATOR";
        }
        if (str.equals("guid")) {
            return "GUID_VALIDATOR";
        }
        if (str.equals("integer")) {
            return "INTEGER_VALIDATOR";
        }
        if (str.equals("numeric")) {
            return "NUMBER_VALIDATOR";
        }
        if (str.equals("query")) {
            return "QUERY_VALIDATOR";
        }
        if (str.equals("regex")) {
            return "REGEX_VALIDATOR";
        }
        if (str.equals("social_security_number")) {
            return "SSN_VALIDATOR";
        }
        if (str.equals("ssn")) {
            return "SSN_VALIDATOR";
        }
        if (str.equals("string")) {
            return "STRING_VALIDATOR";
        }
        if (str.equals("struct")) {
            return "STRUCT_VALIDATOR";
        }
        if (str.equals("telephone")) {
            return "TELEPHONE_VALIDATOR";
        }
        if (str.equals("url")) {
            return "URL_VALIDATOR";
        }
        if (str.equals("usdate")) {
            return "USDATE_VALIDATOR";
        }
        if (str.equals("uuid")) {
            return "UUID_VALIDATOR";
        }
        if (str.equals("variablename")) {
            return "VARIABLE_VALIDATOR";
        }
        if (str.equals("xml")) {
            return "XML_VALIDATOR";
        }
        if (str.equals("zipcode")) {
            return "ZIPCODE_VALIDATOR";
        }
        return null;
    }

    public static CFTypeValidator getValidator(String typeName) {
        if (typeName == null) {
            return null;
        }
        return validators.get(typeName.toLowerCase());
    }

    public static CFTypeValidator getValidator(String typeName, Object value) {
        if (value instanceof FastArray && typeName.endsWith("[]")) {
            return validators.get("typed_array");
        }
        return CFTypeValidatorFactory.getValidator(typeName);
    }

    public static CFTypeValidator getExtendedValidator(String typeName) {
        if (typeName == null) {
            return null;
        }
        return extendedValidators.get(typeName.toLowerCase());
    }

    public static CFTypeValidator getRegExValidator(String pattern) {
        return new CFRegExValidator(pattern);
    }

    static {
        idn = IDNA.getUTS46Instance((int)124);
        ARRAY_VALIDATOR = new CFArrayValidator();
        BINARY_VALIDATOR = new CFBinaryValidator();
        BOOL_VALIDATOR = new CFBooleanValidator();
        CREDITCARD_VALIDATOR = new CFCreditCardValidator();
        DATE_VALIDATOR = new CFDateValidator();
        DATETIMEOBJECT_VALIDATOR = new CFDateTimeObjectValidator();
        DATETIMEOBJECTVALIDATOR = new CFDateTimeObjectValidator();
        EMAIL_VALIDATOR = new CFEmailValidator();
        EURODATE_VALIDATOR = new CFEuroDateValidator();
        FLOAT_VALIDATOR = new CFNumberValidator(true);
        FUNCTION_VALIDATOR = new CFUDFValidator();
        GUID_VALIDATOR = new CFGUIDValidator();
        INTEGER_VALIDATOR = new CFIntegerValidator(true);
        NUMBER_VALIDATOR = new CFNumberValidator();
        QUERY_VALIDATOR = new CFQueryValidator();
        REGEX_VALIDATOR = new CFRegExValidator();
        SSN_VALIDATOR = new CFSSNValidator();
        STRING_VALIDATOR = new CFStringValidator();
        STRUCT_VALIDATOR = new CFStructValidator();
        TELEPHONE_VALIDATOR = new CFTelephoneValidator();
        TIME_VALIDATOR = new CFTimeValidator();
        URL_VALIDATOR = new CFURLValidator();
        URL_IPV6_VALIDATOR = new CFURLIPV6Validator();
        USDATE_VALIDATOR = new CFUSDateValidator();
        UUID_VALIDATOR = new CFUUIDValidator();
        VARIABLE_VALIDATOR = new CFVariableValidator();
        XML_VALIDATOR = new CFXMLValidator();
        ZIPCODE_VALIDATOR = new CFZipCodeValidator();
        TYPED_ARRAY_VALIDATOR = new CFTypedArrayValidator();
        validators = new HashMap<String, CFTypeValidator>();
        validators.put("any", new CFAnyValidator());
        validators.put("array", new CFArrayValidator());
        validators.put("binary", new CFBinaryValidator());
        validators.put("boolean", new CFBooleanValidator());
        validators.put("date", new CFDateValidator());
        validators.put("datetime_object", new CFDateTimeObjectValidator());
        validators.put("datetimeobject", new CFDateTimeObjectValidator());
        validators.put("guid", new CFGUIDValidator());
        validators.put("numeric", new CFNumberValidator());
        validators.put("numeric_legacy", new CFNumberLegacyValidator());
        validators.put("query", new CFQueryValidator());
        validators.put("string", new CFStringValidator());
        validators.put("struct", new CFStructValidator());
        validators.put("uuid", new CFUUIDValidator());
        validators.put("variablename", new CFVariableValidator());
        validators.put("xml", new CFXMLValidator());
        validators.put("function", new CFUDFValidator());
        validators.put("function", new CFUDFValidator());
        validators.put("typed_array", new CFTypedArrayValidator());
        extendedValidators = new HashMap<String, CFTypeValidator>();
        extendedValidators.putAll(validators);
        extendedValidators.put("integer", new CFIntegerValidator(true));
        extendedValidators.put("float", new CFNumberValidator(true));
        extendedValidators.put("usdate", new CFUSDateValidator());
        extendedValidators.put("eurodate", new CFEuroDateValidator());
        extendedValidators.put("time", new CFTimeValidator());
        extendedValidators.put("creditcard", new CFCreditCardValidator());
        extendedValidators.put("email", new CFEmailValidator());
        extendedValidators.put("ssn", new CFSSNValidator());
        extendedValidators.put("social_security_number", new CFSSNValidator());
        extendedValidators.put("telephone", new CFTelephoneValidator());
        extendedValidators.put("zipcode", new CFZipCodeValidator());
        extendedValidators.put("url", new CFURLValidator());
        extendedValidators.put("urlipv6", new CFURLIPV6Validator());
        extendedValidators.put("regex", new CFRegExValidator());
    }

    static class CFRegExValidator
    extends CFTypeValidator {
        protected final Pattern pattern;
        protected java.util.regex.Pattern javaPattern;
        protected final String regexPattern;

        public CFRegExValidator() {
            this.pattern = null;
            this.javaPattern = null;
            this.regexPattern = null;
        }

        public CFRegExValidator(String regexPattern) {
            this.regexPattern = regexPattern;
            this.pattern = StringFunc.getPattern(regexPattern, true);
        }

        protected boolean isValid(Object value) {
            String thisvalue = Cast._String(value);
            boolean useJavaAsRegexEngine = ServiceFactory.getRuntimeService().isJavaRegexEngineEnabled();
            if (!useJavaAsRegexEngine) {
                PatternMatcherInput input = new PatternMatcherInput(thisvalue);
                Perl5Matcher matcher = new Perl5Matcher();
                return matcher.matches(input, this.pattern);
            }
            if (this.javaPattern == null) {
                this.javaPattern = StringFunc.getPatternJava(this.regexPattern, true);
            }
            Matcher matcher = this.javaPattern.matcher(thisvalue);
            return matcher.find();
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (this.pattern == null) {
                throw new IllegalStateException();
            }
            if (!this.isValid(value)) {
                throw new InvalidRegExTypeException();
            }
        }

        @Override
        public void validate(Object value, String regex) throws CFTypeValidationException {
            boolean match;
            String thisvalue = Cast._String(value).trim();
            boolean bl = match = !StringFunc.REMatch(thisvalue, regex);
            if (match) {
                throw new InvalidRegExTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFArrayValidator
    extends CFTypeValidator {
        CFArrayValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!CFPage.IsArray(value)) {
                throw new InvalidComplexTypeException("array");
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Array(value);
        }
    }

    static final class CFBinaryValidator
    extends CFTypeValidator {
        CFBinaryValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!(value instanceof byte[])) {
                throw new InvalidComplexTypeException("binary");
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Binary(value);
        }
    }

    static final class CFBooleanValidator
    extends CFTypeValidator {
        CFBooleanValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            try {
                Cast._boolean(value);
            }
            catch (Exception ex) {
                throw new InvalidSimpleTypeException("boolean");
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._boolean(value) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static final class CFCreditCardValidator
    extends CFTypeValidator {
        CFCreditCardValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            String ccNumber = Cast._String(value).trim();
            if ((ccNumber = StringFunc.REReplace(ccNumber, "([^0-9])", "", "ALL", false)).length() < 13 || ccNumber.length() > 19) {
                throw new InvalidCreditCardTypeException();
            }
            if (!StringValidator.validateFloat(ccNumber)) {
                throw new InvalidCreditCardTypeException();
            }
            boolean doubledigit = ccNumber.length() % 2 != 1;
            int checkdigit = 0;
            char[] ccChars = ccNumber.toCharArray();
            int ccCharsLen = ccChars.length;
            for (int i = 0; i < ccCharsLen; ++i) {
                int tempdigit = Integer.parseInt("" + ccChars[i]);
                if (doubledigit) {
                    checkdigit += (tempdigit *= 2) % 10;
                    if ((double)(tempdigit / 10) >= 1.0) {
                        ++checkdigit;
                    }
                    doubledigit = false;
                    continue;
                }
                checkdigit += tempdigit;
                doubledigit = true;
            }
            if (checkdigit % 10 != 0) {
                throw new InvalidCreditCardTypeException();
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFDateValidator
    extends CFTypeValidator {
        CFDateValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            block3: {
                if (value instanceof Date) {
                    return;
                }
                try {
                    DateUtils.parseDateTime((String)value);
                }
                catch (RuntimeException ex) {
                    if (CFPage.IsNumericDate(value)) break block3;
                    throw new InvalidSimpleTypeException("date");
                }
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Date(value);
        }
    }

    static final class CFDateTimeObjectValidator
    extends CFTypeValidator {
        CFDateTimeObjectValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (value instanceof Date) {
                return;
            }
            throw new InvalidSimpleTypeException("datetimeobject");
        }

        @Override
        public void validate(Object value, String regexPattern) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return null;
        }
    }

    static final class CFEmailValidator
    extends CFRegExValidator {
        private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
        private static final String specialsNoDot = "()<>,;:\\\"[]@";

        public CFEmailValidator() {
            super("^[a-zA-Z_0-9-'\\+~]+(\\.[a-zA-Z_0-9-'\\+~]+)*@([a-zA-Z_0-9-]+\\.)+[a-zA-Z]{2,7}$");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            String email = value.toString();
            if (email.indexOf(",") != -1) {
                throw new InvalidEmailTypeException();
            }
            try {
                StringBuilder builder = new StringBuilder();
                IDNA.Info info = new IDNA.Info();
                if (!StringFunc.isAllASCII(email)) {
                    email = idn.nameToASCII((CharSequence)email, builder, info).toString();
                }
            }
            catch (Exception builder) {
                // empty catch block
            }
            try {
                new InternetAddress(email).validate();
            }
            catch (AddressException e) {
                throw new InvalidEmailTypeException();
            }
            catch (NullPointerException e) {
                throw new InvalidEmailTypeException();
            }
            if (!this.isValid(value)) {
                throw new InvalidEmailTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFEuroDateValidator
    extends CFTypeValidator {
        CFEuroDateValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            CFLocale cfLocaleUK;
            String dt = Cast._String(value).trim();
            if (!StringValidator.validateDate(dt, cfLocaleUK = CFLocaleMgr.getMgr().getCFLocale("English (UK)"))) {
                if (dt.startsWith("{") && dt.endsWith("}")) {
                    try {
                        CFPage.ParseDateTime((String)value);
                    }
                    catch (RuntimeException ex) {
                        throw new InvalidEuroDateTypeException();
                    }
                } else {
                    throw new InvalidEuroDateTypeException();
                }
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Date(value);
        }
    }

    static final class CFUDFValidator
    extends CFTypeValidator {
        CFUDFValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!(value instanceof UDFMethod) && !(value instanceof CFMethod)) {
                throw new InvalidUDFTypeException();
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            this.validate(value);
            return value;
        }
    }

    static final class CFGUIDValidator
    extends CFRegExValidator {
        public CFGUIDValidator() {
            super("[A-Fa-f0-9]{8,8}-[A-Fa-f0-9]{4,4}-[A-Fa-f0-9]{4,4}-[A-Fa-f0-9]{4,4}-[A-Fa-f0-9]{12,12}");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!this.isValid(value)) {
                throw new InvalidGUIDTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFQueryValidator
    extends CFTypeValidator {
        CFQueryValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!QueryFunction.IsQuery(value)) {
                throw new InvalidComplexTypeException("query");
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return value;
        }
    }

    static final class CFSSNValidator
    extends CFRegExValidator {
        public CFSSNValidator() {
            super("^[0-9]{3}(-| )[0-9]{2}(-| )[0-9]{4}$");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!this.isValid(value)) {
                throw new InvalidSSNTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFStructValidator
    extends CFTypeValidator {
        CFStructValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!StructUtils.IsStruct(value)) {
                throw new InvalidComplexTypeException("struct");
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Map(value);
        }
    }

    static final class CFTelephoneValidator
    extends CFRegExValidator {
        public CFTelephoneValidator() {
            super("^(((1))?[ ,\\-,\\.]?([\\(]?([1-9][0-9]{2})[\\)]?))?[ ,\\-,\\.]?([^0-1]){1}([0-9]){2}[ ,\\-,\\.]?([0-9]){4}(( )((x){0,1}([0-9]){1,5}){0,1})?$");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!this.isValid(value)) {
                throw new InvalidTelephoneTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFTimeValidator
    extends CFTypeValidator {
        CFTimeValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (value instanceof Date) {
                return;
            }
            try {
                DateUtils.parseDateTime((String)value);
            }
            catch (RuntimeException ex) {
                throw new InvalidTimeTypeException();
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Date(value);
        }
    }

    static final class CFURLValidator
    extends CFTypeValidator {
        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (value == null) {
                throw new InvalidURLTypeException();
            }
            String url = value.toString().toLowerCase().trim();
            if (url.startsWith("mailto:")) {
                ServiceFactory.getMailSpoolService().validateEmail(url.substring(8));
            } else if (!this.isValid(url)) {
                throw new InvalidURLTypeException();
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        protected boolean isValid(String urlString) {
            if (urlString.indexOf(58) == -1) {
                return false;
            }
            if (urlString.startsWith("http://") || urlString.startsWith("https://") || urlString.startsWith("ftp://") || urlString.startsWith("file://") || urlString.startsWith("news:")) {
                try {
                    StringBuilder builder = new StringBuilder();
                    URI uri = null;
                    if (urlString.startsWith("news:") || StringFunc.isAllASCII(urlString)) {
                        uri = new URI(urlString);
                    } else {
                        IDNA.Info info = new IDNA.Info();
                        URL url = new URL(urlString);
                        String idnaHost = idn.nameToASCII((CharSequence)url.getHost(), builder, info).toString();
                        uri = new URI(url.getProtocol(), url.getUserInfo(), idnaHost, url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                    }
                    String proto = uri.getScheme();
                    if (proto == null) {
                        return false;
                    }
                    return !proto.equals("http") && !proto.equals("https") && !proto.equals("ftp") && !proto.equals("file") || uri.getHost() != null;
                }
                catch (Throwable t) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value).toLowerCase();
        }
    }

    static final class CFURLIPV6Validator
    extends CFRegExValidator {
        public CFURLIPV6Validator() {
            super("^((http|https|ftp|file)\\:\\/\\/([a-zA-Z0-0]*:[a-zA-Z0-0]*(@))?(\\[)?[a-zA-Z0-9-\\.:]+(\\])?(\\.[a-zA-Z]{2,3})?(:[a-zA-Z0-9]*)?\\/?(([a-zA-Z0-9-\\._\\?\\,\\'\\/\\+&amp;:@\\$#\\=~\\*\\!\\(\\)])|(%[a-f0-9]{2}))*)|((news)\\:[a-zA-Z0-9\\.]*)$");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (value == null) {
                throw new InvalidURLTypeException();
            }
            String url = value.toString().toLowerCase().trim();
            if (url.startsWith("mailto:")) {
                ServiceFactory.getMailSpoolService().validateEmail(url.substring(8));
            } else if (!this.isValid(url)) {
                throw new InvalidURLTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value).toLowerCase();
        }
    }

    static final class CFUSDateValidator
    extends CFTypeValidator {
        CFUSDateValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            String str = value.toString().trim();
            int isplit = str.indexOf(47);
            String splitchr = "/";
            if (isplit == -1) {
                isplit = str.indexOf(46);
                splitchr = ".";
            }
            if (isplit == -1) {
                isplit = str.indexOf(45);
                splitchr = "-";
            }
            if (isplit == -1 || isplit == str.length()) {
                throw new InvalidSimpleTypeException("date");
            }
            String sMonth = str.substring(0, isplit);
            if (sMonth.length() == 0) {
                throw new InvalidSimpleTypeException("date");
            }
            if ((isplit = str.indexOf(splitchr, isplit + 1)) == -1 || isplit + 1 == str.length()) {
                throw new InvalidSimpleTypeException("date");
            }
            String sDay = str.substring(sMonth.length() + 1, isplit);
            if (sDay.length() == 0) {
                throw new InvalidSimpleTypeException("date");
            }
            String sYear = str.substring(isplit + 1);
            CFIntegerValidator intValidator = new CFIntegerValidator();
            CFIntegerValidator rangeValidator = new CFIntegerValidator();
            try {
                intValidator.validate(sMonth);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidSimpleTypeException("date");
            }
            try {
                rangeValidator.setLowerBound(false, 1.0);
                rangeValidator.setUpperBound(false, 12.0);
                rangeValidator.validate(sMonth);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidSimpleTypeException("date");
            }
            try {
                intValidator.validate(sYear);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidSimpleTypeException("date");
            }
            if (sYear.length() != 1 && sYear.length() != 2 && sYear.length() != 4) {
                throw new InvalidSimpleTypeException("date");
            }
            try {
                rangeValidator.setLowerBound(false, 0.0);
                rangeValidator.setUpperBound(false, 9999.0);
                rangeValidator.validate(sYear);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidSimpleTypeException("date");
            }
            try {
                intValidator.validate(sDay);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidSimpleTypeException("date");
            }
            try {
                int maxDay = 31;
                int checkMonth = Integer.parseInt(sMonth);
                int checkYear = Integer.parseInt(sYear);
                if (checkMonth == 4 || checkMonth == 6 || checkMonth == 9 || checkMonth == 11) {
                    maxDay = 30;
                } else if (checkMonth == 2) {
                    maxDay = checkYear % 4 > 0 ? 28 : (checkYear % 100 == 0 && checkYear % 400 > 0 ? 28 : 29);
                }
                rangeValidator.setLowerBound(false, 1.0);
                rangeValidator.setUpperBound(false, maxDay);
                rangeValidator.validate(sDay);
            }
            catch (CFTypeValidationException ex) {
                throw new InvalidSimpleTypeException("date");
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Date(value);
        }
    }

    static final class CFUUIDValidator
    extends CFRegExValidator {
        public CFUUIDValidator() {
            super("[A-Fa-f0-9]{8,8}-[A-Fa-f0-9]{4,4}-[A-Fa-f0-9]{4,4}-[A-Fa-f0-9]{16,16}");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!this.isValid(value)) {
                throw new InvalidUUIDTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFVariableValidator
    extends CFRegExValidator {
        public CFVariableValidator() {
            super("[a-z,A-Z,_,$](\\w)*");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            String id = Cast._String(value);
            if (id.lastIndexOf(".") == id.length() - 1) {
                throw new InvalidVariableNameException(id);
            }
            if (id.length() > 0 && (Character.isDigit(id.charAt(0)) || id.charAt(0) == '.')) {
                throw new InvalidVariableNameException(id);
            }
            if (!CFVariableLexer.isValidVariableName(id)) {
                throw new InvalidVariableNameException(id);
            }
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFXMLValidator
    extends CFTypeValidator {
        CFXMLValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            try {
                Cast._Xml(value);
            }
            catch (Cast.XmlCastException e) {
                throw new InvalidComplexTypeException("xml");
            }
            catch (XmlProcessException e) {
                throw new InvalidComplexTypeException("xml");
            }
        }

        @Override
        public void validate(Object value, String regexp) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._Xml(value);
        }
    }

    static final class CFZipCodeValidator
    extends CFRegExValidator {
        public CFZipCodeValidator() {
            super("^([0-9]){5,5}$|(([0-9]){5,5}(-| ){1}([0-9]){4,4}$)");
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
            if (!this.isValid(value)) {
                throw new InvalidZipCodeTypeException();
            }
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return Cast._String(value);
        }
    }

    static final class CFAnyValidator
    extends CFTypeValidator {
        CFAnyValidator() {
        }

        @Override
        public void validate(Object value) throws CFTypeValidationException {
        }

        @Override
        public void validate(Object value, String s) throws CFTypeValidationException {
        }

        @Override
        public Object cast(Object value) throws ExpressionException {
            return value;
        }
    }

    public static class InvalidUDFTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidClosureTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidTimeTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidEuroDateTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidRegExRequiredTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidRegExTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidURLTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidZipCodeTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidTelephoneTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidSSNTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidEmailTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidCreditCardTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidGUIDTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidUUIDTypeException
    extends CFTypeValidationException {
    }

    public static class InvalidVariableNameException
    extends CFTypeValidationException {
        public String value;

        public InvalidVariableNameException(String value) {
            this.value = value;
        }
    }

    public static class InvalidComplexTypeException
    extends CFTypeValidationException {
        public String type;

        public InvalidComplexTypeException(String type) {
            this.type = type;
        }
    }
}

