/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TypedArrayInvalidMethodArgumentException;
import coldfusion.runtime.TypedArrayInvalidMethodReturnTypeException;
import coldfusion.runtime.TypedArrayMethodArgumentException;
import coldfusion.runtime.TypedArrayMethodReturnException;
import coldfusion.runtime.TypedArrayValidationResult;
import coldfusion.runtime.TypedCollectionUtil;
import coldfusion.runtime.util.TemplateProxyUtil;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidator;
import java.util.List;

public final class CFTypedArrayValidator
extends CFTypeValidator {
    @Override
    public void validate(Object value) throws CFTypeValidationException {
        throw new UnsupportedOperationException("validate(Object value) is not supported in CFTypedArrayValidator.");
    }

    @Override
    public void validate(Object value, String regexPattern) throws CFTypeValidationException {
        throw new UnsupportedOperationException("validate(Object value, String regexPattern) is not supported in CFTypedArrayValidator.");
    }

    public void validateWithType(Object value, String arrayType, String udfName, String paramName, boolean isArgument) throws CFTypeValidationException {
        String dataType = null;
        if (value != null && value instanceof FastArray) {
            String[] types;
            List valueList = (List)value;
            if (arrayType != null && !arrayType.isEmpty() && (types = arrayType.split("\\[\\]")) != null && types.length > 0) {
                dataType = types[0].trim();
                TypedArrayValidationResult res = TypedCollectionUtil.isValidDataType(dataType);
                if (!res.isValid()) {
                    throw new TypedCollectionUtil.TypedArrayInvalidDataTypeException(dataType);
                }
                String passedArrayType = TypedCollectionUtil.getDataType((FastArray)valueList);
                if (valueList.size() == 0) {
                    String typeToValidate;
                    String string = typeToValidate = res.getCfcFullyQualiFiedName() == null ? dataType : res.getCfcFullyQualiFiedName();
                    if (dataType != null && passedArrayType != null && !typeToValidate.equalsIgnoreCase(passedArrayType)) {
                        if (isArgument) {
                            throw new TypedArrayMethodArgumentException(value, udfName, arrayType);
                        }
                        throw new TypedArrayMethodReturnException(value, udfName, arrayType);
                    }
                } else {
                    for (Object obj : valueList) {
                        Object castedObj = TypedCollectionUtil.castToDeclaredType(obj, dataType);
                        if (castedObj != null) continue;
                        Object objVal = obj;
                        if (obj instanceof TemplateProxy) {
                            objVal = TemplateProxyUtil.getLastWord(TemplateProxyUtil.getComponentFullName(((TemplateProxy)obj).page));
                        }
                        if (isArgument) {
                            throw new TypedArrayInvalidMethodArgumentException(objVal, udfName, dataType, paramName, arrayType);
                        }
                        throw new TypedArrayInvalidMethodReturnTypeException(objVal, udfName, dataType, arrayType);
                    }
                }
            }
        } else {
            if (isArgument) {
                throw new TypedArrayMethodArgumentException(value, udfName, arrayType);
            }
            throw new TypedArrayMethodReturnException(value, udfName, arrayType);
        }
    }

    @Override
    public Object cast(Object value) throws ExpressionException {
        return Cast._Array(value);
    }
}

