/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.compiler.validation.TagValidationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.StringFunc;
import coldfusion.util.RB;
import java.util.Collection;
import org.apache.oro.text.regex.Perl5Pattern;

public class IllegalAttrConfigException
extends TagValidationException {
    public String config;
    public String posConfig;

    public IllegalAttrConfigException(String tagName, String config, Collection possibleConfig) {
        this.tagName = this.processTagName(tagName);
        this.config = config;
        this.posConfig = possibleConfig != null && !possibleConfig.isEmpty() ? this.createConfigCombination(possibleConfig) : "";
    }

    private String createConfigCombination(Collection possibleConfig) {
        StringBuffer buf = new StringBuffer();
        if (!possibleConfig.isEmpty()) {
            buf.append(RB.getString(this, "header"));
        }
        String optionalRegexp = "(\\([^)]*\\)\\?)|(\\.\\?)";
        String optionalMarkup = "([\\.()?]+)";
        String recomma = ",,+";
        for (Perl5Pattern pat : possibleConfig) {
            String configure = pat.getPattern();
            String strRequired = StringFunc.REReplace(configure, optionalRegexp, "", "ALL", true);
            String strPossible = StringFunc.REReplace(configure, optionalMarkup, "", "ALL", true);
            if ((strPossible = StringFunc.REReplace(strPossible, recomma, ",", "ALL", true)).startsWith(",")) {
                strPossible = strPossible.substring(1);
            }
            if (strPossible.endsWith(",")) {
                strPossible = strPossible.substring(0, strPossible.length() - 1);
            }
            Array vecRequired = ListFunc.ListToArray(strRequired, ",");
            Array vecPossible = ListFunc.ListToArray(strPossible, ",");
            Array vecOptional = ListFunc.ListToArray(strPossible, ",");
            vecOptional.removeAll(vecRequired);
            String strOptional = ArrayUtil.ArrayToList(vecOptional, ",");
            buf.append("<li>");
            buf.append(RB.getString(this, "required") + (String)(strRequired.length() == 0 ? RB.getString(this, "none") : "'" + strRequired + "'") + ". ");
            buf.append(RB.getString(this, "optional") + (String)(strOptional.length() == 0 ? RB.getString(this, "none") : "'" + strOptional + "'") + ". ");
        }
        return buf.toString();
    }

    public String processTagName(String tagName) {
        Object nameOfTag = tagName;
        if (nameOfTag != null) {
            if (((String)(nameOfTag = ((String)nameOfTag).trim())).equalsIgnoreCase("loop")) {
                nameOfTag = RB.getString(this, "TagAttributeInfo.cfloop") + " " + RB.getString(this, "TagAttributeInfo.method");
            } else if (((String)nameOfTag).equalsIgnoreCase("CFLOOP tag in cfscript")) {
                nameOfTag = RB.getString(this, "TagAttributeInfo.cfloop") + " " + RB.getString(this, "TagAttributeInfo.method");
            }
        }
        return nameOfTag;
    }
}

