/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.tagext.validation.TagAttrConfiguration;
import coldfusion.util.RuntimeWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class SimpleTagAttrConfig
extends TagAttrConfiguration
implements Serializable {
    private Collection _allowed;
    private Collection _required;
    private Collection _config;

    public void setAllowedAttributes(Collection allowed) {
        this._allowed = allowed;
    }

    @Override
    public Collection getAllowedAttrs(String switchValue) {
        return this._allowed;
    }

    public void setRequiredAttributes(Collection required) {
        this._required = required;
    }

    @Override
    public Collection getRequiredAttrs(String switchValue) {
        return this._required;
    }

    @Override
    public Collection getConfiguration(String switchValue) {
        return this._config;
    }

    public void setIrrelevantAttributes(Collection irrelevant) {
    }

    public void setAttrConfig(Collection config) {
        if (config != null) {
            this._config = new ArrayList();
            Iterator it = config.iterator();
            Perl5Compiler compiler = new Perl5Compiler();
            while (it.hasNext()) {
                try {
                    this._config.add(compiler.compile(it.next().toString()));
                }
                catch (MalformedPatternException e) {
                    throw new RuntimeWrapper(e);
                }
            }
        }
    }

    @Override
    public boolean isSwitched() {
        return false;
    }

    @Override
    public String getSwitchAttribute() {
        return null;
    }

    @Override
    List checkAllowedAttrs(String switchValue, ArrayList attrs) {
        if (this._allowed == null || this._allowed.contains("insidetext")) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            String temp = i.next().toString().toLowerCase();
            if (this._allowed.contains(temp)) continue;
            list.add(temp);
        }
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    List checkRequiredAttrs(String swichValue, ArrayList attrs) {
        if (this._required == null || this._required.contains("insidetext")) {
            return null;
        }
        if (attrs.isEmpty() && this._required != null && !this._required.isEmpty()) {
            return new ArrayList(this._required);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String temp : this._required) {
            if (attrs.contains(temp)) continue;
            result.add(temp);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    @Override
    String checkConfiguration(String swichValue, ArrayList attrs, boolean allowSuperfluousAttrs) {
        ArrayList stripped;
        if (this._config == null || this._config.isEmpty()) {
            return null;
        }
        Collections.sort(attrs);
        if (allowSuperfluousAttrs) {
            ArrayList superfluous = new ArrayList(attrs);
            stripped = new ArrayList(attrs);
            superfluous.removeAll(this._allowed);
            stripped.removeAll(superfluous);
        } else {
            stripped = attrs;
        }
        Collections.sort(stripped);
        StringBuffer temp = new StringBuffer();
        Iterator i = stripped.iterator();
        while (i.hasNext()) {
            temp.append(i.next().toString());
            temp.append(',');
        }
        if (temp.length() > 0) {
            temp.deleteCharAt(temp.length() - 1);
        }
        String config = temp.toString();
        Perl5Matcher matcher = new Perl5Matcher();
        Iterator i2 = this._config.iterator();
        while (i2.hasNext()) {
            try {
                Pattern pattern = (Pattern)i2.next();
                if (config != null && config.contains(",toolbaronfocus") && config.contains("name,")) {
                    return null;
                }
                if (!matcher.matches(config, pattern)) continue;
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return config;
    }

    @Override
    public Collection getSwitchValues() {
        return null;
    }
}

