/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.validation;

import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.compiler.validation.TagValidationException;
import coldfusion.compiler.validation.ValidationResultCollector;
import coldfusion.tagext.validation.EmptyContentException;
import coldfusion.tagext.validation.MissingAncestorTagException;
import coldfusion.tagext.validation.MissingContentException;
import coldfusion.tagext.validation.MissingEndTagException;
import java.io.Serializable;

public class TagContextRule
implements Serializable {
    private String _ancestor;
    private String _parent;
    private String _content;
    private String _contentType;
    private Boolean _mustHaveEndTag = Boolean.FALSE;
    private Boolean _noEndTag = Boolean.FALSE;

    public void setAncestor(String ancestor) {
        this._ancestor = ancestor;
    }

    public String getAncestor() {
        return this._ancestor;
    }

    public void setParent(String parent) {
        this._parent = parent;
    }

    public String getParent() {
        return this._parent;
    }

    public void setMustHaveEndTag(boolean mustHaveEndTag) {
        this._mustHaveEndTag = mustHaveEndTag ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isMustHaveEndTag() {
        return this._mustHaveEndTag;
    }

    public void setNoEndTag(boolean noEndTag) {
        this._noEndTag = noEndTag ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isNoEndTag() {
        return this._noEndTag;
    }

    public void setAllowContent(String content) {
        this._content = content;
    }

    public String getAllowContent() {
        return this._content;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    public String getContentType() {
        return this._contentType;
    }

    public void validate(TagNode tagNode, ValidationResultCollector collector) {
        if (tagNode instanceof ASTcftag) {
            this.validateASTcftag((ASTcftag)tagNode, collector);
        } else {
            this.validateAncestor(tagNode, collector);
        }
    }

    private void validateASTcftag(ASTcftag tagNode, ValidationResultCollector collector) {
        this.validateAncestor(tagNode, collector);
        if (this.isMustHaveEndTag()) {
            String tagName = tagNode.getCalledName() == null ? tagNode.getTagName() : tagNode.getCalledName();
            TagValidationException error = null;
            int numChild = tagNode.jjtGetNumChildren();
            if (tagNode.isEmpty() && this._content.equalsIgnoreCase("none")) {
                error = new EmptyContentException(tagName);
            } else if (tagNode.isEmpty() && this._content.equalsIgnoreCase("some")) {
                error = new MissingContentException(tagName);
            } else if (!tagNode.isEmpty() && !tagNode.isCalledFromScript() && numChild == 0) {
                if (this._content.equalsIgnoreCase("any")) {
                    error = new MissingEndTagException(tagName);
                } else if (this._content.equalsIgnoreCase("some")) {
                    error = new MissingContentException(tagName);
                } else if (this._content.equalsIgnoreCase("none")) {
                    error = new EmptyContentException(tagName);
                }
            } else if (!tagNode.isEmpty() && numChild > 0 && this._content.equalsIgnoreCase("none")) {
                error = new EmptyContentException(tagName);
            }
            if (error != null) {
                error.setLineNumbers(tagNode);
                collector.collectValidationResult(error);
            }
        }
    }

    private void validateAncestor(TagNode tagNode, ValidationResultCollector collector) {
        CFMLValidationException error = null;
        String tagName = tagNode.getTagName();
        if (this._parent != null) {
            if (!tagNode.hasParent(this._parent)) {
                error = new MissingAncestorTagException(tagName, this._parent);
            }
            if (error != null) {
                error.setLineNumbers(tagNode);
                collector.collectValidationResult(error);
            }
        }
        error = null;
        if (this._ancestor != null) {
            if (!tagNode.hasAncestor(this._ancestor)) {
                error = new MissingAncestorTagException(tagName, this._ancestor);
            }
            if (error != null) {
                error.setLineNumbers(tagNode);
                collector.collectValidationResult(error);
            }
        }
    }
}

