/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.thread;

import coldfusion.util.IteratorEnumeration;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HttpServletRequestWrapper
implements HttpServletRequest {
    private HttpServletRequest request;
    private ServletContext servletContext;
    private Map attributes;
    private String charEncoding;
    private int contentLength;
    private long contentLengthLong;
    private String contentType;
    private Map parameters;
    private String protocol;
    private String serverName;
    private int serverPort;
    private String servletPath;
    private String requestURI;
    private String requestURL;
    private String scheme;
    private boolean isSecure;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath;
    private String queryString;

    public HttpServletRequestWrapper(HttpServletRequest request) {
        this.request = request;
        this.servletContext = request.getServletContext();
        this.charEncoding = request.getCharacterEncoding();
        this.contentLength = request.getContentLength();
        this.contentLengthLong = request.getContentLengthLong();
        this.contentType = request.getContentType();
        this.protocol = request.getProtocol();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.servletPath = request.getServletPath();
        this.requestURI = request.getRequestURI();
        if (request.getRequestURL() != null) {
            this.requestURL = request.getRequestURL().toString();
        }
        this.scheme = request.getScheme();
        this.isSecure = request.isSecure();
        this.method = request.getMethod();
        this.pathInfo = request.getPathInfo();
        this.pathTranslated = request.getPathTranslated();
        this.contextPath = request.getContextPath();
        this.queryString = request.getQueryString();
    }

    public void onRequestEnd() {
        this.populateAttributes();
        this.parameters = this.request.getParameterMap();
        this.request = null;
    }

    private void populateAttributes() {
        this.attributes = new HashMap();
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.attributes.put(name, this.request.getAttribute(name));
        }
    }

    public Object getAttribute(String string) {
        if (this.request != null) {
            return this.request.getAttribute(string);
        }
        return this.attributes.get(string);
    }

    public Enumeration getAttributeNames() {
        if (this.request != null) {
            return this.request.getAttributeNames();
        }
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        if (this.request != null) {
            this.request.setCharacterEncoding(string);
        }
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public long getContentLengthLong() {
        return this.contentLengthLong;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String string) {
        if (this.request != null) {
            return this.request.getParameter(string);
        }
        String[] values = (String[])this.parameters.get(string);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (this.request != null) {
            return this.request.getParameterNames();
        }
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String string) {
        if (this.request != null) {
            return this.request.getParameterValues(string);
        }
        return (String[])this.parameters.get(string);
    }

    public Map getParameterMap() {
        if (this.request != null) {
            return this.request.getParameterMap();
        }
        return new HashMap(this.parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        if (this.request != null) {
            return this.request.getRemoteAddr();
        }
        return null;
    }

    public String getRemoteHost() {
        if (this.request != null) {
            return this.request.getRemoteHost();
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (this.request != null) {
            this.request.setAttribute(string, object);
        } else {
            this.attributes.put(string, object);
        }
    }

    public void removeAttribute(String string) {
        if (this.request != null) {
            this.request.removeAttribute(string);
        } else {
            this.attributes.remove(string);
        }
    }

    public Locale getLocale() {
        if (this.request != null) {
            return this.request.getLocale();
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        if (this.request != null) {
            return this.request.getLocales();
        }
        return new Enumeration(){
            boolean fetched = false;

            @Override
            public boolean hasMoreElements() {
                return !this.fetched;
            }

            public Object nextElement() {
                Locale locale = this.fetched ? null : Locale.getDefault();
                this.fetched = true;
                return locale;
            }
        };
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (this.request != null) {
            return this.request.getRequestDispatcher(string);
        }
        return null;
    }

    public String getRealPath(String string) {
        if (this.servletContext != null) {
            return this.servletContext.getRealPath(string);
        }
        return null;
    }

    public String getAuthType() {
        if (this.request != null) {
            return this.request.getAuthType();
        }
        return null;
    }

    public Cookie[] getCookies() {
        if (this.request != null) {
            return this.request.getCookies();
        }
        return null;
    }

    public long getDateHeader(String string) {
        if (this.request != null) {
            return this.request.getDateHeader(string);
        }
        return -1L;
    }

    public String getHeader(String string) {
        if (this.request != null) {
            return this.request.getHeader(string);
        }
        return null;
    }

    public Enumeration getHeaders(String string) {
        if (this.request != null) {
            return this.request.getHeaders(string);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getHeaderNames() {
        if (this.request != null) {
            return this.request.getHeaderNames();
        }
        return null;
    }

    public int getIntHeader(String string) {
        if (this.request != null) {
            return this.request.getIntHeader(string);
        }
        return -1;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        if (this.request != null) {
            return this.request.getRemoteUser();
        }
        return null;
    }

    public boolean isUserInRole(String string) {
        if (this.request != null) {
            return this.request.isUserInRole(string);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        if (this.request != null) {
            return this.request.getUserPrincipal();
        }
        return null;
    }

    public String getRequestedSessionId() {
        if (this.request != null) {
            return this.request.getRequestedSessionId();
        }
        return null;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean b) {
        if (this.request != null) {
            return this.request.getSession(b);
        }
        return null;
    }

    public HttpSession getSession() {
        if (this.request != null) {
            return this.request.getSession();
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        if (this.request != null) {
            return this.request.isRequestedSessionIdValid();
        }
        throw new IllegalStateException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.request != null) {
            return this.request.isRequestedSessionIdFromCookie();
        }
        throw new IllegalStateException();
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.request != null) {
            return this.request.isRequestedSessionIdFromURL();
        }
        throw new IllegalStateException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        if (this.request != null) {
            return this.request.getLocalPort();
        }
        return -1;
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return null;
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return false;
    }

    public String changeSessionId() {
        return null;
    }

    public Part getPart(String arg0) throws IOException, ServletException {
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public void login(String arg0, String arg1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        return null;
    }

    public String getRequestId() {
        if (this.request != null) {
            return this.request.getRequestId();
        }
        return null;
    }

    public String getProtocolRequestId() {
        if (this.request != null) {
            return this.request.getProtocolRequestId();
        }
        return null;
    }

    public ServletConnection getServletConnection() {
        if (this.request != null) {
            return this.request.getServletConnection();
        }
        return null;
    }
}

