/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.thread;

import coldfusion.runtime.DefaultScope;
import coldfusion.runtime.LocalScope;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Scope;
import coldfusion.thread.Task;
import coldfusion.thread.ThreadConstants;

public class ThreadScope
extends DefaultScope
implements ThreadConstants {
    private String ownerThreadName;
    private Task task;
    private String baseTemplatePath;
    private String webrootPath;
    private static ThreadLocal threadLocal = new ThreadLocal();
    private static final String THREAD = "thread";

    static void setCurrent(ThreadScope threadScope) {
        LocalScope scope;
        LocalScope localScope = scope = threadScope == null ? null : new LocalScope();
        if (scope != null) {
            ((Scope)scope).put(THREAD, threadScope);
        }
        threadLocal.set(scope);
    }

    public static Scope getCurrentScopeContainer() {
        return (Scope)threadLocal.get();
    }

    public static ThreadScope getCurrent() {
        Scope scope = (Scope)threadLocal.get();
        return (ThreadScope)(scope == null ? null : scope.get(THREAD));
    }

    public static String getCurrentUserThreadName() {
        ThreadScope threadScope = ThreadScope.getCurrent();
        return threadScope == null ? null : threadScope.ownerThreadName;
    }

    public ThreadScope(String ownerThreadName, Task task2) {
        this.ownerThreadName = ownerThreadName;
        this.task = task2;
        this.setScopeType(2);
        this.initialize();
    }

    public String getThreadName() {
        return this.ownerThreadName;
    }

    public void setBaseTemplatePath(String baseTemplatePath) {
        this.baseTemplatePath = baseTemplatePath;
    }

    public String getBaseTemplatePath() {
        return this.baseTemplatePath;
    }

    public void setWebRootPath(String webrootPath) {
        this.webrootPath = webrootPath;
    }

    public String getWebRootPath() {
        return this.webrootPath;
    }

    private void initialize() {
        this.map.put("PRIORITY", "NORMAL");
        this.map.put("STATUS", "NOT_STARTED");
        this.map.put("OUTPUT", "");
        this.map.put("STARTTIME", "0");
        this.map.put("ELAPSEDTIME", "0");
        this.map.put("NAME", this.ownerThreadName);
    }

    void bindInternal(String name, Object obj) {
        this.map.put(name, obj);
    }

    @Override
    public void bindName(String name, Object obj) {
        if (this.isMetaDataKey(name)) {
            throw new ThreadMetaDataModificationException(name);
        }
        if (!this.isOwnerThread()) {
            throw new ThreadScopeAccessException();
        }
        super.bindName(name, obj);
    }

    @Override
    public void unbindName(String name) {
        if (!this.isOwnerThread()) {
            throw new ThreadScopeAccessException();
        }
        super.unbindName(name);
    }

    private boolean isOwnerThread() {
        return this.ownerThreadName.equals(ThreadScope.getCurrentUserThreadName());
    }

    @Override
    public Object resolveName(String name) {
        if ((name = name.toUpperCase()).equals("PRIORITY")) {
            return this.resolvePriority(this.task.getPriority());
        }
        if (name.equals("STATUS")) {
            return this.resolveStatus(this.task.getStatus());
        }
        if (name.equals("OUTPUT")) {
            return this.task.getOutput();
        }
        if (name.equals("ERROR")) {
            return this.task.getError();
        }
        if (name.equals("STARTTIME")) {
            return new OleDateTime(this.task.getStartTime());
        }
        if (name.equals("ELAPSEDTIME")) {
            return new Long(this.task.getElapsedTime());
        }
        return super.resolveName(name);
    }

    private String resolveStatus(int status) {
        switch (status) {
            case 0: {
                return "NOT_STARTED";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "WAITING";
            }
            case 3: {
                return "TERMINATED";
            }
            case 4: {
                return "COMPLETED";
            }
        }
        return "NOT_STARTED";
    }

    private String resolvePriority(int priority) {
        switch (priority) {
            case 7: {
                return "HIGH";
            }
            case 3: {
                return "LOW";
            }
        }
        return "NORMAL";
    }

    private boolean isMetaDataKey(String name) {
        return (name = name.toUpperCase()).equals("PRIORITY") || name.equals("STATUS") || name.equals("OUTPUT") || name.equals("ERROR") || name.equals("STARTTIME") || name.equals("ELAPSEDTIME") || name.equals("NAME");
    }

    public static class ThreadMetaDataModificationException
    extends NeoException {
        public String name;

        public ThreadMetaDataModificationException(String name) {
            this.name = name;
        }
    }

    public static class ThreadScopeAccessException
    extends NeoException {
    }
}

