/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.runtime.ListFunc;
import java.util.Collection;

public class AnalysisScope {
    private Collection tagScope;
    private Collection funcScope;
    private Collection otherScope;
    private boolean allTag;
    private boolean allFunc;
    private boolean allOther;
    private String severityScope;
    private String codeVersion = "8";

    public void setTagScope(String scope) {
        if (scope.equals("all")) {
            this.allTag = true;
        } else {
            this.tagScope = scope.equals("none") ? null : ListFunc.ListToArray(scope.toLowerCase(), ",");
        }
    }

    public void setFuncScope(String scope) {
        if (scope.equals("all")) {
            this.allFunc = true;
        } else {
            this.funcScope = scope.equals("none") ? null : ListFunc.ListToArray(scope.toLowerCase(), ",");
        }
    }

    public void setOtherScope(String scope) {
        if (scope.equals("all")) {
            this.allOther = true;
        } else {
            this.otherScope = scope.equals("none") ? null : ListFunc.ListToArray(scope.toLowerCase(), ",");
        }
    }

    public void setSeverityScope(String scope) {
        this.severityScope = scope;
    }

    public void setCodeVersion(String codeVersion) {
        if (codeVersion != null && codeVersion.length() > 0) {
            this.codeVersion = codeVersion;
        }
    }

    public boolean isInTagScope(String tagName) {
        if (this.allTag) {
            return true;
        }
        return this.tagScope == null ? false : this.tagScope.contains(tagName.toLowerCase());
    }

    public boolean isInFuncScope(String funcName) {
        if (this.allFunc) {
            return true;
        }
        return this.funcScope == null ? false : this.funcScope.contains(funcName.toLowerCase());
    }

    public boolean isInOtherScope(String other) {
        if (this.allOther) {
            return true;
        }
        return this.otherScope == null ? false : this.otherScope.contains(other.toLowerCase());
    }

    public boolean isAnalyzingAll() {
        return this.allTag && this.allFunc && this.allOther;
    }

    public boolean isInSeverityScope(String severity) {
        if (this.severityScope.equals("all")) {
            return true;
        }
        return this.severityScope.equalsIgnoreCase(severity.trim());
    }

    public boolean checkForCompatibility(String version) {
        int i_codev;
        int i_v;
        try {
            i_v = Integer.parseInt(version);
            i_codev = Integer.parseInt(this.codeVersion);
        }
        catch (Exception ex) {
            return false;
        }
        return i_v - i_codev > 0;
    }

    public String getCodeVersion() {
        return this.codeVersion;
    }
}

