/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.EvaluateEngine;
import coldfusion.compiler.ExprNode;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.Node;
import coldfusion.compiler.NonConstantExpressionException;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.VariableReference;
import coldfusion.compiler.validation.CFMLCodeValidator;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.compiler.validation.ParseExceptionWrapper;
import coldfusion.compiler.validation.ValidationResultCollector;
import coldfusion.tools.AnalysisScope;
import coldfusion.tools.CodeAnalyzerException;
import coldfusion.tools.CompatibilityException;
import coldfusion.tools.CompatibilityIssue;
import coldfusion.tools.CompatibilityMetaInfo;
import coldfusion.tools.FunctionCompatibilityIssue;
import coldfusion.tools.TagCompatibilityIssue;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;

public class CFMLCodeAnalyzer
extends JJTreeVisitor
implements ValidationResultCollector {
    private CompatibilityMetaInfo metaInfo;
    private AnalysisScope scope;
    private CFMLCodeValidator validator;
    private Collection validation;
    private Collection compatibility;
    private Collection knownVariables;
    private boolean isValidating;
    private String fileName;
    private boolean isCFC = false;
    private static final HashSet builtinScopes = new HashSet();

    public CFMLCodeAnalyzer(AnalysisScope scope, CompatibilityMetaInfo metaInfo, boolean isValidating) {
        this.scope = scope;
        this.isValidating = isValidating;
        if (isValidating) {
            this.validator = new CFMLCodeValidator(this);
        }
        this.metaInfo = metaInfo;
        this.validation = new ArrayList();
        this.compatibility = new ArrayList();
        this.knownVariables = new ArrayList();
    }

    public void analyze(ASTstart root, String filename) {
        this.fileName = filename.toLowerCase();
        this.isCFC = this.fileName.indexOf(".cfc") > 0;
        try {
            root.accept(this);
        }
        catch (ParseException parseEx) {
            ParseExceptionWrapper error = new ParseExceptionWrapper(parseEx);
            error.setLineNumbers(parseEx.getLine(), parseEx.getLine());
            this.collectValidationResult(error);
        }
    }

    @Override
    public void visit(ASTstart root) {
        if (this.isValidating) {
            this.validator.visit(root);
        } else {
            this.reset();
        }
    }

    @Override
    public void visit(TagNode tagNode) {
        String tagName;
        if (tagNode.isStatic()) {
            this.checkCompatibility("static", (Node)tagNode);
        }
        if (this.isValidating) {
            this.validator.visit(tagNode);
        }
        if ((tagName = tagNode.getTagName()) != null && (this.scope.isAnalyzingAll() || this.scope.isInTagScope(tagName))) {
            this.checkCompatibility(tagName, (Node)tagNode);
        }
    }

    @Override
    public void visit(ASTsimpleVariableReference variable) {
        String variableName = variable.getVariableName();
        if (!this.knownVariables.contains(variableName.toUpperCase())) {
            this.knownVariables.add(variableName.toUpperCase());
        }
    }

    @Override
    public void visit(ASTstructureReference struct) {
        String name = struct.validatableName();
        if (!"CFCATCH.MESSAGE".equalsIgnoreCase(name) && (this.scope.isAnalyzingAll() || this.scope.isInOtherScope(name))) {
            this.checkCompatibility(name, (Node)struct);
        }
    }

    @Override
    public void visit(ASToperator op) {
        String opname = op.getOperator().image;
        if (this.scope.isAnalyzingAll() || this.scope.isInOtherScope(opname)) {
            this.checkCompatibility(opname, (Node)op);
        }
    }

    public void visit(ASTcffunction func) {
        if (this.isValidating) {
            this.validator.visit(func);
        }
        String funcName = func.getCodeGenName();
        if (this.scope.isAnalyzingAll() || this.scope.isInFuncScope(funcName)) {
            this.checkCompatibility(funcName, (Node)func);
        }
    }

    public void visit(ASTfunctionDefinition funcDef) {
        if (this.isValidating) {
            this.validator.visit(funcDef);
        }
        String funcName = funcDef.getCodeGenName();
        if (this.scope.isAnalyzingAll() || this.scope.isInFuncScope(funcName)) {
            this.checkCompatibility(funcName, (Node)funcDef);
        }
    }

    @Override
    public void visit(ASTcfscriptStatement assignment) {
        String varName = assignment.getValidatableName().toUpperCase();
        Node lval = assignment.getNamedAttribute("LVAL");
        boolean isStatic = varName.equals("STATIC");
        if (lval.isStatic() || isStatic && !lval.staticSupportDisabled()) {
            this.checkCompatibility("static", lval);
        }
        if (isStatic) {
            varName = "static_scope_error";
        }
        if (lval instanceof ASTstructureReference) {
            if (varName.indexOf(".") > 0 && !varName.startsWith("CFCATCH") && !this.knownVariables.contains(varName.substring(0, varName.indexOf(".")))) {
                varName = "variable_names";
            }
            if (varName.toUpperCase().startsWith("LOCAL.") && assignment.getFunctionDef() != null) {
                varName = "local_scope_info";
            }
        } else if (lval instanceof ASTsimpleVariableReference) {
            if (builtinScopes.contains(varName.toUpperCase())) {
                varName = "builtin_scopes";
            }
            if (varName.equalsIgnoreCase("LOCAL") && assignment.getFunctionDef() != null) {
                varName = "local_scope_error";
            }
        }
        if (this.scope.isAnalyzingAll() || this.scope.isInOtherScope(varName)) {
            this.checkCompatibility(varName, lval);
        }
    }

    @Override
    public void visit(ASTruntimeCall function) {
        if (!function.isVariadic() && function.isBuiltin()) {
            if (this.isValidating) {
                this.validator.visit(function);
            }
            String funcName = function.getFunctionName();
            if (this.scope.isAnalyzingAll() || this.scope.isInFuncScope(funcName)) {
                VariableReference stem = function.getStem();
                if (this.isCFC && stem != null && funcName.equalsIgnoreCase(stem.getStartToken().toString())) {
                    this.checkUDFInCFCCompatibility(funcName, function);
                } else {
                    this.checkCompatibility(funcName, (Node)function);
                }
            }
        }
    }

    @Override
    public void visit(ASTfuncparams params) {
        if (this.isValidating) {
            this.validator.visit(params);
        }
    }

    protected String lookUpRemedy(String feature) {
        List<CompatibilityIssue> issues = this.metaInfo.lookup(feature, this.scope.getCodeVersion());
        if (issues != null && issues.size() > 0) {
            return issues.get(0).getRemedy();
        }
        return null;
    }

    private void checkArgumentsCollectionCompat(Node node) {
        List<CompatibilityIssue> issues = this.metaInfo.lookup("attributecollection", this.scope.getCodeVersion());
        for (CompatibilityIssue issue : issues) {
            boolean conditions = this.checkPreCondition(issue, false);
            if (!conditions) continue;
            this.checkCompatibility(issue, node);
        }
    }

    private void checkUDFInCFCCompatibility(String featureName, Node node) {
        List<CompatibilityIssue> issues = this.metaInfo.lookup(featureName, this.scope.getCodeVersion());
        for (CompatibilityIssue issue : issues) {
            boolean conditions = this.checkPreCondition(issue, true);
            if (!conditions) continue;
            String description = issue.getDescription() + RB.getString(this, "UDF_FUNCNAME_DESCREPANCY_INFO");
            String remedy = issue.getRemedy() + RB.getString(this, "CFC_FUNCNAME_DESCREPANCY_FIX");
            CompatibilityIssue cfcIssue = new CompatibilityIssue(description, remedy, "Info", issue.getFeatureName(), issue.getCategory(), issue.getVersion());
            CompatibilityException compat = new CompatibilityException(cfcIssue);
            compat.setLineNumbers(node);
            this.compatibility.add(compat);
        }
    }

    private boolean checkPreCondition(CompatibilityIssue issue, boolean isCFc) {
        String severity;
        if (issue == null) {
            return false;
        }
        if (!this.scope.checkForCompatibility(issue.getVersion())) {
            return false;
        }
        String string = severity = this.isCFC ? "Info" : issue.getSeverity();
        return issue.getSeverity() == null || this.scope.isInSeverityScope(severity);
    }

    private void checkCompatibility(CompatibilityIssue issue, Node node) {
        if (issue instanceof TagCompatibilityIssue) {
            this.checkTagCompatibility((TagNode)node, (TagCompatibilityIssue)issue);
        } else if (issue instanceof FunctionCompatibilityIssue) {
            this.checkFunctionCompatibility(node, (FunctionCompatibilityIssue)issue);
        }
    }

    private void checkCompatibility(String featureName, Node node) {
        List<CompatibilityIssue> issues = this.metaInfo.lookup(featureName, this.scope.getCodeVersion());
        for (CompatibilityIssue issue : issues) {
            boolean conditions = this.checkPreCondition(issue, false);
            if (!conditions) continue;
            this.checkCompatibility(issue, node);
        }
    }

    private void checkTagCompatibility(TagNode tagNode, TagCompatibilityIssue issue) {
        TagCompatibilityIssue result = null;
        boolean attrRelated = issue.isAttributesRelated();
        if (!attrRelated) {
            this.addTagCompatibilityIssue(issue, tagNode);
        } else {
            result = this.getTagCompatibilityIssue(tagNode, issue);
            if (result != null) {
                this.addTagCompatibilityIssue(result, tagNode);
            }
        }
    }

    private void checkFunctionCompatibility(Node node, FunctionCompatibilityIssue issue) {
        FunctionCompatibilityIssue result = null;
        result = this.getFunctionCompatibilityIssue(node, issue);
        if (result != null) {
            this.addFunctionCompatibilityIssue(result, node);
        }
    }

    private void addFunctionCompatibilityIssue(FunctionCompatibilityIssue issue, Node node) {
        CompatibilityException compat = new CompatibilityException(issue);
        compat.setLineNumbers(node);
        this.compatibility.add(compat);
    }

    private void addTagCompatibilityIssue(TagCompatibilityIssue issue, TagNode tagNode) {
        CompatibilityException compat = new CompatibilityException(issue);
        compat.setLineNumbers(tagNode);
        this.compatibility.add(compat);
    }

    private FunctionCompatibilityIssue getFunctionCompatibilityIssue(Node node, FunctionCompatibilityIssue issue) {
        if (issue.isRelated(node)) {
            return issue;
        }
        return null;
    }

    private TagCompatibilityIssue getTagCompatibilityIssue(TagNode tagNode, TagCompatibilityIssue compat) {
        try {
            Enumeration attrEnum = tagNode.getAttrNames();
            while (attrEnum.hasMoreElements()) {
                String attrName = attrEnum.nextElement().toString();
                if (!compat.isAttributeRelated(attrName)) continue;
                try {
                    TagCompatibilityIssue checkedIssue;
                    String attrValue;
                    if (compat.isAttrValueRelated()) {
                        ExprNode attrNode = tagNode.getAttrNode(attrName);
                        attrValue = EvaluateEngine._String(attrNode);
                    } else {
                        attrValue = null;
                    }
                    if ((checkedIssue = compat.getCompatibilityIssue(attrName, attrValue)) == null || !this.scope.checkForCompatibility(checkedIssue.getVersion()) || !this.scope.isInSeverityScope(checkedIssue.getSeverity())) continue;
                    return checkedIssue;
                }
                catch (NonConstantExpressionException checkedIssue) {
                }
            }
        }
        catch (ParseException parseEx) {
            ParseExceptionWrapper error = new ParseExceptionWrapper(parseEx);
            error.setLineNumbers(parseEx.getLine(), parseEx.getLine());
            this.collectValidationResult(error);
        }
        catch (NoSuchElementException ex) {
            throw new CodeAnalyzerException(ex);
        }
        return null;
    }

    @Override
    public void collectValidationResult(CFMLValidationException error) {
        this.validation.add(error);
    }

    @Override
    public Collection getValidationResult() {
        return this.validation;
    }

    public Collection getCompatibilityResult() {
        return this.compatibility;
    }

    @Override
    public void reset() {
        this.validation.clear();
        this.compatibility.clear();
        this.knownVariables.clear();
        this.fillKnownVariables();
    }

    public void fillKnownVariables() {
        this.knownVariables.add("VARIABLES");
        this.knownVariables.add("FORM");
        this.knownVariables.add("URL");
        this.knownVariables.add("ATTRIBUTES");
        this.knownVariables.add("CALLER");
        this.knownVariables.add("REQUEST");
        this.knownVariables.add("CGI");
        this.knownVariables.add("COOKIE");
        this.knownVariables.add("CLIENT");
        this.knownVariables.add("SESSION");
        this.knownVariables.add("APPLICATION");
        this.knownVariables.add("SERVER");
        this.knownVariables.add("THISTAG");
    }

    static {
        builtinScopes.add("FILE");
        builtinScopes.add("URL");
        builtinScopes.add("CLIENT");
        builtinScopes.add("COOKIE");
        builtinScopes.add("FORM");
        builtinScopes.add("REQUEST");
        builtinScopes.add("CGI");
        builtinScopes.add("HTTP");
        builtinScopes.add("SERVER");
        builtinScopes.add("CFFILE");
        builtinScopes.add("CFHTTP");
        builtinScopes.add("APPLICATION");
        builtinScopes.add("SESSION");
    }
}

