/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.compiler.CFMLParserBase;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.validation.ParseExceptionWrapper;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.tools.AnalysisResult;
import coldfusion.tools.AnalysisScope;
import coldfusion.tools.AnalyzerApp;
import coldfusion.tools.CFMLCodeAnalyzer;
import coldfusion.tools.CodeAnalyzerException;
import coldfusion.tools.CompatibilityMetaInfo;
import coldfusion.util.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodeAnalyzerMain {
    private AnalysisResult result;
    private AnalysisScope scope;
    private AnalyzerApp context;
    private CompatibilityMetaInfo metaInfo;
    private FileFilter filter;
    private CFMLCodeAnalyzer analyzer;
    private NeoTranslator translator;
    private boolean recurse;
    private String webroot;
    private List<String> disallowedPaths;
    private static final String DISALLOWED_PATH_CFIDE = "CFIDE";
    private static final String DISALLOWED_PATH_SCRIPTS = "cf_scripts";
    private static final String DISALLOWED_PATH_WEB_INF = "WEB-INF";

    public CodeAnalyzerMain(String curPath, String webroot) {
        this.webroot = webroot;
        this.disallowedPaths = new ArrayList<String>();
        this.disallowedPaths.add(DISALLOWED_PATH_CFIDE);
        this.disallowedPaths.add(DISALLOWED_PATH_SCRIPTS);
        this.disallowedPaths.add(DISALLOWED_PATH_WEB_INF);
        this.metaInfo = CompatibilityMetaInfo.instance(curPath + "/compatibility.xml");
        this.scope = new AnalysisScope();
        this.context = new AnalyzerApp();
        this.result = new AnalysisResult();
    }

    public void setAnalysisScope(String codeVersion, String tagScope, String funcScope, String otherScope, String severityScope) {
        this.scope.setCodeVersion(codeVersion);
        this.scope.setTagScope(tagScope);
        this.scope.setFuncScope(funcScope);
        this.scope.setOtherScope(otherScope);
        this.scope.setSeverityScope(severityScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String analyze(String codePath, String filter, String recurse, String validation) {
        File canonicalCodeDir = Utils.getCanonicalFile(codePath);
        codePath = canonicalCodeDir.getPath();
        FusionContext fusionContext = new FusionContext();
        fusionContext.application = this.context;
        FusionContext oldContext = FusionContext.setCurrent(fusionContext);
        String webInfo = oldContext.getServletContext().getRealPath("/WEB-INF/web.xml");
        String webroot = new File(webInfo).getParentFile().getParentFile().getAbsolutePath();
        if (webroot.endsWith("/") || webroot.endsWith("\\")) {
            webroot = webroot.substring(0, webroot.length() - 1);
        }
        this.context.setWebRoot(webroot);
        this.readInitParameters(this.context);
        this.filter = new CfmlFileFilter(filter);
        this.recurse = recurse.equalsIgnoreCase("Yes");
        this.analyzer = new CFMLCodeAnalyzer(this.scope, this.metaInfo, validation.equals("Yes"));
        this.context.setAttribute("CodeAnalyzer", this.analyzer);
        try {
            try {
                this.translator = new NeoTranslator(this.context);
            }
            catch (IOException ioe) {
                throw new CodeAnalyzerException(ioe);
            }
            StringWriter sw = new StringWriter();
            if (canonicalCodeDir.isFile() && this.filter.accept(canonicalCodeDir)) {
                this.doAnalysis(codePath, canonicalCodeDir);
            } else if (canonicalCodeDir.isDirectory()) {
                this.doAnalysis(canonicalCodeDir);
            }
            try {
                this.result.toWddxPacket(sw);
            }
            catch (Exception e) {
                throw new CodeAnalyzerException(e);
            }
            String string = sw.toString();
            return string;
        }
        finally {
            FusionContext.setCurrent(oldContext);
        }
    }

    private void doAnalysis(File dirFile) {
        File[] files = dirFile.listFiles(this.filter);
        if (files == null) {
            this.analyzer.reset();
            this.analyzer.collectValidationResult(new ParseExceptionWrapper(new DirectoryAccessException(dirFile.getAbsolutePath())));
            this.result.addCompatibilityResult(dirFile.getAbsolutePath(), this.analyzer.getValidationResult());
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            this.analyzer.reset();
            File canonicalFile = files[i];
            String abpath = canonicalFile.getPath();
            if (this.checkAdministratorPaths(abpath)) continue;
            if (canonicalFile.isFile()) {
                this.doAnalysis(abpath, canonicalFile);
                continue;
            }
            if (!canonicalFile.isDirectory() || !this.recurse) continue;
            this.doAnalysis(canonicalFile);
        }
    }

    private boolean checkAdministratorPaths(String filePath) {
        Iterator<String> iterator = this.disallowedPaths.iterator();
        while (iterator.hasNext()) {
            if (filePath.indexOf(this.webroot + File.separator + iterator.next()) != 0) continue;
            return true;
        }
        return false;
    }

    private void doAnalysis(String filename, File canonicalFile) {
        this.analyzer.reset();
        try {
            this.translator.analyzePage(canonicalFile);
        }
        catch (Exception ex) {
            CFLogs.APPLICATION_LOG.error(ex.getMessage() + " " + filename);
            ParseExceptionWrapper wrapper = new ParseExceptionWrapper(ex);
            this.analyzer.collectValidationResult(wrapper);
            this.addRemedy(wrapper);
        }
        this.result.addCompatibilityResult(filename, this.analyzer.getCompatibilityResult());
        this.result.addValidationResult(filename, this.analyzer.getValidationResult());
    }

    private void addRemedy(ParseExceptionWrapper wrapper) {
        if (wrapper.rootCause instanceof CFMLParserBase.StaticKeywordAssignmentException) {
            wrapper.setRemedy(this.analyzer.lookUpRemedy("static"));
        }
    }

    private void readInitParameters(AnalyzerApp application) {
        Utils.parseWebXml(application);
        Document webxml = (Document)application.getAttribute("coldfusion.web.xml");
        if (webxml != null) {
            NodeList nodes = webxml.getElementsByTagName("context-param");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("context-param")) continue;
                String name = null;
                String value = null;
                NodeList list = node.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node n;
                    node = list.item(j);
                    if (node.getNodeName().equals("param-name")) {
                        n = node.getFirstChild();
                        name = n != null ? n.getNodeValue().toString().trim() : null;
                        continue;
                    }
                    if (!node.getNodeName().equals("param-value")) continue;
                    n = node.getFirstChild();
                    value = n != null ? n.getNodeValue().toString().trim() : null;
                }
                if (name == null) continue;
                application.setInitParameter(name, value);
            }
        } else {
            application.setInitParameter("coldfusion.compiler.outputDir", "/WEB-INF/cfclasses");
        }
    }

    class CfmlFileFilter
    implements FileFilter {
        private Collection filters;
        private String filter;

        public CfmlFileFilter(String filter) {
            if (filter == null || filter != null && filter.length() <= 0) {
                throw new InvalidFileFilterException(filter);
            }
            this.filter = filter;
            this.filters = new ArrayList();
            if (filter.indexOf(",") > 0) {
                StringTokenizer tokenizer = new StringTokenizer(filter, ",");
                while (tokenizer.hasMoreTokens()) {
                    String temp = tokenizer.nextToken().toString();
                    this.filters.add(temp);
                }
            } else {
                this.filters.add(filter);
            }
        }

        @Override
        public boolean accept(File file) {
            String name = file.getAbsolutePath();
            boolean ret = false;
            if (file.isDirectory()) {
                ret = true;
            } else if (name.indexOf(".") < 0) {
                ret = false;
            } else {
                String nm = name.substring(name.lastIndexOf(".") + 1);
                ret = this.filters.contains(nm);
            }
            return ret;
        }
    }

    public static class DirectoryAccessException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String dir;

        public DirectoryAccessException(String dir) {
            this.dir = dir;
        }
    }

    public static class InvalidFileFilterException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String filter;

        public InvalidFileFilterException(String filter) {
            this.filter = filter;
        }
    }
}

