/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.compiler.Node;
import coldfusion.compiler.Token;
import coldfusion.compiler.validation.CfmlDiagnosticInfo;
import coldfusion.runtime.NeoException;
import coldfusion.tools.CompatibilityIssue;

public class CompatibilityException
extends RuntimeException
implements CfmlDiagnosticInfo {
    public String description;
    public String severity;
    private CompatibilityIssue issue;
    private int beginLine;
    private int endLine;
    private String message;
    private String detail;

    public CompatibilityException(CompatibilityIssue issue) {
        this.issue = issue;
        this.description = issue.getDescription();
        this.severity = issue.getSeverity().toUpperCase();
    }

    @Override
    public final String getMessage() {
        if (this.message == null) {
            this.message = NeoException.getString(this, "message", null);
        }
        return this.message;
    }

    public final String getDetail() {
        if (this.detail == null) {
            this.detail = NeoException.getString(this, "detail", null);
        }
        return this.detail;
    }

    @Override
    public String getDescription() {
        return this.issue.getDescription();
    }

    @Override
    public String getSeverity() {
        return this.issue.getSeverity();
    }

    @Override
    public String getRemedy() {
        return this.issue.getRemedy();
    }

    @Override
    public void setLineNumbers(int beginLine, int endLine) {
        this.beginLine = beginLine;
        this.endLine = endLine;
    }

    @Override
    public void setLineNumbers(Node node) {
        Token token;
        int beginLine = -1;
        int endLine = -1;
        try {
            token = node.getStartToken();
            beginLine = token.beginLine;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            token = node.getEndToken();
            endLine = token.endLine;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setLineNumbers(beginLine, endLine);
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public String getFeatureName() {
        return this.issue.getFeatureName();
    }

    @Override
    public String getCategory() {
        return this.issue.getCategory();
    }
}

