/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.runtime.Array;
import coldfusion.runtime.ListFunc;
import coldfusion.tools.CompatibilityIssue;
import coldfusion.tools.TagCompatibilityIssue;
import coldfusion.util.FastHashtable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ComplexCompatibilityIssue
extends TagCompatibilityIssue {
    private Map availableIssues = new FastHashtable();
    private Map attrTable = new FastHashtable();
    private boolean attrValueRelated;
    private Collection attributes = new ArrayList();

    public void computeNewVersion(CompatibilityIssue issue) {
        try {
            int thisIssueVersion = Integer.parseInt(this.getVersion());
            int newIssueVersion = Integer.parseInt(issue.getVersion());
            int computedVersion = Math.max(thisIssueVersion, newIssueVersion);
            this.setVersion("" + computedVersion);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void addIssue(String attributes, String attrValues, TagCompatibilityIssue issue) {
        if (attributes == null && attrValues == null) {
            this.availableIssues.put(issue.getFeatureName(), issue);
            this.computeNewVersion(issue);
            return;
        }
        Array attrList = ListFunc.ListToArray(attributes.toLowerCase(), ",");
        this.attributes.addAll(attrList);
        if (attrValues == null) {
            this.availableIssues.put(attributes, issue);
            issue.setFeatureName(issue.getFeatureName() + " - " + attributes);
            Iterator i = attrList.iterator();
            while (i.hasNext()) {
                this.attrTable.put(i.next(), attributes);
            }
        } else {
            this.attrValueRelated = true;
            this.availableIssues.put(attributes + " - " + attrValues, issue);
            issue.setFeatureName(issue.getFeatureName() + " - " + attributes + " - " + attrValues);
            Iterator i = attrList.iterator();
            while (i.hasNext()) {
                String attrName = i.next().toString();
                this.attrTable.put(attrName + ":", attributes + " - " + attrValues);
            }
        }
        this.computeNewVersion(issue);
    }

    @Override
    public TagCompatibilityIssue getCompatibilityIssue(String attrName, String attrValue) {
        Object attrList = this.attrTable.get(attrName);
        if (attrList == null && attrValue != null) {
            attrList = this.attrTable.get(attrName + ":");
        }
        if (attrList == null) {
            return null;
        }
        TagCompatibilityIssue issue = (TagCompatibilityIssue)this.availableIssues.get(attrList);
        if (!issue.isCompatible(attrName, attrValue)) {
            return issue;
        }
        return null;
    }

    @Override
    public String getCategory() {
        return "Tag";
    }

    @Override
    public boolean isAttributesRelated() {
        return true;
    }

    @Override
    public boolean isAttributeRelated(String attrName) {
        return this.attributes.contains(attrName.toLowerCase());
    }

    @Override
    public boolean isAttrValueRelated() {
        return this.attrValueRelated;
    }
}

