/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTtagAttribute;
import coldfusion.compiler.Node;
import coldfusion.runtime.CFPage;
import coldfusion.tools.CompatibilityIssue;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;

public class FunctionCompatibilityIssue
extends CompatibilityIssue {
    static Method[] cfpagemethods = CFPage.class.getMethods();
    String argumentNames;
    String argumentValues;
    public static final String NA = "N/A";

    public FunctionCompatibilityIssue() {
    }

    public FunctionCompatibilityIssue(String description, String remedy, String severity, String featureName, String category, String version, String attributes, String attrvalues) {
        super(description, remedy, severity, featureName, category, version);
        this.argumentNames = attributes;
        this.argumentValues = attrvalues;
    }

    public boolean isRelated(Node node) {
        List<Node> functionChilren;
        boolean isNamedParamCall = false;
        String functionName = "";
        Object args = "";
        Object argNames = "";
        if (node instanceof ASTruntimeCall) {
            functionName = ((ASTruntimeCall)node).getFunctionName();
        }
        if (this != null && (functionChilren = node.getAllChildren()).size() > 0) {
            for (Node child : functionChilren) {
                if (!(child instanceof ASTfuncparams)) continue;
                List<Node> parameterNodes = child.getAllChildren();
                for (Node parameter : parameterNodes) {
                    if (parameter instanceof ASTliteral) {
                        String arg = ((ASTliteral)parameter).getCombinedString();
                        args = (String)args + arg + ",";
                        continue;
                    }
                    if (!(parameter instanceof ASTtagAttribute)) continue;
                    isNamedParamCall = true;
                    String paramName = parameter.getStartToken().toString();
                    argNames = (String)argNames + paramName + ",";
                    List<Node> parametersList = ((ASTtagAttribute)parameter).getAllChildren();
                    for (Node parameterNode : parametersList) {
                        if (!(parameterNode instanceof ASTliteral)) continue;
                        String paramValue = ((ASTliteral)parameterNode).getCombinedString();
                        args = (String)args + paramValue + ",";
                    }
                }
            }
        }
        args = ((String)args).endsWith(",") ? ((String)args).substring(0, ((String)args).length() - 1) : args;
        String[] argParts = ((String)args).split(",");
        argNames = ((String)argNames).endsWith(",") ? ((String)argNames).substring(0, ((String)argNames).length() - 1) : args;
        String[] argNamesParts = ((String)argNames).split(",");
        int argCount = argParts.length;
        if (this.argumentNames.equals(NA) || this.argumentValues.equals(NA)) {
            return true;
        }
        if (cfpagemethods.length > 0) {
            for (Method method : cfpagemethods) {
                Parameter[] methodParameters;
                if (!method.getName().toLowerCase().equals(functionName.toLowerCase()) || argCount != method.getParameterCount()) continue;
                for (Parameter param : methodParameters = method.getParameters()) {
                    for (int i = 0; i < argParts.length; ++i) {
                        if (!(!isNamedParamCall ? param.getName().toLowerCase().equals(this.argumentNames.toLowerCase()) && this.argumentValues.toLowerCase().equals(argParts[i].toLowerCase()) : param.getName().toLowerCase().equals(this.argumentNames.toLowerCase()) && this.argumentValues.toLowerCase().equals(argParts[i].toLowerCase()) && param.getName().toLowerCase().equals(argNamesParts[i]))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

