/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tools;

import coldfusion.tools.CompatibilityIssue;
import coldfusion.util.FastHashtable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;

public class TagCompatibilityIssue
extends CompatibilityIssue
implements Serializable {
    private Map attrsTable;
    private Collection attrs;
    private String attributes;
    private String attrValues;
    static final long serialVersionUID = 2865467829954845481L;

    public TagCompatibilityIssue() {
    }

    public TagCompatibilityIssue(String description, String remedy, String severity, String featureName, String category, String version, String attributes, String attrValues) {
        super(description, remedy, severity, featureName, category, version);
        this.attributes = attributes == null ? null : attributes.toLowerCase();
        this.attrValues = attrValues;
        this.fillAttributesTable(attributes, attrValues);
    }

    private void fillAttributesTable(String attrList, String attrValueList) {
        block4: {
            StringTokenizer attrNameTokenizer;
            block3: {
                if (attrList == null) {
                    return;
                }
                attrNameTokenizer = new StringTokenizer(attrList.toLowerCase(), ",");
                if (attrValueList != null) break block3;
                this.attrs = new ArrayList();
                while (attrNameTokenizer.hasMoreElements()) {
                    this.attrs.add(attrNameTokenizer.nextElement());
                }
                break block4;
            }
            if (attrNameTokenizer.countTokens() != 1) break block4;
            this.attrsTable = new FastHashtable();
            while (attrNameTokenizer.hasMoreElements()) {
                String attrName = attrNameTokenizer.nextElement().toString();
                this.attrsTable.put(attrName, attrValueList.toLowerCase());
            }
        }
    }

    public boolean isCompatible(String attrName, String attrValue) {
        if (this.attrs != null && this.attrs.contains(attrName.toLowerCase())) {
            return false;
        }
        if (this.attrsTable != null) {
            String values = (String)this.attrsTable.get(attrName);
            if (values == null) {
                return true;
            }
            StringTokenizer attrValueTokenizer = new StringTokenizer(values.toLowerCase(), ",");
            while (attrValueTokenizer.hasMoreElements()) {
                String value = attrValueTokenizer.nextElement().toString();
                if (!value.equalsIgnoreCase(attrValue)) continue;
                return false;
            }
        }
        return true;
    }

    public TagCompatibilityIssue getCompatibilityIssue(String attrName, String attrValue) {
        if (this.isCompatible(attrName, attrValue)) {
            return null;
        }
        return this;
    }

    public boolean isAttributesRelated() {
        return this.attributes != null;
    }

    public boolean isAttributeRelated(String attrName) {
        return this.attributes == null ? false : this.attributes.indexOf(attrName.toLowerCase()) >= 0;
    }

    public boolean isAttrValueRelated() {
        return this.attrValues != null;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getAttributeValues() {
        return this.attrValues;
    }

    public String getAttributeValue(String attrName) {
        if (this.attrsTable != null && this.attrsTable.get(attrName) != null) {
            return this.attrsTable.get(attrName).toString();
        }
        return null;
    }
}

