/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.server.ServiceFactory;
import coldfusion.util.IOUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

public class CFFileServlet
extends HttpServlet {
    private static final String FILE_PARAM = "file";
    private static final String DEFAULT_MIMETYPE = "text/html";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String LAST_MODIFIED = "Last-Modified";
    protected static final String mimeSeparation = "JRUN_MIME_BOUNDARY";
    private static File cfCacheDir;
    private static String cfCacheDirAbsPath;
    private static Timer timer;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long modifiedSince;
        String servletPath;
        String filepath = request.getParameter(FILE_PARAM);
        if (filepath == null) {
            filepath = request.getRequestURI().substring(request.getContextPath().length());
        }
        if (filepath.equals(servletPath = request.getServletPath()) || filepath.equals(servletPath + "/")) {
            response.sendError(400);
            return;
        }
        File cacheDir = new File(cfCacheDirAbsPath, servletPath);
        String cacheDirAbsPath = cacheDir.getAbsolutePath();
        File file = new File(cfCacheDir, filepath);
        String path = file.getCanonicalPath();
        if (!path.startsWith(cacheDirAbsPath)) {
            response.sendError(403);
            return;
        }
        if (!file.exists() || file.isDirectory()) {
            response.sendError(404);
            return;
        }
        try {
            modifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
        }
        catch (Exception e) {
            modifiedSince = -1L;
        }
        long fileModifiedDate = file.lastModified();
        if (modifiedSince > 0L && (fileModifiedDate -= fileModifiedDate % 1000L) <= modifiedSince) {
            response.setStatus(304);
            return;
        }
        boolean sniffMimetype = false;
        String mimetype = this.getServletContext().getMimeType(path);
        if (mimetype == null) {
            mimetype = DEFAULT_MIMETYPE;
            sniffMimetype = true;
        }
        response.setContentType(mimetype);
        long fileLength = file.length();
        response.setDateHeader(LAST_MODIFIED, fileModifiedDate);
        ArrayList ranges = this.parseRange(request, response, fileLength);
        if ((ranges == null || ranges.isEmpty()) && request.getHeader("Range") == null && mimetype.equalsIgnoreCase("application/pdf") && fileLength > 0x1400000L && request.getHeader("User-Agent").indexOf("Firefox") != -1) {
            response.setContentLength((int)fileLength);
            response.setHeader("Accept-Ranges", "bytes");
            response.setStatus(200);
            try {
                this.writeInitialResponse(file, response);
            }
            catch (Throwable throwable) {}
        } else if (ranges != null && !ranges.isEmpty() && request.getHeader("Range") != null) {
            response.setStatus(206);
            response.setBufferSize(2048);
            ServletOutputStream ostream = response.getOutputStream();
            if (ranges.size() == 1) {
                Range range = (Range)ranges.get(0);
                response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                long length = range.end - range.start + 1L;
                if (length < Integer.MAX_VALUE) {
                    response.setContentLength((int)length);
                } else {
                    response.setHeader("content-length", "" + length);
                }
                this.copy(file, ostream, range);
            } else {
                response.setContentType("multipart/byteranges; boundary=JRUN_MIME_BOUNDARY");
                this.copy(file, ostream, ranges.iterator(), mimetype);
            }
        } else {
            response.setContentLength((int)fileLength);
            this.writeToResponse(file, response, sniffMimetype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInitialResponse(File file, HttpServletResponse response) throws IOException {
        try (BufferedInputStream in = null;){
            int read;
            in = new BufferedInputStream(new FileInputStream(file));
            ServletOutputStream os = response.getOutputStream();
            byte[] bytes = new byte[4096];
            int length = 0;
            while ((read = in.read(bytes)) != -1) {
                os.write(bytes, 0, read);
                os.flush();
                if ((length += read) <= 0x100000) continue;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToResponse(File file, HttpServletResponse response, boolean sniffMimetype) throws IOException {
        try (BufferedInputStream in = null;){
            int read;
            in = new BufferedInputStream(new FileInputStream(file));
            ServletOutputStream os = response.getOutputStream();
            byte[] bytes = new byte[4096];
            boolean firstRead = true;
            while ((read = in.read(bytes)) != -1) {
                if (sniffMimetype && firstRead) {
                    String mimetype = JRTypeSniffer.getImageMimeType(JRTypeSniffer.getImageType(bytes));
                    if (mimetype != null) {
                        response.setContentType(mimetype);
                    }
                    firstRead = false;
                }
                os.write(bytes, 0, read);
                os.flush();
            }
        }
    }

    protected void copy(File file, ServletOutputStream ostream, Iterator ranges, String contentType) throws IOException {
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file), 2048);
            Range currentRange = (Range)ranges.next();
            ostream.println();
            ostream.println("--JRUN_MIME_BOUNDARY");
            if (contentType != null) {
                ostream.println("Content-Type: " + contentType);
            }
            ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
            ostream.println();
            exception = this.copyRange(istream, ostream, currentRange.start, currentRange.end);
            ((InputStream)istream).close();
        }
        ostream.println();
        ostream.print("--JRUN_MIME_BOUNDARY--");
    }

    protected void copy(File file, ServletOutputStream ostream, Range range) throws IOException {
        IOException exception = null;
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(file), 2048);
        exception = this.copyRange(istream, ostream, range.start, range.end);
        ((InputStream)istream).close();
    }

    protected IOException copyRange(InputStream istream, ServletOutputStream ostream, long start, long end) {
        try {
            istream.skip(start);
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    protected ArrayList parseRange(HttpServletRequest request, HttpServletResponse response, long fileLength) throws IOException {
        if (fileLength == 0L) {
            return null;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return null;
        }
        if (!rangeHeader.startsWith("bytes")) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    response.addHeader("Content-Range", "bytes */" + fileLength);
                    response.sendError(416);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    public static void cleanupTempCache(File tempFolder, int expiryTimeInSec) {
        File[] files = tempFolder.listFiles();
        if (files == null) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (expiryTimeInSec != 0 && now - file.lastModified() <= (long)(expiryTimeInSec * 1000)) continue;
            IOUtils.delete(file);
        }
    }

    public static void submitTaskForCleanup(final File file, int expiryTimeInSec) {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                IOUtils.delete(file);
            }
        }, expiryTimeInSec * 1000);
    }

    protected static boolean isInTempCache(File f) {
        try {
            return f.getCanonicalPath().startsWith(cfCacheDirAbsPath);
        }
        catch (IOException e) {
            return f.getAbsolutePath().startsWith(cfCacheDirAbsPath);
        }
    }

    static {
        timer = new Timer();
        cfCacheDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory());
        try {
            cfCacheDirAbsPath = cfCacheDir.getCanonicalPath();
        }
        catch (IOException e) {
            cfCacheDirAbsPath = cfCacheDir.getAbsolutePath();
        }
    }

    protected class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }

        public void recycle() {
            this.start = 0L;
            this.end = 0L;
            this.length = 0L;
        }
    }

    public static class JRTypeSniffer {
        public static boolean isGIF(byte[] data) {
            if (data.length < 3) {
                return false;
            }
            byte[] first = new byte[3];
            System.arraycopy(data, 0, first, 0, 3);
            return new String(first).equalsIgnoreCase("GIF");
        }

        public static boolean isJPEG(byte[] data) {
            if (data.length < 2) {
                return false;
            }
            return data[0] == -1 && data[1] == -40;
        }

        public static boolean isPNG(byte[] data) {
            if (data.length < 8) {
                return false;
            }
            return data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71 && data[4] == 13 && data[5] == 10 && data[6] == 26 && data[7] == 10;
        }

        public static boolean isTIFF(byte[] data) {
            if (data.length < 2) {
                return false;
            }
            return data[0] == 73 && data[1] == 73 || data[0] == 77 && data[1] == 77;
        }

        public static byte getImageType(byte[] data) {
            if (JRTypeSniffer.isGIF(data)) {
                return 1;
            }
            if (JRTypeSniffer.isJPEG(data)) {
                return 2;
            }
            if (JRTypeSniffer.isPNG(data)) {
                return 3;
            }
            if (JRTypeSniffer.isTIFF(data)) {
                return 4;
            }
            return 0;
        }

        public static String getImageMimeType(byte imageType) {
            String mimeType = null;
            switch (imageType) {
                case 1: {
                    mimeType = "image/gif";
                    break;
                }
                case 2: {
                    mimeType = "image/jpeg";
                    break;
                }
                case 3: {
                    mimeType = "image/png";
                    break;
                }
                case 4: {
                    mimeType = "image/tiff";
                    break;
                }
            }
            return mimeType;
        }
    }

    public static interface JRRenderable
    extends Serializable {
        public static final byte TYPE_IMAGE = 0;
        public static final byte TYPE_SVG = 1;
        public static final byte IMAGE_TYPE_UNKNOWN = 0;
        public static final byte IMAGE_TYPE_GIF = 1;
        public static final byte IMAGE_TYPE_JPEG = 2;
        public static final byte IMAGE_TYPE_PNG = 3;
        public static final byte IMAGE_TYPE_TIFF = 4;
        public static final String MIME_TYPE_GIF = "image/gif";
        public static final String MIME_TYPE_JPEG = "image/jpeg";
        public static final String MIME_TYPE_PNG = "image/png";
        public static final String MIME_TYPE_TIFF = "image/tiff";

        public String getId();

        public byte getType();

        public byte getImageType();
    }
}

