/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.CloneableMap;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.util.CaseInsensitiveMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CaseSensitiveMap
implements CloneableMap,
Serializable {
    protected Map<String, Object> map;
    protected MemoryTrackerProxy mtProxy;
    private Set keySet;
    private Set scopeSet;

    public CaseSensitiveMap() {
        this.map = new HashMap<String, Object>();
    }

    public CaseSensitiveMap(int capacity) {
        this.map = new HashMap<String, Object>(capacity);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key.toString());
    }

    @Override
    public boolean containsValue(Object obj) {
        return this.map.containsValue(obj.toString());
    }

    public Object get(Object key) {
        return this.map.get(key.toString());
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            key = "null";
        }
        return this.map.put(key.toString(), value);
    }

    public Object put(String key, Object value) {
        Object oldVal = this.map.put(key, value);
        if (this.mtProxy != null) {
            this.mtProxy.onPut(key, value, oldVal, oldVal != null);
        }
        return oldVal;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Object remove(Object key) {
        return this.map.remove(key.toString());
    }

    public Object remove(String key) {
        Object old = this.map.remove(key);
        if (this.mtProxy != null) {
            this.mtProxy.onRemove(key, old, old != null);
        }
        return old;
    }

    public void putAll(Map t) {
        for (String key : t.keySet()) {
            this.put(key, t.get(key));
        }
    }

    @Override
    public Map duplicate() throws IllegalAccessException {
        return this.duplicate(null);
    }

    public Map duplicate(IdentityHashMap refCache) throws IllegalAccessException {
        CaseSensitiveMap result = new CaseSensitiveMap(this.size());
        if (null == refCache) {
            refCache = new IdentityHashMap<CaseSensitiveMap, CaseSensitiveMap>();
        }
        refCache.put(this, result);
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            result.put(entry.getKey(), ObjectDuplicator.duplicate(entry.getValue(), refCache));
        }
        return result;
    }

    @Override
    public void clear() {
        this.map.clear();
        if (this.mtProxy != null) {
            this.mtProxy.resetMemory();
        }
    }

    public Set entrySet() {
        if (null == this.scopeSet) {
            this.scopeSet = new ScopeSet();
        }
        return this.scopeSet;
    }

    public Set keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        return this.map.values();
    }

    @Override
    public Object clone() {
        return this.clone();
    }

    public CaseSensitiveMap(boolean concurrent) {
        this.map = concurrent ? new CaseInsensitiveMap.CFConcurrentHashMap() : new HashMap();
    }

    public CaseSensitiveMap(boolean concurrent, int capacity) {
        this.map = concurrent ? new CaseInsensitiveMap.CFConcurrentHashMap(capacity) : new HashMap(capacity);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('{');
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (out.length() > 1) {
                out.append(',');
            }
            out.append(entry.getKey());
            out.append("={");
            out.append(String.valueOf(entry.getValue()));
            out.append('}');
        }
        out.append('}');
        return out.toString();
    }

    private class ScopeSet
    extends AbstractSet {
        private ScopeSet() {
        }

        @Override
        public Iterator iterator() {
            return new ScopeIterator(CaseSensitiveMap.this.map);
        }

        @Override
        public int size() {
            return CaseSensitiveMap.this.size();
        }

        @Override
        public void clear() {
            CaseSensitiveMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new FastHashKeyEnumerator(CaseSensitiveMap.this.map);
        }

        @Override
        public int size() {
            return CaseSensitiveMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return CaseSensitiveMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CaseSensitiveMap.this.remove(o) != null;
        }
    }

    static class FastHashKeyEnumerator
    implements Enumeration,
    Iterator {
        private int index = 0;
        private String[] keys;
        private Map map;

        public FastHashKeyEnumerator(Map<String, Object> map) {
            this.map = map;
            this.keys = map.keySet().toArray(new String[map.size()]);
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public Object next() {
            if (this.index < this.keys.length) {
                return this.keys[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keys.length;
        }

        @Override
        public void remove() {
            if (this.index == 0 || this.index > this.keys.length) {
                throw new IllegalStateException();
            }
            this.map.remove(this.keys[this.index - 1]);
        }
    }

    static class ScopeIterator
    implements Iterator {
        private Map<String, Object> map;
        private int index;
        private String[] keys;

        ScopeIterator(Map<String, Object> map) {
            this.map = map;
            this.keys = map.keySet().toArray(new String[map.size()]);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keys.length;
        }

        public Object next() {
            if (this.hasNext()) {
                String key = this.keys[this.index++];
                return new ScopeEntry(key, this.map.get(key));
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.index == 0 || this.index > this.keys.length) {
                throw new IllegalStateException();
            }
            this.map.remove(this.keys[this.index - 1]);
        }

        private class ScopeEntry
        implements Map.Entry {
            private String key;
            private Object value;

            ScopeEntry(String key, Object value) {
                this.key = key;
                this.value = value;
            }

            public Object getValue() {
                return this.value;
            }

            public Object setValue(Object value) {
                return ScopeIterator.this.map.put(this.key, value);
            }

            public Object getKey() {
                return this.key;
            }

            public String toString() {
                return "{ " + this.key + " = " + "{" + this.value.toString() + "}}";
            }

            @Override
            public boolean equals(Object o) {
                Object v2;
                Object v1;
                Object k2;
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object k1 = this.getKey();
                return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2) || k1 instanceof String && k2 instanceof String && k1.toString().equalsIgnoreCase(k2.toString())) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2) || v1 instanceof String && v2 instanceof String && v1.toString().equalsIgnoreCase(v2.toString()));
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ (null == this.value ? 0 : (this.value instanceof String ? this.value.toString().toLowerCase().hashCode() : this.value.hashCode()));
            }
        }
    }
}

