/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.CFDateTimeParser;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.DateInvalidArgumentException;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.IllegalDateArgumentException;
import coldfusion.runtime.IllegalDateFormatException;
import coldfusion.runtime.IllegalNumRangeException;
import coldfusion.runtime.MonthInvalidArgumentException;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UTCOleDateTime;
import coldfusion.runtime.locale.CFLocale;
import coldfusion.runtime.locale.CFLocaleBase;
import coldfusion.runtime.locale.CFLocaleDateFormatException;
import coldfusion.runtime.locale.CFLocaleMgr;
import coldfusion.runtime.locale.CFLocaleMgrException;
import coldfusion.runtime.locale.CFLocaleTimeFormatException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RuntimeWrapper;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateUtils {
    public static final String ALLOWED_DATE_TIME = "'\"kKfFeEwWnNHMSLTzZXhmslt: dDmMyYgG-/";
    public static final String ALLOWED_DATE = "'\"kKfFeEwWhHmMsSdDmMyYgGzzZX-/ ";
    public static final String ALLOWED_TIME = "'\"kKfFeEwWnNHMSLTzZXhmslt: dDmMyYgG-/";
    public static final boolean IS_ENGLISH_DEFAULT_LOCALE = Locale.ENGLISH.getLanguage().equals(Locale.getDefault().getLanguage());
    private static final String[] AMPM = new String[]{"A", "P"};
    private static final boolean COLDFUSION_DATE_FORMAT_LENIENT = Boolean.valueOf(System.getProperty("coldfusion.dateformat.lenient", "false"));
    private static ThreadLocal<Calendar> calendarTL = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(COLDFUSION_DATE_FORMAT_LENIENT);
            return calendar;
        }
    };
    private static ThreadLocal<Calendar> UTCcalendarTL = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.setLenient(false);
            return calendar;
        }
    };
    private static boolean treatCapitalDAsDayOfMonth = Boolean.getBoolean("coldfusion.datemask.useDasdayofmonth");

    private static Calendar getCalendar() {
        Calendar calendar = calendarTL.get();
        return DateUtils.updateTimeZone(calendar);
    }

    public static Calendar updateTimeZone(Calendar calendar) {
        TimeZone newTimeZone;
        FusionContext fContext = FusionContext.getCurrent();
        TimeZone timeZone = newTimeZone = fContext != null && (newTimeZone = fContext.getTimezone()) != null ? newTimeZone : TimeZone.getDefault();
        if (!newTimeZone.equals(calendar.getTimeZone())) {
            calendar.setTimeZone(newTimeZone);
        }
        return calendar;
    }

    public static ZoneId getZoneId() {
        TimeZone newTimeZone;
        FusionContext fContext = FusionContext.getCurrent();
        newTimeZone = fContext != null && (newTimeZone = fContext.getTimezone()) != null ? newTimeZone : TimeZone.getDefault();
        return newTimeZone.toZoneId();
    }

    public static Calendar getCalendar(Date d) {
        Calendar calendar = null;
        calendar = d instanceof UTCOleDateTime ? UTCcalendarTL.get() : DateUtils.getCalendar();
        calendar.setTime(d);
        return calendar;
    }

    public static Calendar getUTCCalendar() {
        return UTCcalendarTL.get();
    }

    public static Calendar getDefaultCalendar() {
        return DateUtils.getCalendar();
    }

    public static int getDatePart(String datepart, Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        if ("m".equalsIgnoreCase(datepart)) {
            return 1 + calendar.get(2);
        }
        if ("q".equalsIgnoreCase(datepart)) {
            return 1 + calendar.get(2) / 3;
        }
        if ("ww".equalsIgnoreCase(datepart)) {
            return DateUtils.getWeekOfYear(date, null);
        }
        return calendar.get(DateUtils.getDatePart(datepart));
    }

    public static int getWeekOfYear(Date date, String mask) {
        Calendar calendar = Calendar.getInstance(Locale.US);
        if (mask != null) {
            if (mask.toLowerCase().equals("iso")) {
                calendar.setMinimalDaysInFirstWeek(4);
                calendar.setFirstDayOfWeek(2);
                calendar.setTime(date);
                return calendar.get(3);
            }
            if (mask.toLowerCase().equalsIgnoreCase("gregorian")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
                gregorianCalendar.setFirstDayOfWeek(1);
                gregorianCalendar.setTime(date);
                return gregorianCalendar.get(3);
            }
        }
        calendar.setLenient(false);
        calendar.setTime(date);
        int dayofweek = calendar.get(7);
        int dayofmonth = calendar.get(5);
        int year = calendar.get(1);
        int weekofyear = calendar.get(3);
        if (calendar.get(2) == 11 && dayofmonth >= 26) {
            if (DateUtils.isLeapYear(year)) {
                if (dayofmonth == 26 && 1 <= dayofweek && dayofweek <= 3) {
                    weekofyear = 53;
                }
                if (dayofmonth == 27 && 1 <= dayofweek && dayofweek <= 4) {
                    weekofyear = 53;
                }
                if (dayofmonth == 28 && 1 <= dayofweek && dayofweek <= 5) {
                    weekofyear = 53;
                } else if (dayofmonth == 29 && 1 <= dayofweek && dayofweek <= 6) {
                    weekofyear = 53;
                } else if (dayofmonth == 30) {
                    weekofyear = 53;
                } else if (dayofmonth == 31) {
                    weekofyear = dayofweek == 1 ? 54 : 53;
                }
            } else if (dayofmonth == 26 && 1 <= dayofweek && dayofweek <= 2) {
                weekofyear = 53;
            } else if (dayofmonth == 27 && 1 <= dayofweek && dayofweek <= 3) {
                weekofyear = 53;
            } else if (dayofmonth == 28 && 1 <= dayofweek && dayofweek <= 4) {
                weekofyear = 53;
            } else if (dayofmonth == 29 && 1 <= dayofweek && dayofweek <= 5) {
                weekofyear = 53;
            } else if (dayofmonth == 30 && 1 <= dayofweek && dayofweek <= 6) {
                weekofyear = 53;
            } else if (dayofmonth == 31) {
                weekofyear = 53;
            }
        }
        return weekofyear;
    }

    private static int getDatePart(String datepart) throws IllegalDateArgumentException {
        if ("yyyy".equalsIgnoreCase(datepart)) {
            return 1;
        }
        if ("m".equalsIgnoreCase(datepart)) {
            return 2;
        }
        if ("y".equalsIgnoreCase(datepart)) {
            return 6;
        }
        if ("d".equalsIgnoreCase(datepart)) {
            return 5;
        }
        if ("w".equalsIgnoreCase(datepart)) {
            return 7;
        }
        if ("ww".equalsIgnoreCase(datepart)) {
            return 3;
        }
        if ("h".equalsIgnoreCase(datepart)) {
            return 11;
        }
        if ("n".equalsIgnoreCase(datepart)) {
            return 12;
        }
        if ("s".equalsIgnoreCase(datepart)) {
            return 13;
        }
        if ("l".equalsIgnoreCase(datepart)) {
            return 14;
        }
        throw new IllegalDateArgumentException(datepart);
    }

    public static OleDateTime addDate(String datepart, String units, Date date) throws NumberFormatException {
        int intunits = Cast._int(units);
        return DateUtils.addDate(datepart, intunits, date);
    }

    public static OleDateTime addDate(String datepart, int intunits, Date date) throws NumberFormatException {
        Calendar calendar = DateUtils.getCalendar(date);
        if ("q".equalsIgnoreCase(datepart)) {
            calendar.add(2, 3 * intunits);
        } else if ("w".equalsIgnoreCase(datepart)) {
            int offset;
            int dayOfWeek = calendar.get(7);
            if (intunits >= 0) {
                offset = dayOfWeek - 2;
                if (offset >= 5) {
                    offset -= 7;
                }
            } else {
                offset = -(6 - dayOfWeek);
                if (offset <= -5) {
                    offset += 7;
                }
            }
            calendar.add(7, -offset);
            if (dayOfWeek == 7 || dayOfWeek == 1) {
                offset = 0;
                if (intunits > 0) {
                    --intunits;
                }
                if (intunits < 0) {
                    ++intunits;
                }
            }
            calendar.add(7, (intunits += offset) / 5 * 7 + intunits % 5);
        } else {
            calendar.add(DateUtils.getDatePart(datepart), intunits);
        }
        if (date instanceof UTCOleDateTime) {
            return new UTCOleDateTime(calendar.getTime());
        }
        return new OleDateTime(calendar.getTime());
    }

    public static OleDateTime convertDate(String conversionType, Date date) {
        Calendar c = DateUtils.getCalendar(date);
        if (conversionType.equalsIgnoreCase("local2utc")) {
            return new UTCOleDateTime(c.getTime());
        }
        if (conversionType.equalsIgnoreCase("utc2local")) {
            Calendar utcCal = DateUtils.getUTCCalendar();
            if (date instanceof UTCOleDateTime) {
                utcCal.setTime(date);
                return new OleDateTime(utcCal.getTime());
            }
            utcCal.clear();
            utcCal.set(c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13));
            utcCal.set(14, c.get(14));
            c.setTime(utcCal.getTime());
            return new OleDateTime(c.getTime());
        }
        throw new InvalidDateConversionTypeException(conversionType);
    }

    public static int compareDate(Date date1, Date date2) {
        return DateUtils.compareDate(date1, date2, "s");
    }

    public static int compareDate(Date date1, Date date2, String part) throws IllegalDateArgumentException {
        if (part.equalsIgnoreCase("yyyy")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            if (y1 > y2) {
                return 1;
            }
            if (y1 < y2) {
                return -1;
            }
            return 0;
        }
        if (part.equalsIgnoreCase("m")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2);
            if (y2 == y1) {
                if (m1 > m2) {
                    return 1;
                }
                if (m1 < m2) {
                    return -1;
                }
                return 0;
            }
            return DateUtils.compareDate(date1, date2, "yyyy");
        }
        if (part.equalsIgnoreCase("d")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            int d1 = calendar.get(5);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2);
            int d2 = calendar.get(5);
            if (y2 == y1 && m2 == m1) {
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
            if (y2 != y1) {
                return DateUtils.compareDate(date1, date2, "yyyy");
            }
            return DateUtils.compareDate(date1, date2, "m");
        }
        if (part.equalsIgnoreCase("h")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            int d1 = calendar.get(5);
            int h1 = calendar.get(11);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2);
            int d2 = calendar.get(5);
            int h2 = calendar.get(11);
            if (y2 == y1 && m2 == m1 && d2 == d1) {
                if (h1 > h2) {
                    return 1;
                }
                if (h1 < h2) {
                    return -1;
                }
                return 0;
            }
            if (y2 != y1) {
                return DateUtils.compareDate(date1, date2, "yyyy");
            }
            if (m2 != m1) {
                return DateUtils.compareDate(date1, date2, "m");
            }
            return DateUtils.compareDate(date1, date2, "d");
        }
        if (part.equalsIgnoreCase("n")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            int d1 = calendar.get(5);
            int h1 = calendar.get(11);
            int n1 = calendar.get(12);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2);
            int d2 = calendar.get(5);
            int h2 = calendar.get(11);
            int n2 = calendar.get(12);
            if (y2 == y1 && m2 == m1 && d2 == d1 && h2 == h1) {
                if (n1 > n2) {
                    return 1;
                }
                if (n1 < n2) {
                    return -1;
                }
                return 0;
            }
            if (y2 != y1) {
                return DateUtils.compareDate(date1, date2, "yyyy");
            }
            if (m2 != m1) {
                return DateUtils.compareDate(date1, date2, "m");
            }
            if (d2 != d1) {
                return DateUtils.compareDate(date1, date2, "d");
            }
            return DateUtils.compareDate(date1, date2, "h");
        }
        if (part.equalsIgnoreCase("s")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            int d1 = calendar.get(5);
            int h1 = calendar.get(11);
            int n1 = calendar.get(12);
            int s1 = calendar.get(13);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2);
            int d2 = calendar.get(5);
            int h2 = calendar.get(11);
            int n2 = calendar.get(12);
            int s2 = calendar.get(13);
            if (y2 == y1 && m2 == m1 && d2 == d1 && h2 == h1 && n2 == n1) {
                if (s1 > s2) {
                    return 1;
                }
                if (s1 < s2) {
                    return -1;
                }
                return 0;
            }
            if (y2 != y1) {
                return DateUtils.compareDate(date1, date2, "yyyy");
            }
            if (m2 != m1) {
                return DateUtils.compareDate(date1, date2, "m");
            }
            if (d2 != d1) {
                return DateUtils.compareDate(date1, date2, "d");
            }
            if (h2 != h1) {
                return DateUtils.compareDate(date1, date2, "h");
            }
            return DateUtils.compareDate(date1, date2, "n");
        }
        if (part.equalsIgnoreCase("l")) {
            Calendar calendar = DateUtils.getCalendar(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            int d1 = calendar.get(5);
            int h1 = calendar.get(11);
            int n1 = calendar.get(12);
            int s1 = calendar.get(13);
            int l1 = calendar.get(14);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2);
            int d2 = calendar.get(5);
            int h2 = calendar.get(11);
            int n2 = calendar.get(12);
            int s2 = calendar.get(13);
            int l2 = calendar.get(14);
            if (y1 != y2) {
                return DateUtils.compareDate(date1, date2, "yyyy");
            }
            if (m1 != m2) {
                return DateUtils.compareDate(date1, date2, "m");
            }
            if (d1 != d2) {
                return DateUtils.compareDate(date1, date2, "d");
            }
            if (h1 != h2) {
                return DateUtils.compareDate(date1, date2, "h");
            }
            if (n1 != n2) {
                return DateUtils.compareDate(date1, date2, "n");
            }
            if (s1 != s2) {
                return DateUtils.compareDate(date1, date2, "s");
            }
            return Integer.compare(l1, l2);
        }
        throw new IllegalDateArgumentException(part);
    }

    private static long getWorkingDaysDiff(Date d1, Date d2) {
        boolean bSwitched = false;
        if (d1.after(d2)) {
            Date tempDate = d1;
            d1 = d2;
            d2 = tempDate;
            bSwitched = true;
        }
        long workingdaysdiff = 0L;
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setFirstDayOfWeek(1);
        c2.setFirstDayOfWeek(1);
        c1.setTime(d1);
        c2.setTime(d2);
        int dw1 = c1.get(7);
        int dw2 = c2.get(7);
        if (dw1 == 7) {
            dw1 = 6;
            c1.add(5, -1);
        } else if (dw1 == 1) {
            dw1 = 6;
            c1.add(5, -2);
        }
        if (dw2 == 7) {
            dw2 = 6;
            c2.add(5, -1);
        } else if (dw2 == 1) {
            dw2 = 6;
            c2.add(5, -2);
        }
        int offset1 = dw1 - 2;
        int offset2 = dw2 - 2;
        c1.add(5, -offset1);
        c2.add(5, -offset2);
        long weeksdiff = DateUtils.getDateDiff("ww", c1.getTime(), c2.getTime());
        long daysdiff = DateUtils.getDateDiff("d", c1.getTime(), c2.getTime());
        workingdaysdiff = daysdiff - 2L * weeksdiff;
        workingdaysdiff = workingdaysdiff + (long)offset2 - (long)offset1;
        if (bSwitched) {
            workingdaysdiff *= -1L;
        }
        return workingdaysdiff;
    }

    public static long getDateDiff(String datepart, Date date1, Date date2) throws IllegalDateArgumentException {
        if (date1.equals(date2)) {
            return 0L;
        }
        long l1 = date1.getTime();
        long l2 = date2.getTime();
        if (!(datepart.equalsIgnoreCase("s") || datepart.equalsIgnoreCase("n") || datepart.equalsIgnoreCase("h") || datepart.equalsIgnoreCase("l"))) {
            TimeZone zone = FusionContext.getCurrent().getTimezone();
            if (zone == null) {
                zone = TimeZone.getDefault();
            }
            GregorianCalendar g = new GregorianCalendar(zone);
            g.setTime(date1);
            l1 += (long)g.get(16);
            g.setTime(date2);
            l2 += (long)g.get(16);
        }
        long millisbetween = l2 - l1;
        long secsbetween = millisbetween / 1000L;
        long minsbetween = secsbetween / 60L;
        long hoursbetween = minsbetween / 60L;
        long daysbetween = hoursbetween / 24L;
        long weeksbetween = daysbetween / 7L;
        long monthsbetween = 0L;
        long yearsbetween = 0L;
        long quartersbetween = 0L;
        if (datepart.equalsIgnoreCase("yyyy") || datepart.equalsIgnoreCase("m") || datepart.equalsIgnoreCase("q")) {
            monthsbetween = DateUtils.MonthDiff(date1, date2);
            yearsbetween = monthsbetween / 12L;
            quartersbetween = monthsbetween / 3L;
        }
        if (datepart.equalsIgnoreCase("l")) {
            return millisbetween;
        }
        if (datepart.equalsIgnoreCase("s")) {
            return secsbetween;
        }
        if (datepart.equalsIgnoreCase("n")) {
            return minsbetween;
        }
        if (datepart.equalsIgnoreCase("h")) {
            return hoursbetween;
        }
        if (datepart.equalsIgnoreCase("d") || datepart.equalsIgnoreCase("y")) {
            return daysbetween;
        }
        if (datepart.equalsIgnoreCase("ww")) {
            return weeksbetween;
        }
        if (datepart.equalsIgnoreCase("w")) {
            return DateUtils.getWorkingDaysDiff(date1, date2);
        }
        if (datepart.equalsIgnoreCase("yyyy")) {
            return yearsbetween;
        }
        if (datepart.equalsIgnoreCase("m")) {
            return monthsbetween;
        }
        if (datepart.equalsIgnoreCase("q")) {
            return quartersbetween;
        }
        throw new IllegalDateArgumentException(datepart);
    }

    private static long MonthDiff(Date date1, Date date2) {
        boolean bSwitched = false;
        if (date1.after(date2)) {
            Date tempDate = date1;
            date1 = date2;
            date2 = tempDate;
            bSwitched = true;
        }
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        FusionContext fContext = FusionContext.getCurrent();
        TimeZone tz = null;
        if (fContext != null && (tz = fContext.getTimezone()) != null) {
            cal1.setTimeZone(tz);
            cal2.setTimeZone(tz);
        }
        cal1.setTime(date1);
        cal2.setTime(date2);
        long lMonthDiff = 0L;
        long lYearDiff = cal2.get(1) - cal1.get(1);
        int year2 = cal2.get(1);
        int month1 = cal1.get(2);
        int month2 = cal2.get(2);
        int day1 = cal1.get(5);
        int day2 = cal2.get(5);
        if (lYearDiff > 0L) {
            if (month1 > month2) {
                --lYearDiff;
            }
            lMonthDiff += lYearDiff * 12L;
        }
        lMonthDiff = month1 > month2 ? (lMonthDiff += (long)(12 + month2 - month1)) : (lMonthDiff += (long)(month2 - month1));
        if (day1 > day2 && !DateUtils.isDateEndOfMonth(cal2)) {
            --lMonthDiff;
        }
        if (day1 == day2) {
            GregorianCalendar cal3 = new GregorianCalendar(year2, month2, day2, cal1.get(11), cal1.get(12), cal1.get(13));
            if (tz != null) {
                ((Calendar)cal3).setTimeZone(tz);
            }
            if (cal3.getTime().compareTo(cal2.getTime()) > 0 && lMonthDiff > 0L) {
                --lMonthDiff;
            }
        }
        return bSwitched ? -lMonthDiff : lMonthDiff;
    }

    private static boolean isDateEndOfMonth(Calendar cal) {
        int x = cal.getActualMaximum(5);
        return cal.get(5) == x;
    }

    public static String getEscapedMask(String allowedChars, String mask) {
        StringBuilder newMaskSb = new StringBuilder();
        boolean bOpenQuote = false;
        boolean openInMask = false;
        for (int x = 0; x < mask.length(); ++x) {
            char c = mask.charAt(x);
            if (!bOpenQuote) {
                if (c == '\'') {
                    newMaskSb.append(c);
                    bOpenQuote = true;
                    openInMask = true;
                    continue;
                }
                if (allowedChars.indexOf(c) < 0) {
                    if (x + 1 < mask.length() && allowedChars.indexOf(mask.charAt(x + 1)) < 0) {
                        newMaskSb.append('\'');
                        newMaskSb.append(c);
                        bOpenQuote = true;
                        continue;
                    }
                    newMaskSb.append('\'');
                    newMaskSb.append(c);
                    newMaskSb.append('\'');
                    continue;
                }
                newMaskSb.append(c);
                continue;
            }
            newMaskSb.append(c);
            if (c == '\'') {
                bOpenQuote = false;
                openInMask = false;
                continue;
            }
            if (x + 1 >= mask.length() || allowedChars.indexOf(mask.charAt(x + 1)) < 0 || openInMask) continue;
            newMaskSb.append('\'');
            bOpenQuote = false;
        }
        if (bOpenQuote) {
            newMaskSb.append('\'');
        }
        return newMaskSb.toString();
    }

    public static SimpleDateFormat getCFDateTimeFormat(String mask, Locale locale, String allowedChars) {
        mask = DateUtils.getEscapedMask(allowedChars, mask);
        String maskLcase = mask.toLowerCase();
        SimpleDateFormat sdf = null;
        if (maskLcase.indexOf(116) > -1 && maskLcase.indexOf("tt") == -1) {
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            dfs.setAmPmStrings(AMPM);
            sdf = new SimpleDateFormat(DateUtils.replaceCharsOnDateTimeMask(mask), dfs);
        } else {
            sdf = new SimpleDateFormat(DateUtils.replaceCharsOnDateTimeMask(mask), locale);
        }
        sdf.setCalendar(DateUtils.getDefaultCalendar());
        return sdf;
    }

    public static String replace_ddd(String mask) {
        String maskLcase = mask.toLowerCase();
        int len = mask.length();
        StringBuilder newMaskSb = new StringBuilder(mask);
        boolean withinQuote = false;
        for (int i = 0; i < len - 2; ++i) {
            char c = maskLcase.charAt(i);
            if (c == '\'') {
                if (withinQuote) {
                    withinQuote = false;
                    continue;
                }
                withinQuote = true;
                continue;
            }
            if (withinQuote || maskLcase.charAt(i) != 'd' || maskLcase.charAt(i + 1) != 'd' || maskLcase.charAt(i + 2) != 'd') continue;
            newMaskSb.setCharAt(i, 'E');
            newMaskSb.setCharAt(i + 1, 'E');
            newMaskSb.setCharAt(i + 2, 'E');
        }
        return newMaskSb.toString();
    }

    public static String replaceCharsOnDateTimeMask(String mask) {
        char[] buff = mask.toCharArray();
        DateUtils.replaceCharsOnTimeMask(mask, buff, false);
        DateUtils.replaceCharsOnDateMask(mask, buff);
        return DateUtils.createMask(buff);
    }

    public static String replaceCharsOnDateMask(String mask) {
        char[] buff = mask.toCharArray();
        DateUtils.replaceCharsOnDateMask(mask, buff);
        return DateUtils.createMask(buff);
    }

    public static String replaceCharsOnTimeMask(String mask) {
        char[] buff = mask.toCharArray();
        DateUtils.replaceCharsOnTimeMask(mask, buff, true);
        return DateUtils.createMask(buff);
    }

    private static void replaceCharsOnDateMask(String mask, char[] buff) {
        boolean withinQuote = false;
        for (int i = 0; i < buff.length; ++i) {
            char c = mask.charAt(i);
            if (c == '\'') {
                boolean bl = withinQuote = !withinQuote;
            }
            if (withinQuote) continue;
            if (c == 'M' || c == 'm') {
                buff[i] = 77;
                continue;
            }
            if (c == 'D' && treatCapitalDAsDayOfMonth) {
                buff[i] = 100;
                continue;
            }
            if (c == 'g') {
                buff[i] = 71;
                continue;
            }
            if (c == 'Y') {
                buff[i] = 121;
                continue;
            }
            if (c == 'e') {
                buff[i] = 69;
                continue;
            }
            if (c != 'f') continue;
            buff[i] = 70;
        }
    }

    private static void replaceCharsOnTimeMask(String mask, char[] buff, boolean maintainOldBehaviour) {
        boolean withinQuote = false;
        for (int i = 0; i < buff.length; ++i) {
            char c = mask.charAt(i);
            if (c == '\'') {
                boolean bl = withinQuote = !withinQuote;
            }
            if (withinQuote) continue;
            if (maintainOldBehaviour && c == 'M' || c == 'n' || c == 'N') {
                buff[i] = 109;
                continue;
            }
            if (c == 'S') {
                buff[i] = 115;
                continue;
            }
            if (c == 'L' || c == 'l') {
                buff[i] = 83;
                continue;
            }
            if (c == 't' || c == 'T') {
                buff[i] = 97;
                continue;
            }
            if (c == 'e') {
                buff[i] = 69;
                continue;
            }
            if (c == 'f') {
                buff[i] = 70;
                continue;
            }
            if (c != 'g') continue;
            buff[i] = 71;
        }
    }

    private static String createMask(char[] buff) {
        String newMask = new String(buff, 0, buff.length);
        newMask = DateUtils.replace_ddd(newMask);
        return newMask;
    }

    public static boolean isLeapYear(int year) {
        boolean isLeap;
        boolean bl = isLeap = year % 4 == 0;
        if (isLeap && year >= 1582 && year % 400 != 0 && year % 100 == 0) {
            isLeap = false;
        }
        return isLeap;
    }

    public static boolean isDateObject(Object object) {
        return object instanceof Date;
    }

    public static boolean isDate(Object o) {
        if (o instanceof Date) {
            return true;
        }
        return o instanceof String && DateUtils._parseDateTime(((String)o).trim()) != null;
    }

    public static double getNumericDate(String date) {
        return Cast._double((OleDateTime)DateUtils.parseDateTime(date));
    }

    public static Date parseDateTime(String date) {
        Date d = DateUtils._parseDateTime(date.trim());
        if (d == null) {
            throw new IllegalDateArgumentException(date);
        }
        return d;
    }

    public static Date _parseDateTime(String date) {
        OleDateTime d = CFDateTimeParser.parseDateTime(date.trim());
        if (d == null && !IS_ENGLISH_DEFAULT_LOCALE) {
            try {
                return DateUtils.parseDateTime(date, Locale.getDefault());
            }
            catch (RuntimeWrapper runtimeWrapper) {
                // empty catch block
            }
        }
        return d;
    }

    public static Date parseDateTime(String date, String style) {
        if ((style = style.trim()).equals("") || style.equalsIgnoreCase("STANDARD")) {
            return DateUtils.parseDateTime(date);
        }
        date = date.trim();
        String styleOrig = style;
        try {
            if (styleOrig.equalsIgnoreCase("POP")) {
                Date d = ServiceFactory.getMailSpoolService().getMailDateFormat(date);
                if (d != null) {
                    return DateUtils.convertDate("local2utc", d);
                }
            } else {
                SimpleDateFormat dateFormat;
                String styleLcase = (style = DateUtils.getEscapedMask("'\"kKfFeEwWnNHMSLTzZXhmslt: dDmMyYgG-/", style)).toLowerCase();
                if (styleLcase.indexOf(116) > -1 && styleLcase.indexOf("tt") == -1) {
                    DateFormatSymbols dfs = new DateFormatSymbols();
                    dfs.setAmPmStrings(AMPM);
                    dateFormat = new SimpleDateFormat(DateUtils.replaceCharsOnDateTimeMask(style), dfs);
                } else {
                    dateFormat = new SimpleDateFormat(DateUtils.replaceCharsOnDateTimeMask(style));
                }
                Date d = dateFormat.parse(date);
                if (d != null) {
                    return d;
                }
            }
            throw new IllegalDateArgumentException(date);
        }
        catch (ParseException e) {
            throw new IllegalDateArgumentException(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalDateFormatException(styleOrig);
        }
    }

    public static OleDateTime parseDateTime(String date, Locale locale) {
        try {
            CFLocaleMgr cfLocaleMgr = CFLocaleMgr.getMgr();
            if (locale == null) {
                locale = cfLocaleMgr.getDefaultCFLocale().GetJavaLocaleObj();
            }
            CFLocale cflocale = cfLocaleMgr.getCFLocale(locale);
            return cflocale.ParseDateTime(date);
        }
        catch (CFLocaleBase.InvalidDateTimeException | CFLocaleMgrException e) {
            throw new RuntimeWrapper(e);
        }
    }

    public static String formatDate(Object date, CFLocale cflocale) {
        if (date == null) {
            return "";
        }
        try {
            if (date instanceof Date) {
                return cflocale.FormatDate((Date)date);
            }
            if (date instanceof String && !CFPage.IsNumeric(date)) {
                if (((String)date).trim().length() == 0) {
                    return "";
                }
                return cflocale.FormatDate(cflocale.ParseDateTime((String)date));
            }
            if (CFPage.IsNumeric(date)) {
                return cflocale.FormatDate(Cast._Date(date));
            }
            throw new CFLocaleDateFormatException(Cast._String(date));
        }
        catch (Exception e) {
            throw new CFLocaleDateFormatException(Cast._String(date));
        }
    }

    public static String formatDate(Object date, CFLocale cflocale, String mask) {
        if (date == null) {
            return "";
        }
        try {
            if (date instanceof Date) {
                return cflocale.FormatDate((Date)date, mask);
            }
            boolean isNumeric = CFPage.IsNumeric(date);
            if (date instanceof String && !isNumeric) {
                if (((String)date).trim().length() == 0) {
                    return "";
                }
                Date parseDateTime = null;
                try {
                    parseDateTime = cflocale.ParseDateTime((String)date);
                }
                catch (CFLocaleBase.InvalidDateTimeException e) {
                    try {
                        parseDateTime = Cast._Date(date);
                    }
                    catch (Cast.DateConversionException dateconvex) {
                        throw e;
                    }
                }
                return cflocale.FormatDate(parseDateTime, mask);
            }
            if (isNumeric) {
                return cflocale.FormatDate(Cast._Date(date), mask);
            }
            throw new CFLocaleDateFormatException(Cast._String(date));
        }
        catch (CFLocaleBase.InvalidTimezoneException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CFLocaleDateFormatException(Cast._String(date));
        }
    }

    public static String formatDateTime(Date date, String mask, CFLocale cflocale, String timezone) {
        Locale locale = cflocale.GetJavaLocaleObj();
        TimeZone tz = null;
        if (timezone != null) {
            if (timezone.trim().equals("")) {
                throw new CFLocaleBase.InvalidTimezoneException(timezone);
            }
            tz = TimeZone.getTimeZone(timezone);
            if (!tz.getID().equalsIgnoreCase(timezone)) {
                throw new CFLocaleBase.InvalidTimezoneException(timezone);
            }
        }
        String maskLcase = mask.toLowerCase();
        DateFormat dateFormat = null;
        if (maskLcase.equals("short")) {
            dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        }
        if (maskLcase.equals("medium")) {
            dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        }
        if (maskLcase.equals("long")) {
            dateFormat = DateFormat.getDateTimeInstance(1, 1, locale);
        }
        if (maskLcase.equals("full")) {
            dateFormat = DateFormat.getDateTimeInstance(0, 0, locale);
        }
        if (maskLcase.equals("iso")) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", locale);
        }
        if (dateFormat != null) {
            if (date instanceof UTCOleDateTime) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else if (tz == null) {
                FusionContext fContext = FusionContext.getCurrent();
                TimeZone appCfcTz = null;
                if (fContext != null && (appCfcTz = fContext.getTimezone()) != null) {
                    dateFormat.setTimeZone(appCfcTz);
                }
            } else if (tz != null) {
                dateFormat.setTimeZone(tz);
            }
            return dateFormat.format(date);
        }
        SimpleDateFormat formatter = DateUtils.getCFDateTimeFormat(mask, locale, "'\"kKfFeEwWnNHMSLTzZXhmslt: dDmMyYgG-/");
        if (tz != null) {
            formatter.setTimeZone(tz);
        } else if (date instanceof UTCOleDateTime) {
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return formatter.format(date);
    }

    public static String formatTime(Object date, CFLocale cflocale) {
        if (date == null) {
            return "";
        }
        try {
            if (date instanceof Date) {
                return cflocale.FormatTime((Date)date);
            }
            boolean isNumeric = CFPage.IsNumeric(date);
            if (date instanceof String && !isNumeric) {
                return cflocale.FormatTime(cflocale.ParseDateTime((String)date));
            }
            if (isNumeric) {
                return cflocale.FormatTime(Cast._Date(date));
            }
            throw new CFLocaleTimeFormatException(date.toString());
        }
        catch (Exception e) {
            throw new CFLocaleTimeFormatException(Cast._String(date));
        }
    }

    public static String formatTime(Object date, String mask, CFLocale cflocale) {
        if (date == null) {
            return "";
        }
        try {
            if (date instanceof Date) {
                return cflocale.FormatTime((Date)date, mask);
            }
            boolean isNumeric = CFPage.IsNumeric(date);
            if (date instanceof String && !isNumeric) {
                return cflocale.FormatTime(cflocale.ParseDateTime((String)date), mask);
            }
            if (isNumeric) {
                return cflocale.FormatTime(Cast._Date(date), mask);
            }
            throw new CFLocaleTimeFormatException(Cast._String(date));
        }
        catch (Exception e) {
            throw new CFLocaleTimeFormatException(Cast._String(date));
        }
    }

    public static Map getTimeZoneInfo() {
        Date date = new Date();
        return DateUtils.getTimeZoneInfo(date);
    }

    public static Map getTimeZoneInfo(Date date) {
        Calendar c = DateUtils.getCalendar();
        c.clear();
        c.setTime(date);
        int sec = c.get(15) / 1000 + c.get(16) / 1000;
        int total_min = (sec *= -1) / 60;
        int hour = sec / 60 / 60;
        int min = total_min % 60;
        String dst_on = "NO";
        if (c.get(16) > 0) {
            dst_on = "YES";
        }
        Integer secOffset = new Integer(sec);
        Integer hourOffset = new Integer(hour);
        Integer minOffset = new Integer(min);
        Struct map_tbl = new Struct();
        map_tbl.put("utcTotalOffset", secOffset);
        map_tbl.put("utcHourOffset", hourOffset);
        map_tbl.put("utcMinuteOffset", minOffset);
        map_tbl.put("isDSTon", dst_on);
        map_tbl.put("timezone", c.getTimeZone().getID());
        map_tbl.put("name", c.getTimeZone().getDisplayName());
        map_tbl.put("nameDST", c.getTimeZone().getDisplayName(true, 1, Locale.getDefault(Locale.Category.DISPLAY)));
        map_tbl.put("shortName", c.getTimeZone().getDisplayName(false, 0, Locale.getDefault(Locale.Category.DISPLAY)));
        map_tbl.put("shortNameDST", c.getTimeZone().getDisplayName(true, 0, Locale.getDefault(Locale.Category.DISPLAY)));
        map_tbl.put("DSTOffset", c.getTimeZone().getDSTSavings());
        return map_tbl;
    }

    public static Map getTimeZoneInfo(String timezone, Locale locale) {
        TimeZone requiredTimeZone;
        Calendar calendar = calendarTL.get();
        calendar.clear();
        Date date = new Date();
        calendar.setTime(date);
        try {
            String reqTimeZone = DateUtils.isValidTimeZone(timezone);
            if (reqTimeZone == null) {
                throw new CFLocaleBase.InvalidTimezoneException(timezone);
            }
            requiredTimeZone = TimeZone.getTimeZone(reqTimeZone);
        }
        catch (DateTimeException e) {
            throw new CFLocaleBase.InvalidTimezoneException(timezone);
        }
        calendar.setTimeZone(requiredTimeZone);
        int sec = calendar.get(15) / 1000 + calendar.get(16) / 1000;
        int totalMin = (sec *= -1) / 60;
        int hour = sec / 3600;
        int min = totalMin % 60;
        boolean dstOn = false;
        if (calendar.get(16) > 0) {
            dstOn = true;
        }
        Integer secOffset = new Integer(sec);
        Integer hourOffset = new Integer(hour);
        Integer minOffset = new Integer(min);
        Struct timeZoneInfoMap = new Struct();
        timeZoneInfoMap.put("utcTotalOffset", secOffset);
        timeZoneInfoMap.put("utcHourOffset", hourOffset);
        timeZoneInfoMap.put("utcMinuteOffset", minOffset);
        timeZoneInfoMap.put("isDSTon", dstOn ? "YES" : "NO");
        timeZoneInfoMap.put("timezone", requiredTimeZone.getID());
        timeZoneInfoMap.put("name", requiredTimeZone.getDisplayName(locale));
        timeZoneInfoMap.put("nameDST", requiredTimeZone.getDisplayName(true, 1, locale));
        timeZoneInfoMap.put("shortName", requiredTimeZone.getDisplayName(false, 0, locale));
        timeZoneInfoMap.put("shortNameDST", requiredTimeZone.getDisplayName(true, 0, locale));
        timeZoneInfoMap.put("DSTOffset", requiredTimeZone.getDSTSavings());
        return timeZoneInfoMap;
    }

    public static String isValidTimeZone(String tz) {
        for (String tzId : TimeZone.getAvailableIDs()) {
            if (!tzId.equalsIgnoreCase(tz)) continue;
            return tzId;
        }
        return null;
    }

    public static String makeDateString(Date adate, Date atime) {
        Object dateTimeStr = "";
        try {
            CFLocale cflocale = CFLocaleMgr.getMgr().getDefaultCFLocale();
            String timeStr = DateUtils.formatTime(atime, cflocale);
            String dateStr = DateUtils.formatDate(adate, cflocale);
            dateTimeStr = dateStr + " " + timeStr;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.debug(e);
        }
        return dateTimeStr;
    }

    public static OleDateTime createDateTimeV2(int year, int month, int day, int hour, int minute, int second) {
        try {
            year = DateUtils.adjustYear(year);
            LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second);
            ZoneId zoneId = DateUtils.getZoneId();
            ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
            Date date = Date.from(zonedDateTime.toInstant());
            return new OleDateTime(date);
        }
        catch (DateTimeException e) {
            if (e.getMessage().contains("Invalid value for HourOfDay") && DateUtils.getZoneId().getRules().isDaylightSavings(LocalDateTime.now().atZone(DateUtils.getZoneId()).toInstant())) {
                StringBuilder buff = new StringBuilder();
                buff.append("{ts '").append(year).append('-').append(month).append('-');
                buff.append(day).append(' ').append(hour).append(':');
                buff.append(minute).append(':').append(second).append(':').append("'}");
                throw new InvalidDateDSTException(hour, buff.toString(), DateUtils.getZoneId().getDisplayName(TextStyle.FULL, Locale.getDefault()), "createDateTime");
            }
            throw new InvalidDateException("createDateTime");
        }
    }

    public static OleDateTime createDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Date date;
        Calendar calendar = DateUtils.getCalendar();
        calendar.clear();
        calendar.set(DateUtils.adjustYear(year), month - 1, day, hour, minute, second);
        calendar.set(14, millisecond);
        try {
            date = calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            if (calendar.getTimeZone().useDaylightTime() && "HOUR_OF_DAY".equals(e.getMessage()) && hour >= 0 && hour < 24) {
                StringBuilder buff = new StringBuilder();
                buff.append("{ts '").append(year).append('-').append(month).append('-');
                buff.append(day).append(' ').append(hour).append(':');
                buff.append(minute).append(':').append(second).append(':');
                buff.append(millisecond).append("'}");
                throw new InvalidDateDSTException(hour, buff.toString(), calendar.getTimeZone().getDisplayName(), "createDateTime");
            }
            throw new InvalidDateException("createDateTime");
        }
        return new OleDateTime(date);
    }

    public static OleDateTime createDateTime(int year, int month, int day, int hour, int minute, int second) {
        Date date;
        Calendar calendar = DateUtils.getCalendar();
        calendar.clear();
        calendar.set(DateUtils.adjustYear(year), month - 1, day, hour, minute, second);
        try {
            date = calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            if (calendar.getTimeZone().useDaylightTime() && "HOUR_OF_DAY".equals(e.getMessage()) && hour >= 0 && hour < 24) {
                StringBuilder buff = new StringBuilder();
                buff.append("{ts '").append(year).append('-').append(month).append('-');
                buff.append(day).append(' ').append(hour).append(':');
                buff.append(minute).append(':').append(second).append("'}");
                throw new InvalidDateDSTException(hour, buff.toString(), calendar.getTimeZone().getDisplayName(), "createDateTime");
            }
            throw new InvalidDateException("createDateTime");
        }
        return new OleDateTime(date);
    }

    private static int adjustYear(int y) {
        return y + (y < 100 ? (y < 30 ? 2000 : 1900) : 0);
    }

    public static OleDateTime createDate(int y, int m, int d) {
        Date date;
        block3: {
            Calendar calendar = DateUtils.getCalendar();
            calendar.clear();
            calendar.set(DateUtils.adjustYear(y), m - 1, d);
            date = new Date(1L);
            try {
                date = calendar.getTime();
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().startsWith("DAY")) {
                    throw new DateInvalidArgumentException(m, d, y);
                }
                if (e.getMessage() == null || !e.getMessage().startsWith("MONTH")) break block3;
                throw new MonthInvalidArgumentException(m, d, y);
            }
        }
        return new OleDateTime(date);
    }

    public static OleDateTime createTime(int hour, int min, int sec, int millisecond) {
        Calendar calendar = DateUtils.getCalendar();
        calendar.clear();
        calendar.set(1899, 11, 30, hour, min, sec);
        calendar.set(14, millisecond);
        return new OleDateTime(calendar.getTime());
    }

    public static int getYear(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(1);
    }

    public static Date setYear(Date date, int year) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.set(1, year);
        date.setYear(calendar.get(1) - 1900);
        return date;
    }

    public static int getQuarter(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return 1 + calendar.get(2) / 3;
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return 1 + calendar.get(2);
    }

    public static Date setMonth(Date date, int month) {
        date.setMonth(month - 1);
        return date;
    }

    public static Date setDay(Date date, int day) {
        date.setDate(day);
        return date;
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(11);
    }

    public static Date setHour(Date date, int hour) {
        date.setHours(hour);
        return date;
    }

    public static int getMinute(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(12);
    }

    public static Date setMinute(Date date, int minute) {
        date.setMinutes(minute);
        return date;
    }

    public static int getSecond(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(13);
    }

    public static Date setSecond(Date date, int second) {
        date.setSeconds(second);
        return date;
    }

    public static int getMillisecond(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(14);
    }

    public static Date setMillisecond(Date date, int millisecond) {
        date.setTime(date.getTime() + (long)millisecond);
        return date;
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(7);
    }

    public static int getDayOfWeek(Date date, String mask) {
        Calendar calendar = null;
        if (mask != null) {
            calendar = Calendar.getInstance(Locale.US);
            if (mask.toLowerCase().equals("iso")) {
                calendar.setTime(date);
                LocalDate date1 = LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                return date1.getDayOfWeek().getValue();
            }
            if (mask.toLowerCase().equalsIgnoreCase("gregorian")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
                gregorianCalendar.setFirstDayOfWeek(1);
                gregorianCalendar.setTime(date);
                return gregorianCalendar.get(7);
            }
        }
        calendar = DateUtils.getCalendar(date);
        return calendar.get(7);
    }

    public static int getFirstDayOfMonth(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        calendar.set(5, 1);
        return calendar.get(6);
    }

    public static int getDayOfYear(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.get(6);
    }

    public static int getDaysInMonth(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.getActualMaximum(5);
    }

    public static int getDaysInYear(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        return calendar.getActualMaximum(6);
    }

    public static String getDayOfWeekAsString(int dayofweek, String locale) {
        if (dayofweek < 1 || dayofweek > 7) {
            throw new IllegalNumRangeException(dayofweek, 1, 7);
        }
        Calendar calendar = DateUtils.getCalendar();
        calendar.clear();
        calendar.set(7, dayofweek);
        CFLocale cflocale = CFLocaleMgr.getMgr().getCFLocale(locale);
        return cflocale.FormatDate(calendar.getTime(), "dddd");
    }

    public static String getMonthAsString(int month, String locale) {
        if (month < 1 || month > 12) {
            throw new IllegalNumRangeException(month, 1, 12);
        }
        Calendar calendar = DateUtils.getCalendar();
        calendar.clear();
        calendar.set(2, month - 1);
        CFLocale cflocale = CFLocaleMgr.getMgr().getCFLocale(locale);
        return cflocale.FormatDate(calendar.getTime(), "MMMM");
    }

    public static String getTypeFromMask(String mask) {
        String type = null;
        if (mask != null && !mask.isEmpty()) {
            String lowerCaseMask = mask.toLowerCase().trim();
            if (lowerCaseMask.equals("short") || lowerCaseMask.equals("medium") || lowerCaseMask.equals("long") || lowerCaseMask.equals("full")) {
                return "datetime";
            }
            if (lowerCaseMask.contains("d") || lowerCaseMask.contains("y") || lowerCaseMask.contains("m") || lowerCaseMask.contains("e") || lowerCaseMask.contains("f") || lowerCaseMask.contains("k") || lowerCaseMask.contains("w") || lowerCaseMask.contains("gg") || lowerCaseMask.contains("z") || lowerCaseMask.contains("x")) {
                type = "date";
            }
            if (lowerCaseMask.contains("h") || lowerCaseMask.contains("n") || lowerCaseMask.contains("s") || lowerCaseMask.contains("l") || lowerCaseMask.contains("t") || lowerCaseMask.contains("z") || lowerCaseMask.contains("x")) {
                type = "date".equals(type) ? "datetime" : "time";
            }
        }
        return type;
    }

    public static void validateDateFormatMask(String convertedMask, String origMask) {
        if (convertedMask == null) {
            throw new InvalidDateFormatMaskException(origMask);
        }
    }

    public static class InvalidDateConversionTypeException
    extends ExpressionException {
        public String type;

        InvalidDateConversionTypeException(String type) {
            this.type = type;
        }
    }

    public static class InvalidDateDSTException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String time;
        public String timezone;
        public String hour;
        public String method;

        InvalidDateDSTException(int hour, String time, String timezone, String method) {
            this.time = time;
            this.timezone = timezone;
            this.method = method;
            this.hour = "'" + hour + "'";
        }
    }

    public static class InvalidDateException
    extends ExpressionException {
        public String name;

        InvalidDateException(String name) {
            this.name = name;
        }
    }

    public static class InvalidDateFormatMaskException
    extends ExpressionException {
        public String mask;

        InvalidDateFormatMaskException(String mask) {
            this.mask = mask;
        }
    }
}

