/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.util.concurrent.Semaphore;

public class DynamicSemaphore
extends Semaphore {
    int limit;

    public DynamicSemaphore(int i) {
        super(i);
        this.limit = i;
    }

    public DynamicSemaphore(int i, boolean b) {
        super(i, b);
        this.limit = i;
    }

    public synchronized void setLimit(int newlimit) {
        if (newlimit == this.limit) {
            return;
        }
        if (newlimit > this.limit) {
            int diff = newlimit - this.limit;
            this.release(diff);
        } else {
            int diff = this.limit - newlimit;
            this.reducePermits(diff);
        }
        this.limit = newlimit;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getPermitsGranted() {
        return this.limit - this.availablePermits();
    }
}

