/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.com.ibm.icu.text.CharsetDetector;
import coldfusion.com.ibm.icu.text.CharsetMatch;
import coldfusion.util.RB;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class EncodingDetector {
    private static final int DEFAULT_MIN_CONFIDENCE_THRESHHOLD = 100;
    private static final int MIN_CONFIDENCE_THRESHHOLD;
    private static final String CHARSET_DETECT_MINTHRESHHOLD_PROPERTY = "coldfusion.charsetdetection.minthreshhold";
    private int confidence = MIN_CONFIDENCE_THRESHHOLD;
    private boolean enableInputFilter;
    private String declaredEncoding;

    public EncodingDetector() {
    }

    public EncodingDetector(boolean enableInputFilter) {
        this.enableInputFilter = enableInputFilter;
    }

    public EncodingDetector(int minConfidence, boolean enableInputFilter, String declaredEncoding) {
        this.setConfidence(minConfidence);
        this.enableInputFilter = enableInputFilter;
        this.declaredEncoding = declaredEncoding;
    }

    public InputStreamReader getReader(BufferedInputStream stream) throws IOException {
        return this.getReader(stream, null);
    }

    public InputStreamReader getReader(BufferedInputStream stream, String defaultEncoding) throws IOException {
        String detectedCharset = this.detectEncoding(stream);
        if (detectedCharset != null) {
            return new InputStreamReader((InputStream)stream, detectedCharset);
        }
        if (StringUtils.isNotBlank((CharSequence)defaultEncoding)) {
            return new InputStreamReader((InputStream)stream, defaultEncoding);
        }
        return new InputStreamReader(stream);
    }

    public InputStreamReader getReader(BufferedInputStream stream, String defaultEncoding, String providedEncoding) throws IOException {
        if (StringUtils.isBlank((CharSequence)providedEncoding)) {
            return this.getReader(stream, defaultEncoding);
        }
        return new InputStreamReader((InputStream)stream, providedEncoding);
    }

    public String detectEncoding(BufferedInputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        CharsetMatch match = this.getDetector(stream).detect();
        if (match != null) {
            if (match.getConfidence() < this.confidence) {
                return null;
            }
            if (Charset.isSupported(match.getName())) {
                return match.getName();
            }
        }
        return null;
    }

    public String detectEncoding(byte[] text) throws IOException {
        if (text == null || text.length == 0) {
            return null;
        }
        CharsetMatch match = this.getDetector(text).detect();
        if (match != null) {
            if (match.getConfidence() < this.confidence) {
                return null;
            }
            if (Charset.isSupported(match.getName())) {
                return match.getName();
            }
        }
        return null;
    }

    private CharsetDetector getDetector(BufferedInputStream stream) throws IOException {
        CharsetDetector detector = this.getDetector();
        detector.setText((InputStream)stream);
        return detector;
    }

    private CharsetDetector getDetector(byte[] text) throws IOException {
        CharsetDetector detector = this.getDetector();
        detector.setText(text);
        return detector;
    }

    private CharsetDetector getDetector() throws IOException {
        CharsetDetector detector = new CharsetDetector();
        detector.enableInputFilter(this.enableInputFilter);
        detector.setDeclaredEncoding(this.declaredEncoding);
        return detector;
    }

    public static String[] getDetectableCharsets(boolean checkJavaSupport) {
        if (!checkJavaSupport) {
            return CharsetDetector.getAllDetectableCharsets();
        }
        String[] allCharsets = CharsetDetector.getAllDetectableCharsets();
        ArrayList<String> supportedCharsets = new ArrayList<String>();
        for (String current : allCharsets) {
            if (!Charset.isSupported(current)) continue;
            supportedCharsets.add(current);
        }
        return supportedCharsets.toArray(new String[supportedCharsets.size()]);
    }

    public static Charset[] getDetectableCharsets() {
        String[] allCharsets = CharsetDetector.getAllDetectableCharsets();
        ArrayList<Charset> supportedCharsets = new ArrayList<Charset>();
        for (String current : allCharsets) {
            if (!Charset.isSupported(current)) continue;
            supportedCharsets.add(Charset.forName(current));
        }
        return supportedCharsets.toArray(new Charset[supportedCharsets.size()]);
    }

    public String getDeclaredEncoding() {
        return this.declaredEncoding;
    }

    public void setDeclaredEncoding(String declaredEncoding) {
        this.declaredEncoding = declaredEncoding;
    }

    public boolean isEnableInputFilter() {
        return this.enableInputFilter;
    }

    public void setEnableInputFilter(boolean enableInputFilter) {
        this.enableInputFilter = enableInputFilter;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public void setConfidence(int confidence) {
        if (confidence < 1 && confidence > 100) {
            throw new IllegalArgumentException(RB.getString((Object)this, "EncodingDetectionUtils.InvalidConfidence", confidence));
        }
        this.confidence = confidence;
    }

    static {
        int threshhold = Integer.getInteger(CHARSET_DETECT_MINTHRESHHOLD_PROPERTY, 100);
        MIN_CONFIDENCE_THRESHHOLD = threshhold < 1 || threshhold > 100 ? 100 : threshhold;
    }
}

